/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.AttributesDefaults;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.util.PsiUtil;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;

public class CreateModuleInfoAction
extends CreateFromTemplateActionBase {
    public CreateModuleInfoAction() {
        super(IdeBundle.message((String)"action.create.new.module-info.title", (Object[])new Object[0]), IdeBundle.message((String)"action.create.new.module-info.description", (Object[])new Object[0]), AllIcons.FileTypes.Java);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/CreateModuleInfoAction", "update"));
        }
        DataContext ctx = e.getDataContext();
        boolean available = Optional.ofNullable(LangDataKeys.IDE_VIEW.getData(ctx)).map(view -> this.getTargetDirectory(ctx, (IdeView)view)).filter(PsiUtil::isLanguageLevel9OrHigher).map(ModuleUtilCore::findModuleForPsiElement).map(module2 -> FilenameIndex.getVirtualFilesByName(module2.getProject(), "module-info.java", module2.getModuleScope(false)).isEmpty()).orElse(false);
        e.getPresentation().setEnabledAndVisible(available);
    }

    @Override
    @Nullable
    protected PsiDirectory getTargetDirectory(DataContext dataContext, IdeView view) {
        ProjectFileIndex index;
        PsiDirectory psiDir;
        VirtualFile vDir;
        PsiDirectory[] directories = view.getDirectories();
        if (directories.length == 1 && (vDir = (psiDir = directories[0]).getVirtualFile()).equals((index = ProjectRootManager.getInstance((Project)psiDir.getProject()).getFileIndex()).getSourceRootForFile(vDir)) && index.isUnderSourceRootOfType(vDir, Collections.singleton(JavaSourceRootType.SOURCE))) {
            return psiDir;
        }
        return null;
    }

    @Override
    protected FileTemplate getTemplate(@NotNull Project project2, @NotNull PsiDirectory dir) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/CreateModuleInfoAction", "getTemplate"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/ide/actions/CreateModuleInfoAction", "getTemplate"));
        }
        FileTemplate template = FileTemplateManager.getInstance(project2).getInternalTemplate("module-info");
        template.setLiveTemplateEnabled(true);
        return template;
    }

    @Override
    public AttributesDefaults getAttributesDefaults(@NotNull DataContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctx", "com/intellij/ide/actions/CreateModuleInfoAction", "getAttributesDefaults"));
        }
        AttributesDefaults defaults = new AttributesDefaults("module-info").withFixedName(true);
        CreateModuleInfoAction.copyDefaultProperties(ctx, defaults);
        defaults.addPredefined("MODULE_NAME", "$module_name$");
        return defaults;
    }

    private static void copyDefaultProperties(DataContext ctx, AttributesDefaults defaults) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(ctx);
        if (project2 != null) {
            Properties props = FileTemplateManager.getInstance(project2).getDefaultProperties();
            props.stringPropertyNames().forEach(name -> defaults.addPredefined((String)name, props.getProperty((String)name)));
        }
    }
}

