/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class ApplyIntentionAction
extends AnAction {
    private final IntentionAction myAction;
    private final Editor myEditor;
    private final PsiFile myFile;

    public ApplyIntentionAction(HighlightInfo.IntentionActionDescriptor descriptor, String text, Editor editor, PsiFile file2) {
        this(descriptor.getAction(), text, editor, file2);
    }

    public ApplyIntentionAction(IntentionAction action, String text, Editor editor, PsiFile file2) {
        super(text);
        this.myAction = action;
        this.myEditor = editor;
        this.myFile = file2;
    }

    public void actionPerformed(AnActionEvent e) {
        PsiDocumentManager.getInstance((Project)this.myFile.getProject()).commitAllDocuments();
        ShowIntentionActionsHandler.chooseActionAndInvoke(this.myFile, this.myEditor, this.myAction, this.myAction.getText());
    }

    public String getName() {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return ApplyIntentionAction.this.myAction.getText();
            }
        });
    }

    @Nullable
    public static ApplyIntentionAction[] getAvailableIntentions(Editor editor, PsiFile file2) {
        ShowIntentionsPass.IntentionsInfo info = new ShowIntentionsPass.IntentionsInfo();
        ApplicationManager.getApplication().runReadAction(() -> ShowIntentionsPass.getActionsToShow(editor, file2, info, -1));
        if (info.isEmpty()) {
            return null;
        }
        ArrayList<HighlightInfo.IntentionActionDescriptor> actions = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        actions.addAll(info.errorFixesToShow);
        actions.addAll(info.inspectionFixesToShow);
        actions.addAll(info.intentionsToShow);
        ApplyIntentionAction[] result2 = new ApplyIntentionAction[actions.size()];
        for (int i2 = 0; i2 < result2.length; ++i2) {
            final HighlightInfo.IntentionActionDescriptor descriptor = (HighlightInfo.IntentionActionDescriptor)actions.get(i2);
            String actionText = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return descriptor.getAction().getText();
                }
            });
            result2[i2] = new ApplyIntentionAction(descriptor, actionText, editor, file2);
        }
        return result2;
    }
}

