/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.templateLanguages;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.templateLanguages.BlockWithParent;
import com.intellij.formatting.templateLanguages.DataLanguageBlockFragmentWrapper;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlock;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BlockUtil {
    private BlockUtil() {
    }

    public static List<DataLanguageBlockWrapper> buildChildWrappers(@NotNull Block parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/formatting/templateLanguages/BlockUtil", "buildChildWrappers"));
        }
        assert (!(parent instanceof DataLanguageBlockWrapper)) : parent.getClass();
        List children2 = parent.getSubBlocks();
        if (children2.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<DataLanguageBlockWrapper> result2 = new ArrayList<DataLanguageBlockWrapper>(children2.size());
        DataLanguageBlockWrapper prevWrapper = null;
        for (Block child : children2) {
            DataLanguageBlockWrapper currWrapper = BlockUtil.createAndAddBlock(result2, child, null);
            if (currWrapper != null && prevWrapper != null) {
                Spacing spacing = parent.getSpacing(prevWrapper.getOriginal(), currWrapper.getOriginal());
                prevWrapper.setRightHandSpacing(currWrapper, spacing);
            }
            prevWrapper = currWrapper;
        }
        return result2;
    }

    public static Pair<List<DataLanguageBlockWrapper>, List<DataLanguageBlockWrapper>> splitBlocksByRightBound(@NotNull Block parent, @NotNull TextRange bounds) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/formatting/templateLanguages/BlockUtil", "splitBlocksByRightBound"));
        }
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/formatting/templateLanguages/BlockUtil", "splitBlocksByRightBound"));
        }
        List subBlocks = parent.getSubBlocks();
        if (subBlocks.size() == 0) {
            return Pair.create(Collections.emptyList(), Collections.emptyList());
        }
        ArrayList<DataLanguageBlockWrapper> before = new ArrayList<DataLanguageBlockWrapper>(subBlocks.size() / 2);
        ArrayList<DataLanguageBlockWrapper> after2 = new ArrayList<DataLanguageBlockWrapper>(subBlocks.size() / 2);
        BlockUtil.splitByRightBoundAndCollectBlocks(subBlocks, before, after2, bounds);
        return new Pair(before, after2);
    }

    private static void splitByRightBoundAndCollectBlocks(@NotNull List<Block> blocks, @NotNull List<DataLanguageBlockWrapper> before, @NotNull List<DataLanguageBlockWrapper> after2, @NotNull TextRange bounds) {
        if (blocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocks", "com/intellij/formatting/templateLanguages/BlockUtil", "splitByRightBoundAndCollectBlocks"));
        }
        if (before == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "com/intellij/formatting/templateLanguages/BlockUtil", "splitByRightBoundAndCollectBlocks"));
        }
        if (after2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "after", "com/intellij/formatting/templateLanguages/BlockUtil", "splitByRightBoundAndCollectBlocks"));
        }
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/formatting/templateLanguages/BlockUtil", "splitByRightBoundAndCollectBlocks"));
        }
        for (Block block : blocks) {
            TextRange textRange = block.getTextRange();
            if (bounds.contains(textRange)) {
                BlockUtil.createAndAddBlock(before, block, null);
                continue;
            }
            if (bounds.getEndOffset() <= textRange.getStartOffset()) {
                BlockUtil.createAndAddBlock(after2, block, null);
                continue;
            }
            BlockUtil.splitByRightBoundAndCollectBlocks(block.getSubBlocks(), before, after2, bounds);
        }
    }

    @Nullable
    private static DataLanguageBlockWrapper createAndAddBlock(List<DataLanguageBlockWrapper> list, Block block, @Nullable Indent indent) {
        DataLanguageBlockWrapper wrapper = DataLanguageBlockWrapper.create(block, indent);
        if (wrapper != null) {
            list.add(wrapper);
        }
        return wrapper;
    }

    public static List<Block> mergeBlocks(@NotNull List<TemplateLanguageBlock> tlBlocks, @NotNull List<DataLanguageBlockWrapper> foreignBlocks) {
        if (tlBlocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tlBlocks", "com/intellij/formatting/templateLanguages/BlockUtil", "mergeBlocks"));
        }
        if (foreignBlocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreignBlocks", "com/intellij/formatting/templateLanguages/BlockUtil", "mergeBlocks"));
        }
        ArrayList<Block> result2 = new ArrayList<Block>(tlBlocks.size() + foreignBlocks.size());
        int vInd = 0;
        int fInd = 0;
        while (vInd < tlBlocks.size() && fInd < foreignBlocks.size()) {
            int lastContainedTlInd;
            TemplateLanguageBlock v = tlBlocks.get(vInd);
            DataLanguageBlockWrapper f = foreignBlocks.get(fInd);
            TextRange vRange = v.getTextRange();
            TextRange fRange = f.getTextRange();
            if (vRange.getStartOffset() >= fRange.getEndOffset()) {
                result2.add(f);
                ++fInd;
                continue;
            }
            if (vRange.getEndOffset() <= fRange.getStartOffset()) {
                result2.add((Block)v);
                ++vInd;
                continue;
            }
            if (vRange.getStartOffset() < fRange.getStartOffset() || vRange.getStartOffset() == fRange.getStartOffset() && vRange.getEndOffset() >= fRange.getEndOffset()) {
                DataLanguageBlockWrapper notContainedF;
                result2.add((Block)v);
                while (fInd < foreignBlocks.size() && vRange.contains(foreignBlocks.get(fInd).getTextRange())) {
                    v.addForeignChild(foreignBlocks.get(fInd++));
                }
                if (fInd < foreignBlocks.size() && vRange.intersectsStrict((notContainedF = foreignBlocks.get(fInd)).getTextRange())) {
                    Pair<List<DataLanguageBlockWrapper>, List<DataLanguageBlockWrapper>> splitBlocks = BlockUtil.splitBlocksByRightBound(notContainedF.getOriginal(), vRange);
                    v.addForeignChildren((List)splitBlocks.getFirst());
                    foreignBlocks.remove(fInd);
                    if (((List)splitBlocks.getSecond()).size() > 0) {
                        foreignBlocks.addAll(fInd, (Collection)splitBlocks.getSecond());
                    }
                }
                ++vInd;
                continue;
            }
            if (vRange.getStartOffset() <= fRange.getStartOffset() && (vRange.getStartOffset() != fRange.getStartOffset() || vRange.getEndOffset() >= fRange.getEndOffset())) continue;
            for (lastContainedTlInd = vInd; lastContainedTlInd < tlBlocks.size() && fRange.intersectsStrict(tlBlocks.get(lastContainedTlInd).getTextRange()); ++lastContainedTlInd) {
            }
            if (fRange.contains(tlBlocks.get(lastContainedTlInd - 1).getTextRange())) {
                result2.add(f);
                ++fInd;
                while (vInd < lastContainedTlInd) {
                    f.addTlChild(tlBlocks.get(vInd++));
                }
                continue;
            }
            foreignBlocks.remove(fInd);
            foreignBlocks.addAll(fInd, BlockUtil.buildChildWrappers(f.getOriginal()));
        }
        while (vInd < tlBlocks.size()) {
            result2.add((Block)tlBlocks.get(vInd++));
        }
        while (fInd < foreignBlocks.size()) {
            result2.add(foreignBlocks.get(fInd++));
        }
        return result2;
    }

    @NotNull
    public static List<DataLanguageBlockWrapper> filterBlocksByRange(@NotNull List<DataLanguageBlockWrapper> list, @NotNull TextRange textRange) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/formatting/templateLanguages/BlockUtil", "filterBlocksByRange"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/formatting/templateLanguages/BlockUtil", "filterBlocksByRange"));
        }
        int i2 = 0;
        while (i2 < list.size()) {
            DataLanguageBlockWrapper wrapper = list.get(i2);
            TextRange range = wrapper.getTextRange();
            if (textRange.contains(range)) {
                ++i2;
                continue;
            }
            if (range.intersectsStrict(textRange)) {
                list.remove(i2);
                list.addAll(i2, BlockUtil.buildChildWrappers(wrapper.getOriginal()));
                continue;
            }
            list.remove(i2);
        }
        List<DataLanguageBlockWrapper> list2 = list;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/templateLanguages/BlockUtil", "filterBlocksByRange"));
        }
        return list2;
    }

    static List<Block> splitBlockIntoFragments(@NotNull Block block, @NotNull List<TemplateLanguageBlock> subBlocks) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/formatting/templateLanguages/BlockUtil", "splitBlockIntoFragments"));
        }
        if (subBlocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subBlocks", "com/intellij/formatting/templateLanguages/BlockUtil", "splitBlockIntoFragments"));
        }
        ArrayList<Block> children2 = new ArrayList<Block>(5);
        TextRange range = block.getTextRange();
        int childStartOffset = range.getStartOffset();
        TemplateLanguageBlock lastTLBlock = null;
        for (TemplateLanguageBlock tlBlock : subBlocks) {
            TextRange dataBlockTextRange;
            TextRange tlTextRange = tlBlock.getTextRange();
            if (tlTextRange.getStartOffset() > childStartOffset && tlBlock.isRequiredRange(dataBlockTextRange = new TextRange(childStartOffset, tlTextRange.getStartOffset()))) {
                children2.add(new DataLanguageBlockFragmentWrapper(block, dataBlockTextRange));
            }
            children2.add((Block)tlBlock);
            lastTLBlock = tlBlock;
            childStartOffset = tlTextRange.getEndOffset();
        }
        if (range.getEndOffset() > childStartOffset) {
            TextRange dataBlockTextRange = new TextRange(childStartOffset, range.getEndOffset());
            if (lastTLBlock == null || lastTLBlock.isRequiredRange(dataBlockTextRange)) {
                children2.add(new DataLanguageBlockFragmentWrapper(block, dataBlockTextRange));
            }
        }
        return children2;
    }

    static void printBlocks(@Nullable TextRange textRange, @NotNull List<Block> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/formatting/templateLanguages/BlockUtil", "printBlocks"));
        }
        StringBuilder sb = new StringBuilder(String.valueOf(textRange)).append(": ");
        for (Block block : list) {
            ASTNode node = block instanceof ASTBlock ? ((ASTBlock)block).getNode() : null;
            TextRange r = block.getTextRange();
            sb.append(" [").append(node != null ? node.getElementType() : null).append(r).append(block.getIndent()).append(block.getAlignment()).append("] ");
        }
        System.out.println(sb);
    }

    static List<Block> setParent(List<Block> children2, BlockWithParent parent) {
        for (Block block : children2) {
            if (!(block instanceof BlockWithParent)) continue;
            ((BlockWithParent)block).setParent(parent);
        }
        return children2;
    }
}

