/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.InitialInfoBuilder;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.engine.AlignmentHelper;
import com.intellij.formatting.engine.BlockIndentOptions;
import com.intellij.formatting.engine.BlockRangesMap;
import com.intellij.formatting.engine.DependentSpacingEngine;
import com.intellij.formatting.engine.ExpandableIndent;
import com.intellij.formatting.engine.IndentAdjuster;
import com.intellij.formatting.engine.State;
import com.intellij.formatting.engine.WrapProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.containers.MultiMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WrapBlocksState
extends State {
    private final InitialInfoBuilder myWrapper;
    private final BlockIndentOptions myBlockIndentOptions;
    private WhiteSpace myLastWhiteSpace;
    private BlockRangesMap myBlockRangesMap;
    private DependentSpacingEngine myDependentSpacingEngine;
    private AlignmentHelper myAlignmentHelper;
    private IndentAdjuster myIndentAdjuster;
    private WrapProcessor myWrapProcessor;

    public WrapBlocksState(@NotNull InitialInfoBuilder initialInfoBuilder, BlockIndentOptions blockIndentOptions) {
        if (initialInfoBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialInfoBuilder", "com/intellij/formatting/engine/WrapBlocksState", "<init>"));
        }
        this.myWrapper = initialInfoBuilder;
        this.myBlockIndentOptions = blockIndentOptions;
    }

    @Override
    public void doIteration() {
        if (this.isDone()) {
            return;
        }
        this.setDone(this.myWrapper.iteration());
    }

    public Map<AbstractBlockWrapper, Block> getBlockToInfoMap() {
        return this.myWrapper.getBlockToInfoMap();
    }

    public LeafBlockWrapper getFirstBlock() {
        this.assertDone();
        return this.myWrapper.getFirstTokenBlock();
    }

    public LeafBlockWrapper getLastBlock() {
        this.assertDone();
        return this.myWrapper.getLastTokenBlock();
    }

    public WhiteSpace getLastWhiteSpace() {
        this.assertDone();
        if (this.myLastWhiteSpace == null) {
            int lastBlockOffset = this.getLastBlock().getEndOffset();
            this.myLastWhiteSpace = new WhiteSpace(lastBlockOffset, false);
            FormattingDocumentModel model = this.myWrapper.getFormattingDocumentModel();
            CommonCodeStyleSettings.IndentOptions options = this.myBlockIndentOptions.getIndentOptions();
            this.myLastWhiteSpace.changeEndOffset(Math.max(lastBlockOffset, this.myWrapper.getEndOffset()), model, options);
        }
        return this.myLastWhiteSpace;
    }

    public BlockRangesMap getBlockRangesMap() {
        this.assertDone();
        if (this.myBlockRangesMap == null) {
            this.myBlockRangesMap = new BlockRangesMap(this.getFirstBlock(), this.getLastBlock());
        }
        return this.myBlockRangesMap;
    }

    public DependentSpacingEngine getDependentSpacingEngine() {
        this.assertDone();
        if (this.myDependentSpacingEngine == null) {
            this.myDependentSpacingEngine = new DependentSpacingEngine(this.getBlockRangesMap());
        }
        return this.myDependentSpacingEngine;
    }

    public Set<Alignment> getAlignmentsInsideRangesToModify() {
        this.assertDone();
        return this.myWrapper.getAlignmentsInsideRangeToModify();
    }

    public AlignmentHelper getAlignmentHelper() {
        this.assertDone();
        if (this.myAlignmentHelper == null) {
            Document document = this.myWrapper.getFormattingDocumentModel().getDocument();
            this.myAlignmentHelper = new AlignmentHelper(document, this.myWrapper.getBlocksToAlign(), this.myBlockIndentOptions);
        }
        return this.myAlignmentHelper;
    }

    public IndentAdjuster getIndentAdjuster() {
        this.assertDone();
        if (this.myIndentAdjuster == null) {
            this.myIndentAdjuster = new IndentAdjuster(this.myBlockIndentOptions, this.getAlignmentHelper());
        }
        return this.myIndentAdjuster;
    }

    public MultiMap<ExpandableIndent, AbstractBlockWrapper> getExpandableIndent() {
        this.assertDone();
        return this.myWrapper.getExpandableIndentsBlocks();
    }

    public WrapProcessor getWrapProcessor() {
        this.assertDone();
        if (this.myWrapProcessor == null) {
            int rightMargin = this.myBlockIndentOptions.getRightMargin();
            this.myWrapProcessor = new WrapProcessor(this.myBlockRangesMap, this.getIndentAdjuster(), rightMargin);
        }
        return this.myWrapProcessor;
    }

    public BlockIndentOptions getBlockIndentOptions() {
        return this.myBlockIndentOptions;
    }

    private void assertDone() {
        if (!this.isDone()) {
            throw new IllegalStateException();
        }
    }
}

