/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.AlignmentImpl;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormatProcessor;
import com.intellij.formatting.IndentData;
import com.intellij.formatting.IndentInfo;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.engine.AlignmentHelper;
import com.intellij.formatting.engine.BlockIndentOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.Nullable;

public class IndentAdjuster {
    private final AlignmentHelper myAlignmentHelper;
    private final BlockIndentOptions myBlockIndentOptions;

    public IndentAdjuster(BlockIndentOptions blockIndentOptions, AlignmentHelper alignmentHelper) {
        this.myAlignmentHelper = alignmentHelper;
        this.myBlockIndentOptions = blockIndentOptions;
    }

    public LeafBlockWrapper adjustIndent(LeafBlockWrapper block) {
        AlignmentImpl alignment = CoreFormatterUtil.getAlignment(block);
        WhiteSpace whiteSpace = block.getWhiteSpace();
        if (alignment == null || this.myAlignmentHelper.shouldSkip(alignment)) {
            if (whiteSpace.containsLineFeeds()) {
                this.adjustSpacingByIndentOffset(block);
            } else {
                whiteSpace.arrangeSpaces(block.getSpaceProperty());
            }
            return null;
        }
        return this.myAlignmentHelper.applyAlignment(alignment, block);
    }

    private void adjustSpacingByIndentOffset(LeafBlockWrapper block) {
        CommonCodeStyleSettings.IndentOptions options = this.myBlockIndentOptions.getIndentOptions(block);
        IndentData offset = block.calculateOffset(options);
        block.getWhiteSpace().setSpaces(offset.getSpaces(), offset.getIndentSpaces());
    }

    public void adjustLineIndent(LeafBlockWrapper myCurrentBlock) {
        IndentData alignOffset = IndentAdjuster.getAlignOffset(myCurrentBlock);
        if (alignOffset == null) {
            this.adjustSpacingByIndentOffset(myCurrentBlock);
        } else {
            myCurrentBlock.getWhiteSpace().setSpaces(alignOffset.getSpaces(), alignOffset.getIndentSpaces());
        }
    }

    @Nullable
    private static IndentData getAlignOffset(LeafBlockWrapper myCurrentBlock) {
        AbstractBlockWrapper current = myCurrentBlock;
        do {
            LeafBlockWrapper offsetResponsibleBlock;
            AlignmentImpl alignment;
            if ((alignment = current.getAlignment()) == null || (offsetResponsibleBlock = alignment.getOffsetRespBlockBefore(myCurrentBlock)) == null) continue;
            WhiteSpace whiteSpace = offsetResponsibleBlock.getWhiteSpace();
            if (whiteSpace.containsLineFeeds()) {
                return new IndentData(whiteSpace.getIndentSpaces(), whiteSpace.getSpaces());
            }
            int offsetBeforeBlock = CoreFormatterUtil.getStartColumn(offsetResponsibleBlock);
            AbstractBlockWrapper indentedParentBlock = CoreFormatterUtil.getIndentedParentBlock(myCurrentBlock);
            if (indentedParentBlock == null) {
                return new IndentData(0, offsetBeforeBlock);
            }
            int parentIndent = indentedParentBlock.getWhiteSpace().getIndentOffset();
            if (parentIndent > offsetBeforeBlock) {
                return new IndentData(0, offsetBeforeBlock);
            }
            return new IndentData(parentIndent, offsetBeforeBlock - parentIndent);
        } while ((current = current.getParent()) != null && current.getStartOffset() == myCurrentBlock.getStartOffset());
        return null;
    }

    public IndentInfo adjustLineIndent(LeafBlockWrapper currentBlock, FormatProcessor.ChildAttributesInfo info) {
        AbstractBlockWrapper parent = info.parent;
        ChildAttributes childAttributes = info.attributes;
        int index = info.index;
        int alignOffset = IndentAdjuster.getAlignOffsetBefore(childAttributes.getAlignment(), null);
        if (alignOffset == -1) {
            return parent.calculateChildOffset(this.myBlockIndentOptions.getIndentOptions(parent), childAttributes, index).createIndentInfo();
        }
        AbstractBlockWrapper indentedParentBlock = CoreFormatterUtil.getIndentedParentBlock(currentBlock);
        if (indentedParentBlock == null) {
            return new IndentInfo(0, 0, alignOffset);
        }
        int indentOffset = indentedParentBlock.getWhiteSpace().getIndentOffset();
        if (indentOffset > alignOffset) {
            return new IndentInfo(0, 0, alignOffset);
        }
        return new IndentInfo(0, indentOffset, alignOffset - indentOffset);
    }

    private static int getAlignOffsetBefore(@Nullable Alignment alignment, @Nullable LeafBlockWrapper blockAfter) {
        if (alignment == null) {
            return -1;
        }
        LeafBlockWrapper alignRespBlock = ((AlignmentImpl)alignment).getOffsetRespBlockBefore(blockAfter);
        if (alignRespBlock != null) {
            return CoreFormatterUtil.getStartColumn(alignRespBlock);
        }
        return -1;
    }
}

