/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.IndentInfo;
import com.intellij.formatting.WhiteSpace;

public class IndentData {
    private int myIndentSpaces = 0;
    private int mySpaces = 0;

    public IndentData(int indentSpaces, int spaces) {
        this.myIndentSpaces = indentSpaces;
        this.mySpaces = spaces;
    }

    public IndentData(int indentSpaces) {
        this(indentSpaces, 0);
    }

    public int getTotalSpaces() {
        return this.mySpaces + this.myIndentSpaces;
    }

    public int getIndentSpaces() {
        return this.myIndentSpaces;
    }

    public int getSpaces() {
        return this.mySpaces;
    }

    public IndentData add(IndentData childOffset) {
        return new IndentData(this.myIndentSpaces + childOffset.getIndentSpaces(), this.mySpaces + childOffset.getSpaces());
    }

    public IndentData add(WhiteSpace whiteSpace) {
        return new IndentData(this.myIndentSpaces + whiteSpace.getIndentOffset(), this.mySpaces + whiteSpace.getSpaces());
    }

    public boolean isEmpty() {
        return this.myIndentSpaces == 0 && this.mySpaces == 0;
    }

    public IndentInfo createIndentInfo() {
        return new IndentInfo(0, this.myIndentSpaces, this.mySpaces);
    }

    public String toString() {
        return "spaces=" + this.mySpaces + ", indent spaces=" + this.myIndentSpaces;
    }
}

