/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.lineMarker;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineMarkerActionWrapper
extends AnAction {
    public static final Key<Pair<PsiElement, MyDataContext>> LOCATION_WRAPPER = Key.create((String)"LOCATION_WRAPPER");
    protected final PsiElement myElement;
    private final AnAction myOrigin;

    public LineMarkerActionWrapper(PsiElement element, @NotNull AnAction origin) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "com/intellij/execution/lineMarker/LineMarkerActionWrapper", "<init>"));
        }
        this.myElement = element;
        this.myOrigin = origin;
        this.copyFrom(origin);
    }

    public void update(AnActionEvent e) {
        this.myOrigin.update(this.wrapEvent(e));
    }

    @NotNull
    private AnActionEvent wrapEvent(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Pair pair = (Pair)DataManager.getInstance().loadFromDataContext(dataContext, LOCATION_WRAPPER);
        if (pair == null || pair.first != this.myElement) {
            pair = Pair.pair((Object)this.myElement, (Object)((Object)new MyDataContext(dataContext)));
            DataManager.getInstance().saveInDataContext(dataContext, LOCATION_WRAPPER, (Object)pair);
        }
        AnActionEvent anActionEvent = new AnActionEvent(e.getInputEvent(), (DataContext)pair.second, e.getPlace(), e.getPresentation(), e.getActionManager(), e.getModifiers());
        if (anActionEvent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/lineMarker/LineMarkerActionWrapper", "wrapEvent"));
        }
        return anActionEvent;
    }

    public void actionPerformed(AnActionEvent e) {
        this.myOrigin.actionPerformed(this.wrapEvent(e));
    }

    private class MyDataContext
    extends UserDataHolderBase
    implements DataContext {
        private final DataContext myDelegate;

        public MyDataContext(DataContext delegate) {
            this.myDelegate = delegate;
        }

        @Nullable
        public synchronized Object getData(@NonNls String dataId) {
            if (Location.DATA_KEY.is(dataId)) {
                return LineMarkerActionWrapper.this.myElement.isValid() ? new PsiLocation(LineMarkerActionWrapper.this.myElement) : null;
            }
            return this.myDelegate.getData(dataId);
        }
    }
}

