/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.SingleClassConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringListeners {
    public static RefactoringElementListener getListener(PsiPackage psiPackage, Accessor<PsiPackage> accessor) {
        StringBuilder path = new StringBuilder();
        for (PsiPackage parent = accessor.getPsiElement(); parent != null; parent = parent.getParentPackage()) {
            if (parent.equals(psiPackage)) {
                return new RefactorPackage(accessor, path.toString());
            }
            if (path.length() > 0) {
                path.insert(0, '.');
            }
            path.insert(0, parent.getName());
        }
        return null;
    }

    public static RefactoringElementListener getListeners(PsiClass psiClass, Accessor<PsiClass> accessor) {
        PsiClass aClass = accessor.getPsiElement();
        if (aClass == null) {
            return null;
        }
        StringBuilder path = new StringBuilder();
        PsiClass parent = aClass;
        while (parent != null) {
            if (parent.equals(psiClass)) {
                return new RefactorClass(accessor, path.toString());
            }
            if (path.length() > 0) {
                path.insert(0, '$');
            }
            path.insert(0, parent.getName());
            parent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class, (boolean)true);
        }
        return null;
    }

    public static RefactoringElementListener getClassOrPackageListener(PsiElement element, Accessor<PsiClass> accessor) {
        if (element instanceof PsiClass) {
            return RefactoringListeners.getListeners((PsiClass)element, accessor);
        }
        if (element instanceof PsiPackage) {
            PsiClass aClass = accessor.getPsiElement();
            if (aClass == null) {
                return null;
            }
            return RefactoringListeners.getListener((PsiPackage)element, new ClassPackageAccessor(accessor));
        }
        return null;
    }

    private static class ClassPackageAccessor
    implements Accessor<PsiPackage> {
        private final PsiPackage myContainingPackage;
        private final Module myModule;
        private final Accessor<PsiClass> myAccessor;
        private final String myInpackageName;

        public ClassPackageAccessor(Accessor<PsiClass> accessor) {
            String inpackageName;
            this.myAccessor = accessor;
            PsiClass aClass = this.myAccessor.getPsiElement();
            aClass = (PsiClass)aClass.getOriginalElement();
            this.myContainingPackage = JavaDirectoryService.getInstance().getPackage(aClass.getContainingFile().getContainingDirectory());
            this.myModule = JavaExecutionUtil.findModule((PsiClass)aClass);
            String classQName = aClass.getQualifiedName();
            String classPackageQName = this.myContainingPackage.getQualifiedName();
            this.myInpackageName = classQName.startsWith(classPackageQName) ? (StringUtil.startsWithChar((CharSequence)(inpackageName = classQName.substring(classPackageQName.length())), (char)'.') ? inpackageName.substring(1) : inpackageName) : null;
        }

        @Override
        public PsiPackage getPsiElement() {
            return this.myContainingPackage;
        }

        @Override
        public void setPsiElement(PsiPackage psiPackage) {
            if (this.myInpackageName == null) {
                return;
            }
            String classQName = this.getClassQName(psiPackage.getQualifiedName());
            PsiClass newClass = JUnitUtil.findPsiClass(classQName, this.myModule, psiPackage.getProject());
            if (newClass != null) {
                this.myAccessor.setPsiElement(newClass);
            } else {
                this.myAccessor.setName(classQName);
            }
        }

        @Override
        public void setName(String qualifiedName) {
            this.myAccessor.setName(this.getClassQName(qualifiedName));
        }

        private String getClassQName(String packageQName) {
            if (packageQName.length() > 0) {
                return packageQName + '.' + this.myInpackageName;
            }
            return this.myInpackageName;
        }
    }

    public static class RefactorPackageByClass
    extends RenameElement<PsiClass> {
        public RefactorPackageByClass(Accessor<PsiClass> accessor) {
            super(accessor, "*");
        }

        @Override
        @Nullable
        public PsiClass findNewElement(PsiClass psiClass, String qualifiedName) {
            Module module2 = JavaExecutionUtil.findModule((PsiClass)psiClass);
            if (module2 == null) {
                return null;
            }
            return JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(qualifiedName.replace('$', '.').replace("\\*", psiClass.getName()), GlobalSearchScope.moduleScope((Module)module2));
        }

        @Override
        public String getQualifiedName(PsiClass psiClass) {
            String qualifiedName = psiClass.getQualifiedName();
            return qualifiedName != null ? StringUtil.getPackageName((String)qualifiedName) : null;
        }
    }

    private static class RefactorClass
    extends RenameElement<PsiClass> {
        public RefactorClass(Accessor<PsiClass> accessor, String path) {
            super(accessor, path);
        }

        @Override
        @Nullable
        public PsiClass findNewElement(PsiClass psiClass, String qualifiedName) {
            Module module2 = JavaExecutionUtil.findModule((PsiClass)psiClass);
            if (module2 == null) {
                return null;
            }
            return JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(qualifiedName.replace('$', '.'), GlobalSearchScope.moduleScope((Module)module2));
        }

        @Override
        public String getQualifiedName(PsiClass psiClass) {
            return psiClass.getQualifiedName();
        }
    }

    private static class RefactorPackage
    extends RenameElement<PsiPackage> {
        public RefactorPackage(Accessor<PsiPackage> accessor, String path) {
            super(accessor, path);
        }

        @Override
        public PsiPackage findNewElement(PsiPackage psiPackage, String qualifiedName) {
            return JavaPsiFacade.getInstance((Project)psiPackage.getProject()).findPackage(qualifiedName);
        }

        @Override
        public String getQualifiedName(PsiPackage psiPackage) {
            return psiPackage.getQualifiedName();
        }
    }

    private static abstract class RenameElement<T extends PsiElement>
    extends RefactoringElementAdapter
    implements UndoRefactoringElementListener {
        private final Accessor<T> myAccessor;
        private final String myPath;

        public RenameElement(Accessor<T> accessor, String path) {
            this.myAccessor = accessor;
            this.myPath = path;
        }

        public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/execution/junit/RefactoringListeners$RenameElement", "elementRenamedOrMoved"));
            }
            PsiElement newElement1 = newElement;
            String qualifiedName = this.getQualifiedName(newElement1);
            if (this.myPath.length() > 0) {
                qualifiedName = qualifiedName + "." + this.myPath;
                newElement1 = this.findNewElement(newElement1, qualifiedName);
            }
            if (newElement1 != null) {
                this.myAccessor.setPsiElement(newElement1);
            } else {
                this.myAccessor.setName(qualifiedName);
            }
        }

        @Nullable
        protected abstract T findNewElement(T var1, String var2);

        protected abstract String getQualifiedName(T var1);

        public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/execution/junit/RefactoringListeners$RenameElement", "undoElementMovedOrRenamed"));
            }
            if (oldQualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "com/intellij/execution/junit/RefactoringListeners$RenameElement", "undoElementMovedOrRenamed"));
            }
            this.myAccessor.setName(oldQualifiedName);
        }
    }

    public static class SingleClassConfigurationAccessor
    implements Accessor<PsiClass> {
        private final SingleClassConfiguration myConfiguration;

        public SingleClassConfigurationAccessor(SingleClassConfiguration configuration) {
            this.myConfiguration = configuration;
        }

        @Override
        public PsiClass getPsiElement() {
            return this.myConfiguration.getMainClass();
        }

        @Override
        public void setPsiElement(PsiClass psiClass) {
            this.myConfiguration.setMainClass(psiClass);
        }

        @Override
        public void setName(String qualifiedName) {
            this.myConfiguration.setMainClassName(qualifiedName);
        }
    }

    public static interface Accessor<T extends PsiElement> {
        public void setName(String var1);

        public T getPsiElement();

        public void setPsiElement(T var1);
    }
}

