/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import org.jetbrains.annotations.NotNull;

public class FileHyperlinkRawData {
    private final String myFilePath;
    private final int myDocumentLine;
    private final int myDocumentColumn;
    private final int myHyperlinkStartInd;
    private final int myHyperlinkEndInd;

    public FileHyperlinkRawData(@NotNull String filePath, int documentLine, int documentColumn, int hyperlinkStartInd, int hyperlinkEndInd) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/execution/filters/FileHyperlinkRawData", "<init>"));
        }
        this.myFilePath = filePath;
        this.myDocumentLine = documentLine;
        this.myDocumentColumn = documentColumn;
        this.myHyperlinkStartInd = hyperlinkStartInd;
        this.myHyperlinkEndInd = hyperlinkEndInd;
    }

    @NotNull
    public String getFilePath() {
        String string = this.myFilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/filters/FileHyperlinkRawData", "getFilePath"));
        }
        return string;
    }

    public int getDocumentLine() {
        return this.myDocumentLine;
    }

    public int getDocumentColumn() {
        return this.myDocumentColumn;
    }

    public int getHyperlinkStartInd() {
        return this.myHyperlinkStartInd;
    }

    public int getHyperlinkEndInd() {
        return this.myHyperlinkEndInd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileHyperlinkRawData data = (FileHyperlinkRawData)o;
        return this.myDocumentLine == data.myDocumentLine && this.myDocumentColumn == data.myDocumentColumn && this.myHyperlinkStartInd == data.myHyperlinkStartInd && this.myHyperlinkEndInd == data.myHyperlinkEndInd && this.myFilePath.equals(data.myFilePath);
    }

    public int hashCode() {
        int result2 = this.myFilePath.hashCode();
        result2 = 31 * result2 + this.myDocumentLine;
        result2 = 31 * result2 + this.myDocumentColumn;
        result2 = 31 * result2 + this.myHyperlinkStartInd;
        result2 = 31 * result2 + this.myHyperlinkEndInd;
        return result2;
    }

    public String toString() {
        return "filePath=" + this.myFilePath + ", line=" + this.myDocumentLine + ", column=" + this.myDocumentColumn + ", hyperlinkStartOffset=" + this.myHyperlinkStartInd + ", hyperlinkEndOffset=" + this.myHyperlinkEndInd;
    }
}

