/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.DataManager;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.DocumentUtil;
import com.intellij.util.FileContentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageConsoleImpl
extends ConsoleViewImpl
implements LanguageConsoleView,
DataProvider {
    private final Helper myHelper;
    private final EditorEx myConsoleEditor;
    private final EditorEx myHistoryViewer;
    private final Document myEditorDocument;
    private final JPanel myPanel;
    private final JScrollBar myScrollBar;
    private final DocumentAdapter myDocumentAdapter;
    @Nullable
    private String myPrompt;
    private ConsoleViewContentType myPromptAttributes;
    private EditorEx myCurrentEditor;
    private final MessageBusConnection myBusConnection;
    private final FocusChangeListener myFocusListener;

    public LanguageConsoleImpl(@NotNull Project project2, @NotNull String title, @NotNull Language language) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        this(new Helper(project2, (VirtualFile)new LightVirtualFile(title, language, (CharSequence)"")));
    }

    public LanguageConsoleImpl(@NotNull Project project2, @NotNull String title, @NotNull VirtualFile virtualFile) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        this(new Helper(project2, virtualFile).setTitle(title));
    }

    public LanguageConsoleImpl(@NotNull Helper helper) {
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/execution/console/LanguageConsoleImpl", "<init>"));
        }
        super(helper.project, GlobalSearchScope.allScope((Project)helper.project), true, true);
        this.myPanel = new JPanel((LayoutManager)((Object)new MyLayout()));
        this.myScrollBar = new JBScrollBar(0);
        this.myDocumentAdapter = new DocumentAdapter(){

            public void documentChanged(DocumentEvent event) {
                LanguageConsoleImpl.this.myPanel.revalidate();
            }
        };
        this.myPrompt = "> ";
        this.myPromptAttributes = ConsoleViewContentType.USER_INPUT;
        this.myFocusListener = new FocusChangeListener(){

            @Override
            public void focusGained(Editor editor) {
                LanguageConsoleImpl.this.myCurrentEditor = (EditorEx)editor;
                if (GeneralSettings.getInstance().isSaveOnFrameDeactivation()) {
                    TransactionGuard.submitTransaction((Disposable)LanguageConsoleImpl.this, () -> FileDocumentManager.getInstance().saveAllDocuments());
                }
            }

            @Override
            public void focusLost(Editor editor) {
            }
        };
        this.myHelper = helper;
        EditorFactory editorFactory = EditorFactory.getInstance();
        this.myEditorDocument = helper.getDocument();
        this.myConsoleEditor = (EditorEx)editorFactory.createEditor(this.myEditorDocument, this.getProject());
        this.myConsoleEditor.getDocument().addDocumentListener((DocumentListener)this.myDocumentAdapter);
        this.myConsoleEditor.getScrollPane().getHorizontalScrollBar().setEnabled(false);
        this.myConsoleEditor.addFocusListener(this.myFocusListener);
        this.myCurrentEditor = this.myConsoleEditor;
        Document historyDocument = ((EditorFactoryImpl)editorFactory).createDocument(true);
        UndoUtil.disableUndoFor((Document)historyDocument);
        this.myHistoryViewer = (EditorEx)editorFactory.createViewer(historyDocument, this.getProject());
        this.myHistoryViewer.getDocument().addDocumentListener((DocumentListener)this.myDocumentAdapter);
        this.myScrollBar.setOpaque(false);
        this.myScrollBar.setModel(new MyModel(this.myScrollBar, this.myHistoryViewer, this.myConsoleEditor));
        this.myScrollBar.putClientProperty(JBScrollPane.Alignment.class, JBScrollPane.Alignment.BOTTOM);
        this.myBusConnection = this.getProject().getMessageBus().connect();
        ApplicationManager.getApplication().invokeLater(() -> this.installEditorFactoryListener(), this.getProject().getDisposed());
    }

    @Override
    protected final EditorEx doCreateConsoleEditor() {
        return this.myHistoryViewer;
    }

    @Override
    protected final void disposeEditor() {
    }

    @Override
    protected JComponent createCenterComponent() {
        this.initComponents();
        return this.myPanel;
    }

    @Override
    public JComponent getPreferredFocusableComponent() {
        return this.getConsoleEditor().getContentComponent();
    }

    private void initComponents() {
        this.setupComponents();
        this.myPanel.add(this.myHistoryViewer.getComponent());
        this.myPanel.add(this.myConsoleEditor.getComponent());
        this.myPanel.add(this.myScrollBar);
        this.myPanel.setBackground(this.myConsoleEditor.getBackgroundColor());
        DataManager.registerDataProvider((JComponent)this.myPanel, (DataProvider)this);
        this.setPromptInner(this.myPrompt);
    }

    @Override
    public void setConsoleEditorEnabled(boolean consoleEditorEnabled) {
        if (this.isConsoleEditorEnabled() == consoleEditorEnabled) {
            return;
        }
        if (consoleEditorEnabled) {
            FileEditorManager.getInstance((Project)this.getProject()).closeFile(this.getVirtualFile());
            this.myCurrentEditor = this.myConsoleEditor;
        }
        this.setHistoryScrollBarVisible(!consoleEditorEnabled);
        this.myScrollBar.setVisible(consoleEditorEnabled);
        this.myConsoleEditor.getComponent().setVisible(consoleEditorEnabled);
    }

    private void setHistoryScrollBarVisible(boolean visible) {
        JScrollBar prev = this.myHistoryViewer.getScrollPane().getHorizontalScrollBar();
        prev.setEnabled(visible);
    }

    private void setupComponents() {
        this.myHelper.setupEditor(this.myConsoleEditor);
        this.myHelper.setupEditor(this.myHistoryViewer);
        this.myHistoryViewer.getComponent().setMinimumSize((Dimension)JBUI.emptySize());
        this.myHistoryViewer.getComponent().setPreferredSize((Dimension)JBUI.emptySize());
        this.myHistoryViewer.setCaretEnabled(false);
        this.myConsoleEditor.setContextMenuGroupId("ConsoleEditorPopupMenu");
        this.myConsoleEditor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(this.getVirtualFile(), this.myConsoleEditor.getColorsScheme(), this.getProject()));
        this.setHistoryScrollBarVisible(false);
        this.myHistoryViewer.getContentComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                if (LanguageConsoleImpl.this.isConsoleEditorEnabled() && UIUtil.isReallyTypedEvent((KeyEvent)event)) {
                    LanguageConsoleImpl.this.myConsoleEditor.getContentComponent().requestFocus();
                    LanguageConsoleImpl.this.myConsoleEditor.processKeyTyped(event);
                }
            }
        });
        EmptyAction.registerActionShortcuts((JComponent)this.myHistoryViewer.getComponent(), (JComponent)this.myConsoleEditor.getComponent());
    }

    @Override
    public final boolean isConsoleEditorEnabled() {
        return this.myConsoleEditor.getComponent().isVisible();
    }

    @Override
    @Nullable
    public String getPrompt() {
        return this.myPrompt;
    }

    @Override
    @Nullable
    public ConsoleViewContentType getPromptAttributes() {
        return this.myPromptAttributes;
    }

    @Override
    public void setPromptAttributes(@NotNull ConsoleViewContentType textAttributes) {
        if (textAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textAttributes", "com/intellij/execution/console/LanguageConsoleImpl", "setPromptAttributes"));
        }
        this.myPromptAttributes = textAttributes;
    }

    @Override
    public void setPrompt(@Nullable String prompt) {
        this.myPrompt = prompt != null && !prompt.endsWith(" ") ? prompt + " " : prompt;
        this.setPromptInner(this.myPrompt);
    }

    private void setPromptInner(@Nullable String prompt) {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (!this.myConsoleEditor.isDisposed()) {
                this.myConsoleEditor.setPrefixTextAndAttributes(prompt, this.myPromptAttributes.getAttributes());
            }
        });
    }

    @Override
    public void setEditable(boolean editable) {
        this.myConsoleEditor.setRendererMode(!editable);
        this.setPromptInner(editable ? this.myPrompt : "");
    }

    @Override
    public boolean isEditable() {
        return !this.myConsoleEditor.isRendererMode();
    }

    @Override
    @NotNull
    public final PsiFile getFile() {
        PsiFile psiFile = this.myHelper.getFileSafe();
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getFile"));
        }
        return psiFile;
    }

    @Override
    @NotNull
    public final VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myHelper.virtualFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getVirtualFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public final EditorEx getHistoryViewer() {
        EditorEx editorEx = this.myHistoryViewer;
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getHistoryViewer"));
        }
        return editorEx;
    }

    @Override
    @NotNull
    public final Document getEditorDocument() {
        Document document = this.myEditorDocument;
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getEditorDocument"));
        }
        return document;
    }

    @Override
    @NotNull
    public final EditorEx getConsoleEditor() {
        EditorEx editorEx = this.myConsoleEditor;
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getConsoleEditor"));
        }
        return editorEx;
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = this.myHelper.title;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getTitle"));
        }
        return string;
    }

    @Override
    public void setTitle(@NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/execution/console/LanguageConsoleImpl", "setTitle"));
        }
        this.myHelper.setTitle(title);
    }

    public String addToHistory(@NotNull TextRange textRange, @NotNull EditorEx editor, boolean preserveMarkup) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/execution/console/LanguageConsoleImpl", "addToHistory"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/LanguageConsoleImpl", "addToHistory"));
        }
        return this.addToHistoryInner(textRange, editor, false, preserveMarkup);
    }

    @NotNull
    public String prepareExecuteAction(boolean addToHistory, boolean preserveMarkup, boolean clearInput) {
        EditorEx editor = this.getCurrentEditor();
        DocumentEx document = editor.getDocument();
        String text = document.getText();
        TextRange range = new TextRange(0, document.getTextLength());
        if (!clearInput) {
            editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        }
        if (addToHistory) {
            this.addToHistoryInner(range, editor, clearInput, preserveMarkup);
        } else if (clearInput) {
            this.setInputText("");
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "prepareExecuteAction"));
        }
        return string;
    }

    @NotNull
    protected String addToHistoryInner(@NotNull TextRange textRange, @NotNull EditorEx editor, boolean erase, boolean preserveMarkup) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/execution/console/LanguageConsoleImpl", "addToHistoryInner"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/LanguageConsoleImpl", "addToHistoryInner"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String result2 = this.addTextRangeToHistory(textRange, editor, preserveMarkup);
        if (erase) {
            DocumentUtil.writeInRunUndoTransparentAction(() -> {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/LanguageConsoleImpl", "lambda$addToHistoryInner$2"));
                }
                if (textRange == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/execution/console/LanguageConsoleImpl", "lambda$addToHistoryInner$2"));
                }
                editor.getDocument().deleteString(textRange.getStartOffset(), textRange.getEndOffset());
            });
        }
        this.scrollToEnd();
        String string = result2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "addToHistoryInner"));
        }
        return string;
    }

    public static String printWithHighlighting(@NotNull LanguageConsoleView console, @NotNull Editor inputEditor, @NotNull TextRange textRange) {
        String text;
        EditorHighlighter highlighter;
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/LanguageConsoleImpl", "printWithHighlighting"));
        }
        if (inputEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputEditor", "com/intellij/execution/console/LanguageConsoleImpl", "printWithHighlighting"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/execution/console/LanguageConsoleImpl", "printWithHighlighting"));
        }
        if (inputEditor instanceof EditorWindow) {
            PsiFile file2 = ((EditorWindow)inputEditor).getInjectedFile();
            highlighter = HighlighterFactory.createHighlighter((VirtualFile)file2.getVirtualFile(), (EditorColorsScheme)EditorColorsManager.getInstance().getGlobalScheme(), (Project)console.getProject());
            String fullText = InjectedLanguageUtil.getUnescapedText(file2, null, null);
            highlighter.setText((CharSequence)fullText);
            text = textRange.substring(fullText);
        } else {
            text = inputEditor.getDocument().getText(textRange);
            highlighter = ((EditorEx)inputEditor).getHighlighter();
        }
        SyntaxHighlighter syntax = highlighter instanceof LexerEditorHighlighter ? ((LexerEditorHighlighter)highlighter).getSyntaxHighlighter() : null;
        ((LanguageConsoleImpl)console).doAddPromptToHistory();
        if (syntax != null) {
            ConsoleViewUtil.printWithHighlighting(console, text, syntax);
        } else {
            console.print(text, ConsoleViewContentType.USER_INPUT);
        }
        console.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        return text;
    }

    @NotNull
    protected String addTextRangeToHistory(@NotNull TextRange textRange, @NotNull EditorEx inputEditor, boolean preserveMarkup) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/execution/console/LanguageConsoleImpl", "addTextRangeToHistory"));
        }
        if (inputEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputEditor", "com/intellij/execution/console/LanguageConsoleImpl", "addTextRangeToHistory"));
        }
        String string = LanguageConsoleImpl.printWithHighlighting(this, inputEditor, textRange);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "addTextRangeToHistory"));
        }
        return string;
    }

    protected void doAddPromptToHistory() {
        if (this.myPrompt != null) {
            this.print(this.myPrompt, this.myPromptAttributes);
        }
    }

    @Override
    public void dispose() {
        FileEditorManager editorManager;
        super.dispose();
        if (this.myHistoryViewer.isDisposed()) {
            return;
        }
        this.myConsoleEditor.getDocument().removeDocumentListener((DocumentListener)this.myDocumentAdapter);
        this.myHistoryViewer.getDocument().removeDocumentListener((DocumentListener)this.myDocumentAdapter);
        this.myBusConnection.deliverImmediately();
        Disposer.dispose((Disposable)this.myBusConnection);
        EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.releaseEditor((Editor)this.myConsoleEditor);
        editorFactory.releaseEditor((Editor)this.myHistoryViewer);
        if (this.getProject().isOpen() && (editorManager = FileEditorManager.getInstance((Project)this.getProject())).isFileOpen(this.getVirtualFile())) {
            editorManager.closeFile(this.getVirtualFile());
        }
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        return super.getData(dataId);
    }

    private void installEditorFactoryListener() {
        FileEditorManagerAdapter fileEditorListener = new FileEditorManagerAdapter(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/execution/console/LanguageConsoleImpl$4", "fileOpened"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/LanguageConsoleImpl$4", "fileOpened"));
                }
                if (LanguageConsoleImpl.this.myConsoleEditor == null || !Comparing.equal((Object)file2, (Object)LanguageConsoleImpl.this.getVirtualFile())) {
                    return;
                }
                Editor selectedTextEditor = source.getSelectedTextEditor();
                for (FileEditor fileEditor : source.getAllEditors(file2)) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    EditorEx editor = (EditorEx)((TextEditor)fileEditor).getEditor();
                    editor.addFocusListener(LanguageConsoleImpl.this.myFocusListener);
                    if (selectedTextEditor == editor) {
                        LanguageConsoleImpl.this.myCurrentEditor = editor;
                    }
                    EmptyAction.registerActionShortcuts((JComponent)editor.getComponent(), (JComponent)LanguageConsoleImpl.this.myConsoleEditor.getComponent());
                }
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/execution/console/LanguageConsoleImpl$4", "fileClosed"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/console/LanguageConsoleImpl$4", "fileClosed"));
                }
                if (!Comparing.equal((Object)file2, (Object)LanguageConsoleImpl.this.getVirtualFile())) {
                    return;
                }
                if (!Boolean.TRUE.equals(file2.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN)) && LanguageConsoleImpl.this.myCurrentEditor != null && LanguageConsoleImpl.this.myCurrentEditor.isDisposed()) {
                    LanguageConsoleImpl.this.myCurrentEditor = null;
                }
            }
        };
        this.myBusConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)fileEditorListener);
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.getProject());
        if (editorManager.isFileOpen(this.getVirtualFile())) {
            fileEditorListener.fileOpened(editorManager, this.getVirtualFile());
        }
    }

    @Override
    @NotNull
    public EditorEx getCurrentEditor() {
        EditorEx editorEx = (EditorEx)ObjectUtils.notNull((Object)this.myCurrentEditor, (Object)this.myConsoleEditor);
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getCurrentEditor"));
        }
        return editorEx;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.getFile().getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl", "getLanguage"));
        }
        return language;
    }

    @Override
    public void setLanguage(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/execution/console/LanguageConsoleImpl", "setLanguage"));
        }
        this.myHelper.setLanguage(language);
        this.myHelper.getFileSafe();
    }

    @Override
    public void setInputText(@NotNull String query) {
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/execution/console/LanguageConsoleImpl", "setInputText"));
        }
        DocumentUtil.writeInRunUndoTransparentAction(() -> {
            if (query == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/execution/console/LanguageConsoleImpl", "lambda$setInputText$3"));
            }
            this.myConsoleEditor.getDocument().setText(StringUtil.convertLineSeparators((String)query));
        });
    }

    boolean isHistoryViewerForceAdditionalColumnsUsage() {
        return true;
    }

    int getMinHistoryLineCount() {
        return 2;
    }

    private static final class MyModel
    extends DefaultBoundedRangeModel {
        private volatile boolean myInternalChange;
        private final JScrollBar myBar;
        private final EditorEx myFirstEditor;
        private final EditorEx mySecondEditor;
        private int myFirstValue;
        private int mySecondValue;

        private MyModel(JScrollBar bar, EditorEx first, EditorEx second) {
            this.myBar = bar;
            this.myFirstEditor = first;
            this.mySecondEditor = second;
            this.addChangeListener(event -> this.onChange());
            first.getScrollPane().getViewport().addChangeListener(event -> this.onUpdate(event.getSource()));
            second.getScrollPane().getViewport().addChangeListener(event -> this.onUpdate(event.getSource()));
        }

        private boolean isInternal() {
            return this.myInternalChange || !this.myFirstEditor.getComponent().isVisible() || !this.mySecondEditor.getComponent().isVisible();
        }

        private void onChange() {
            if (this.isInternal()) {
                return;
            }
            this.myInternalChange = true;
            MyModel.setValue(this.myFirstEditor.getScrollPane().getViewport(), this.getValue());
            MyModel.setValue(this.mySecondEditor.getScrollPane().getViewport(), this.getValue());
            this.myInternalChange = false;
        }

        private void onUpdate(Object source) {
            Point position;
            if (this.isInternal()) {
                return;
            }
            JViewport first = this.myFirstEditor.getScrollPane().getViewport();
            JViewport second = this.mySecondEditor.getScrollPane().getViewport();
            int value = this.getValue();
            if (source == first) {
                position = first.getViewPosition();
                if (position.x != this.myFirstValue) {
                    this.myFirstValue = value = position.x;
                }
            } else {
                position = second.getViewPosition();
                if (position.x != this.mySecondValue) {
                    this.mySecondValue = value = position.x;
                }
            }
            int ext = Math.min(first.getExtentSize().width, second.getExtentSize().width);
            int max = Math.max(first.getViewSize().width, second.getViewSize().width);
            this.setRangeProperties(value, ext, 0, max, false);
            this.myBar.setEnabled(ext < max);
        }

        private static void setValue(JViewport viewport, int value) {
            Point position = viewport.getViewPosition();
            position.x = Math.max(0, Math.min(value, viewport.getViewSize().width - viewport.getExtentSize().width));
            viewport.setViewPosition(position);
        }
    }

    private static class EmptyScrollBar
    extends JBScrollBar {
        final JScrollBar original;

        public EmptyScrollBar(JScrollBar original) {
            this.original = original;
            this.setModel(original.getModel());
        }

        public Dimension getPreferredSize() {
            return JBUI.emptySize();
        }

        public Dimension getMinimumSize() {
            return JBUI.emptySize();
        }

        public Dimension getMaximumSize() {
            return JBUI.emptySize();
        }

        public Border getBorder() {
            return null;
        }

        public void paint(Graphics g) {
        }
    }

    private class MyLayout
    extends AbstractLayoutManager {
        private MyLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        public void layoutContainer(@NotNull Container parent) {
            EditorEx input;
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/execution/console/LanguageConsoleImpl$MyLayout", "layoutContainer"));
            }
            int componentCount = parent.getComponentCount();
            if (componentCount == 0) {
                return;
            }
            EditorEx history = LanguageConsoleImpl.this.myHistoryViewer;
            EditorEx editorEx = input = LanguageConsoleImpl.this.isConsoleEditorEnabled() ? LanguageConsoleImpl.this.myConsoleEditor : null;
            if (input == null) {
                parent.getComponent(0).setBounds(parent.getBounds());
                return;
            }
            Dimension panelSize = parent.getSize();
            if (LanguageConsoleImpl.this.myScrollBar.isVisible()) {
                Dimension size = LanguageConsoleImpl.this.myScrollBar.getPreferredSize();
                if (panelSize.height < size.height) {
                    return;
                }
                panelSize.height -= size.height;
                LanguageConsoleImpl.this.myScrollBar.setBounds(0, panelSize.height, panelSize.width, size.height);
            }
            if (panelSize.getHeight() <= 0.0) {
                return;
            }
            Dimension historySize = history.getContentSize();
            Dimension inputSize = input.getContentSize();
            if (LanguageConsoleImpl.this.isHistoryViewerForceAdditionalColumnsUsage()) {
                history.getSoftWrapModel().forceAdditionalColumnsUsage();
                int minAdditionalColumns = 2;
                int historySpaceWidth = EditorUtil.getPlainSpaceWidth(history);
                historySize.width += historySpaceWidth * (minAdditionalColumns - history.getSettings().getAdditionalColumnsCount());
                int inputSpaceWidth = EditorUtil.getPlainSpaceWidth(input);
                inputSize.width += inputSpaceWidth * (minAdditionalColumns - input.getSettings().getAdditionalColumnsCount());
                int max = Math.max(historySize.width, inputSize.width);
                history.getSettings().setAdditionalColumnsCount(minAdditionalColumns + (max - historySize.width) / historySpaceWidth);
                input.getSettings().setAdditionalColumnsCount(minAdditionalColumns + (max - inputSize.width) / inputSpaceWidth);
            }
            if (history.getDocument().getLineCount() == 0) {
                historySize.height = 0;
            }
            int minHistoryHeight = historySize.height > 0 ? LanguageConsoleImpl.this.getMinHistoryLineCount() * history.getLineHeight() : 0;
            int minInputHeight = input.isViewer() ? 0 : input.getLineHeight();
            int inputPreferredHeight = input.isViewer() ? 0 : Math.max(minInputHeight, inputSize.height);
            int historyPreferredHeight = Math.max(minHistoryHeight, historySize.height);
            int newInputHeight = panelSize.height < minInputHeight ? panelSize.height : (panelSize.height < inputPreferredHeight ? panelSize.height - minHistoryHeight : (panelSize.height < inputPreferredHeight + historyPreferredHeight || inputPreferredHeight == 0 ? inputPreferredHeight : panelSize.height - historyPreferredHeight));
            int oldHistoryHeight = history.getComponent().getHeight();
            int newHistoryHeight = panelSize.height - newInputHeight;
            int delta = newHistoryHeight - newHistoryHeight / history.getLineHeight() * history.getLineHeight();
            input.getComponent().setBounds(0, newHistoryHeight -= delta, panelSize.width, newInputHeight += delta);
            history.getComponent().setBounds(0, 0, panelSize.width, newHistoryHeight);
            input.getComponent().doLayout();
            history.getComponent().doLayout();
            if (newHistoryHeight < oldHistoryHeight) {
                JViewport viewport = history.getScrollPane().getViewport();
                Point position = viewport.getViewPosition();
                position.translate(0, oldHistoryHeight - newHistoryHeight);
                viewport.setViewPosition(position);
            }
        }
    }

    public static class Helper {
        public final Project project;
        public final VirtualFile virtualFile;
        String title;
        PsiFile file;

        public Helper(@NotNull Project project2, @NotNull VirtualFile virtualFile) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/console/LanguageConsoleImpl$Helper", "<init>"));
            }
            if (virtualFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/execution/console/LanguageConsoleImpl$Helper", "<init>"));
            }
            this.project = project2;
            this.virtualFile = virtualFile;
            this.title = virtualFile.getName();
        }

        public Helper setTitle(String title) {
            this.title = title;
            return this;
        }

        @NotNull
        public PsiFile getFile() {
            PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiUtilCore.getPsiFile((Project)this.project, (VirtualFile)this.virtualFile));
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl$Helper", "getFile"));
            }
            return psiFile;
        }

        @NotNull
        public Document getDocument() {
            Document document = FileDocumentManager.getInstance().getDocument(this.virtualFile);
            if (document == null) {
                throw new AssertionError((Object)("no document for: " + this.virtualFile));
            }
            Document document2 = document;
            if (document2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl$Helper", "getDocument"));
            }
            return document2;
        }

        public void setLanguage(Language language) {
            if (!(this.virtualFile instanceof LightVirtualFile)) {
                throw new UnsupportedOperationException();
            }
            ((LightVirtualFile)this.virtualFile).setLanguage(language);
            ((LightVirtualFile)this.virtualFile).setContent((Object)this.getDocument(), (CharSequence)this.getDocument().getText(), false);
            FileContentUtil.reparseFiles((Project)this.project, Collections.singletonList(this.virtualFile), (boolean)false);
        }

        public void setupEditor(@NotNull EditorEx editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/LanguageConsoleImpl$Helper", "setupEditor"));
            }
            ConsoleViewUtil.setupConsoleEditor(editor, false, false);
            editor.getContentComponent().setFocusCycleRoot(false);
            editor.setHorizontalScrollbarVisible(true);
            editor.setVerticalScrollbarVisible(true);
            editor.setBorder(null);
            EditorSettings editorSettings = editor.getSettings();
            editorSettings.setAdditionalLinesCount(1);
            editorSettings.setAdditionalColumnsCount(1);
            DataManager.registerDataProvider((JComponent)editor.getComponent(), dataId -> {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/LanguageConsoleImpl$Helper", "lambda$setupEditor$1"));
                }
                return this.getEditorData(editor, dataId);
            });
        }

        @NotNull
        PsiFile getFileSafe() {
            PsiFile psiFile = this.file == null || !this.file.isValid() ? (this.file = this.getFile()) : this.file;
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleImpl$Helper", "getFileSafe"));
            }
            return psiFile;
        }

        @Nullable
        protected Object getEditorData(@NotNull EditorEx editor, String dataId) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/LanguageConsoleImpl$Helper", "getEditorData"));
            }
            if (OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId)) {
                return editor;
            }
            if (this.project.isInitialized()) {
                Caret caret = editor.getCaretModel().getCurrentCaret();
                return FileEditorManagerEx.getInstanceEx(this.project).getData(dataId, editor, caret);
            }
            return null;
        }
    }
}

