/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.configurations.ConfigurationUtil;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractApplicationConfigurationProducer<T extends ApplicationConfiguration>
extends JavaRunConfigurationProducerBase<T> {
    public AbstractApplicationConfigurationProducer(ApplicationConfigurationType configurationType) {
        super(configurationType);
    }

    protected boolean setupConfigurationFromContext(T configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        PsiClass aClass;
        PsiMethod method2;
        Location contextLocation = context.getLocation();
        if (contextLocation == null) {
            return false;
        }
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        if (!element.isPhysical()) {
            return false;
        }
        PsiElement currentElement = element;
        while ((method2 = AbstractApplicationConfigurationProducer.findMain(currentElement)) != null) {
            aClass = method2.getContainingClass();
            if (ConfigurationUtil.MAIN_CLASS.value((Object)aClass)) {
                sourceElement.set((Object)method2);
                this.setupConfiguration(configuration, aClass, context);
                return true;
            }
            currentElement = method2.getParent();
        }
        aClass = ApplicationConfigurationType.getMainClass(element);
        if (aClass == null) {
            return false;
        }
        sourceElement.set((Object)aClass);
        this.setupConfiguration(configuration, aClass, context);
        return true;
    }

    private void setupConfiguration(T configuration, PsiClass aClass, ConfigurationContext context) {
        ((ApplicationConfiguration)configuration).MAIN_CLASS_NAME = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass);
        configuration.setGeneratedName();
        this.setupConfigurationModule(context, configuration);
    }

    @Nullable
    private static PsiMethod findMain(PsiElement element) {
        PsiMethod method2;
        while ((method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class)) != null) {
            if (PsiMethodUtil.isMainMethod((PsiMethod)method2)) {
                return method2;
            }
            element = method2.getParent();
        }
        return null;
    }

    public boolean isConfigurationFromContext(T appConfiguration, ConfigurationContext context) {
        PsiElement location = context.getPsiLocation();
        PsiClass aClass = ApplicationConfigurationType.getMainClass(location);
        if (aClass != null && Comparing.equal((String)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass), (String)((ApplicationConfiguration)appConfiguration).MAIN_CLASS_NAME)) {
            PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)location, PsiMethod.class, (boolean)false);
            if (method2 != null && TestFrameworks.getInstance().isTestMethod(method2)) {
                return false;
            }
            Module configurationModule = ((JavaRunConfigurationModule)appConfiguration.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)context.getModule(), (Object)configurationModule)) {
                return true;
            }
            ApplicationConfiguration template = (ApplicationConfiguration)context.getRunManager().getConfigurationTemplate(this.getConfigurationFactory()).getConfiguration();
            Module predefinedModule = ((JavaRunConfigurationModule)template.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)predefinedModule, (Object)configurationModule)) {
                return true;
            }
        }
        return false;
    }
}

