/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class UnifiedEditorHighlighter
implements EditorHighlighter {
    public static final Logger LOG = UnifiedDiffViewer.LOG;
    @NotNull
    private final Document myDocument;
    @NotNull
    private final List<Element> myPieces;

    public UnifiedEditorHighlighter(@NotNull Document document, @NotNull EditorHighlighter highlighter1, @NotNull EditorHighlighter highlighter2, @NotNull List<HighlightRange> ranges, int textLength) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter", "<init>"));
        }
        if (highlighter1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter1", "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter", "<init>"));
        }
        if (highlighter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter2", "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter", "<init>"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter", "<init>"));
        }
        this.myDocument = document;
        this.myPieces = new ArrayList<Element>();
        this.init(highlighter1.createIterator(0), highlighter2.createIterator(0), ranges, textLength);
    }

    private void init(@NotNull HighlighterIterator it1, @NotNull HighlighterIterator it2, @NotNull List<HighlightRange> ranges, int textLength) {
        if (it1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "it1", "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter", "init"));
        }
        if (it2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "it2", "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter", "init"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter", "init"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int offset = 0;
        block0: for (HighlightRange range : ranges) {
            TextRange base = range.getBase();
            TextRange changed = range.getChanged();
            if (base.isEmpty()) continue;
            if (base.getStartOffset() > offset) {
                this.addElement(new Element(offset, base.getStartOffset(), null, TextAttributes.ERASE_MARKER));
                offset = base.getStartOffset();
            }
            HighlighterIterator it = (HighlighterIterator)range.getSide().select((Object)it1, (Object)it2);
            while (!it.atEnd() && changed.getStartOffset() >= it.getEnd()) {
                it.advance();
            }
            if (it.atEnd()) {
                LOG.error("Unexpected end of highlighter");
                break;
            }
            if (changed.getEndOffset() <= it.getStart()) continue;
            do {
                int relativeStart = Math.max(it.getStart() - changed.getStartOffset(), 0);
                int relativeEnd = Math.min(it.getEnd() - changed.getStartOffset(), changed.getLength() + 1);
                this.addElement(new Element(offset + relativeStart, offset + relativeEnd, it.getTokenType(), it.getTextAttributes()));
                if (changed.getEndOffset() <= it.getEnd()) {
                    offset += changed.getLength();
                    continue block0;
                }
                it.advance();
            } while (!it.atEnd());
            LOG.error("Unexpected end of highlighter");
        }
        if (offset < textLength) {
            this.addElement(new Element(offset, textLength, null, TextAttributes.ERASE_MARKER));
        }
    }

    private void addElement(@NotNull Element element) {
        Element oldElement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter", "addElement"));
        }
        boolean merged = false;
        if (!this.myPieces.isEmpty() && (oldElement = this.myPieces.get(this.myPieces.size() - 1)).getEnd() >= element.getStart() && Comparing.equal((Object)oldElement.getAttributes(), (Object)element.getAttributes()) && Comparing.equal((Object)oldElement.getElementType(), (Object)element.getElementType())) {
            merged = true;
            this.myPieces.remove(this.myPieces.size() - 1);
            this.myPieces.add(new Element(oldElement.getStart(), element.getEnd(), element.getElementType(), element.getAttributes()));
        }
        if (!merged) {
            this.myPieces.add(element);
        }
    }

    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        int index = Collections.binarySearch(this.myPieces, new Element(startOffset, 0, null, null), (o1, o2) -> o1.getStart() - o2.getStart());
        if (index < 0) {
            index = Math.max(-index - 2, 0);
        }
        ProxyIterator proxyIterator = new ProxyIterator(this.myDocument, index, this.myPieces);
        if (proxyIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter", "createIterator"));
        }
        return proxyIterator;
    }

    public void setColorScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter", "setColorScheme"));
        }
    }

    public void setEditor(@NotNull HighlighterClient editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter", "setEditor"));
        }
    }

    public void setText(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter", "setText"));
        }
    }

    public void beforeDocumentChange(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
    }

    private static class Element {
        private final int myStart;
        private final int myEnd;
        private final IElementType myElementType;
        private final TextAttributes myAttributes;

        private Element(int start, int end, IElementType elementType, TextAttributes attributes) {
            this.myStart = start;
            this.myEnd = end;
            this.myElementType = elementType;
            this.myAttributes = attributes;
        }

        public int getStart() {
            return this.myStart;
        }

        public int getEnd() {
            return this.myEnd;
        }

        public IElementType getElementType() {
            return this.myElementType;
        }

        public TextAttributes getAttributes() {
            return this.myAttributes;
        }
    }

    private static class ProxyIterator
    implements HighlighterIterator {
        private final Document myDocument;
        private int myIdx;
        private final List<Element> myPieces;

        private ProxyIterator(@NotNull Document document, int idx, @NotNull List<Element> pieces) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter$ProxyIterator", "<init>"));
            }
            if (pieces == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pieces", "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter$ProxyIterator", "<init>"));
            }
            this.myDocument = document;
            this.myIdx = idx;
            this.myPieces = pieces;
        }

        public TextAttributes getTextAttributes() {
            return this.myPieces.get(this.myIdx).getAttributes();
        }

        public int getStart() {
            return this.myPieces.get(this.myIdx).getStart();
        }

        public int getEnd() {
            return this.myPieces.get(this.myIdx).getEnd();
        }

        public IElementType getTokenType() {
            return this.myPieces.get(this.myIdx).myElementType;
        }

        public void advance() {
            if (this.myIdx < this.myPieces.size()) {
                ++this.myIdx;
            }
        }

        public void retreat() {
            if (this.myIdx > -1) {
                --this.myIdx;
            }
        }

        public boolean atEnd() {
            return this.myIdx < 0 || this.myIdx >= this.myPieces.size();
        }

        public Document getDocument() {
            return this.myDocument;
        }
    }
}

