/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.actions.DocumentsSynchronizer;
import com.intellij.diff.contents.DiffContentBase;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.util.LineCol;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentFragmentContent
extends DiffContentBase
implements DocumentContent {
    @NotNull
    private final DocumentContent myOriginal;
    @NotNull
    private final RangeMarker myRangeMarker;
    @NotNull
    private final MyDocumentsSynchronizer mySynchronizer;
    private int myAssignments;

    public DocumentFragmentContent(@Nullable Project project2, @NotNull DocumentContent original, @NotNull TextRange range) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/diff/actions/DocumentFragmentContent", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/actions/DocumentFragmentContent", "<init>"));
        }
        this(project2, original, DocumentFragmentContent.createRangeMarker(original.getDocument(), range));
    }

    public DocumentFragmentContent(@Nullable Project project2, @NotNull DocumentContent original, @NotNull RangeMarker rangeMarker) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/diff/actions/DocumentFragmentContent", "<init>"));
        }
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/diff/actions/DocumentFragmentContent", "<init>"));
        }
        this.myAssignments = 0;
        this.myOriginal = original;
        this.myRangeMarker = rangeMarker;
        Document document1 = this.myOriginal.getDocument();
        Document document2 = EditorFactory.getInstance().createDocument((CharSequence)"");
        document2.putUserData(UndoManager.ORIGINAL_DOCUMENT, (Object)document1);
        this.mySynchronizer = new MyDocumentsSynchronizer(project2, this.myRangeMarker, document1, document2);
    }

    @NotNull
    private static RangeMarker createRangeMarker(@NotNull Document document, @NotNull TextRange range) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/actions/DocumentFragmentContent", "createRangeMarker"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/actions/DocumentFragmentContent", "createRangeMarker"));
        }
        RangeMarker rangeMarker = document.createRangeMarker(range.getStartOffset(), range.getEndOffset(), true);
        rangeMarker.setGreedyToLeft(true);
        rangeMarker.setGreedyToRight(true);
        RangeMarker rangeMarker2 = rangeMarker;
        if (rangeMarker2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/DocumentFragmentContent", "createRangeMarker"));
        }
        return rangeMarker2;
    }

    @NotNull
    public Document getDocument() {
        Document document = this.mySynchronizer.getDocument2();
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/DocumentFragmentContent", "getDocument"));
        }
        return document;
    }

    @Nullable
    public VirtualFile getHighlightFile() {
        return this.myOriginal.getHighlightFile();
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull LineCol position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/diff/actions/DocumentFragmentContent", "getNavigatable"));
        }
        if (!this.myRangeMarker.isValid()) {
            return null;
        }
        int offset = position.toOffset(this.getDocument());
        int originalOffset = offset + this.myRangeMarker.getStartOffset();
        LineCol originalPosition = LineCol.fromOffset((Document)this.myOriginal.getDocument(), (int)originalOffset);
        return this.myOriginal.getNavigatable(originalPosition);
    }

    @Nullable
    public FileType getContentType() {
        return this.myOriginal.getContentType();
    }

    @Nullable
    public Navigatable getNavigatable() {
        return this.getNavigatable(new LineCol(0));
    }

    public void onAssigned(boolean isAssigned) {
        if (isAssigned) {
            if (this.myAssignments == 0) {
                this.mySynchronizer.startListen();
            }
            ++this.myAssignments;
        } else {
            --this.myAssignments;
            if (this.myAssignments == 0) {
                this.mySynchronizer.stopListen();
            }
        }
        assert (this.myAssignments >= 0);
    }

    private static class MyDocumentsSynchronizer
    extends DocumentsSynchronizer {
        @NotNull
        private final RangeMarker myRangeMarker;

        public MyDocumentsSynchronizer(@Nullable Project project2, @NotNull RangeMarker range, @NotNull Document document1, @NotNull Document document2) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/actions/DocumentFragmentContent$MyDocumentsSynchronizer", "<init>"));
            }
            if (document1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document1", "com/intellij/diff/actions/DocumentFragmentContent$MyDocumentsSynchronizer", "<init>"));
            }
            if (document2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document2", "com/intellij/diff/actions/DocumentFragmentContent$MyDocumentsSynchronizer", "<init>"));
            }
            super(project2, document1, document2);
            this.myRangeMarker = range;
        }

        @Override
        protected void onDocumentChanged1(@NotNull DocumentEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/actions/DocumentFragmentContent$MyDocumentsSynchronizer", "onDocumentChanged1"));
            }
            if (!this.myRangeMarker.isValid()) {
                this.myDocument2.setReadOnly(false);
                this.replaceString(this.myDocument2, 0, this.myDocument2.getTextLength(), "Invalid selection range");
                this.myDocument2.setReadOnly(true);
                return;
            }
            CharSequence newText = this.myDocument1.getCharsSequence().subSequence(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset());
            this.replaceString(this.myDocument2, 0, this.myDocument2.getTextLength(), newText);
        }

        @Override
        protected void onDocumentChanged2(@NotNull DocumentEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/actions/DocumentFragmentContent$MyDocumentsSynchronizer", "onDocumentChanged2"));
            }
            if (!this.myRangeMarker.isValid()) {
                return;
            }
            if (!this.myDocument1.isWritable()) {
                return;
            }
            CharSequence newText = event.getNewFragment();
            int originalOffset = event.getOffset() + this.myRangeMarker.getStartOffset();
            int originalEnd = originalOffset + event.getOldLength();
            this.replaceString(this.myDocument1, originalOffset, originalEnd, newText);
        }

        @Override
        public void startListen() {
            if (this.myRangeMarker.isValid()) {
                this.myDocument2.setReadOnly(false);
                CharSequence nexText = this.myDocument1.getCharsSequence().subSequence(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset());
                this.replaceString(this.myDocument2, 0, this.myDocument2.getTextLength(), nexText);
                this.myDocument2.setReadOnly(!this.myDocument1.isWritable());
            } else {
                this.myDocument2.setReadOnly(false);
                this.replaceString(this.myDocument2, 0, this.myDocument2.getTextLength(), "Invalid selection range");
                this.myDocument2.setReadOnly(true);
            }
            super.startListen();
        }
    }
}

