/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

@State(name="DebuggerSettings", defaultStateAsResource=true, storages={@Storage(value="debugger.xml"), @Storage(value="other.xml", deprecated=true)})
public class DebuggerSettings
implements Cloneable,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(DebuggerSettings.class);
    public static final int SOCKET_TRANSPORT = 0;
    public static final int SHMEM_TRANSPORT = 1;
    @NonNls
    public static final String SUSPEND_ALL = "SuspendAll";
    @NonNls
    public static final String SUSPEND_THREAD = "SuspendThread";
    @NonNls
    public static final String SUSPEND_NONE = "SuspendNone";
    @NonNls
    public static final String EVALUATE_FRAGMENT = "EvaluateFragment";
    @NonNls
    public static final String EVALUATE_EXPRESSION = "EvaluateExpression";
    @NonNls
    public static final String RUN_HOTSWAP_ALWAYS = "RunHotswapAlways";
    @NonNls
    public static final String RUN_HOTSWAP_NEVER = "RunHotswapNever";
    @NonNls
    public static final String RUN_HOTSWAP_ASK = "RunHotswapAsk";
    @NonNls
    public static final String EVALUATE_FINALLY_ALWAYS = "EvaluateFinallyAlways";
    @NonNls
    public static final String EVALUATE_FINALLY_NEVER = "EvaluateFinallyNever";
    @NonNls
    public static final String EVALUATE_FINALLY_ASK = "EvaluateFinallyAsk";
    public boolean TRACING_FILTERS_ENABLED;
    public int DEBUGGER_TRANSPORT;
    public boolean FORCE_CLASSIC_VM;
    public boolean DISABLE_JIT;
    public boolean SHOW_ALTERNATIVE_SOURCE = true;
    public boolean HOTSWAP_IN_BACKGROUND = true;
    public boolean SKIP_SYNTHETIC_METHODS;
    public boolean SKIP_CONSTRUCTORS;
    public boolean SKIP_GETTERS;
    public boolean SKIP_CLASSLOADERS;
    public String EVALUATION_DIALOG_TYPE;
    public String RUN_HOTSWAP_AFTER_COMPILE;
    public boolean COMPILE_BEFORE_HOTSWAP;
    public boolean HOTSWAP_HANG_WARNING_ENABLED = false;
    public volatile boolean WATCH_RETURN_VALUES = false;
    public volatile boolean AUTO_VARIABLES_MODE = false;
    public volatile boolean KILL_PROCESS_IMMEDIATELY = false;
    public String EVALUATE_FINALLY_ON_POP_FRAME = "EvaluateFinallyAsk";
    public boolean RESUME_ONLY_CURRENT_THREAD = false;
    private ClassFilter[] mySteppingFilters = ClassFilter.EMPTY_ARRAY;
    private Map<String, ContentState> myContentStates = new LinkedHashMap();

    @Transient
    public ClassFilter[] getSteppingFilters() {
        ClassFilter[] rv = new ClassFilter[this.mySteppingFilters.length];
        for (int idx = 0; idx < rv.length; ++idx) {
            rv[idx] = this.mySteppingFilters[idx].clone();
        }
        return rv;
    }

    public static DebuggerSettings getInstance() {
        return (DebuggerSettings)ServiceManager.getService(DebuggerSettings.class);
    }

    public void setSteppingFilters(ClassFilter[] steppingFilters) {
        this.mySteppingFilters = steppingFilters != null ? steppingFilters : ClassFilter.EMPTY_ARRAY;
    }

    @Nullable
    public Element getState() {
        Element state = XmlSerializer.serialize((Object)this, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        try {
            DebuggerUtilsEx.writeFilters(state, "filter", this.mySteppingFilters);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
            return null;
        }
        for (ContentState eachState : this.myContentStates.values()) {
            Element content;
            if (!eachState.write(content = new Element("content"))) continue;
            state.addContent(content);
        }
        return state;
    }

    public void loadState(Element state) {
        XmlSerializer.deserializeInto((Object)this, (Element)state);
        try {
            this.setSteppingFilters(DebuggerUtilsEx.readFilters(state.getChildren("filter")));
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        this.myContentStates.clear();
        for (Element content : state.getChildren("content")) {
            ContentState contentState = new ContentState(content);
            this.myContentStates.put(contentState.getType(), contentState);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DebuggerSettings)) {
            return false;
        }
        DebuggerSettings secondSettings = (DebuggerSettings)obj;
        return this.TRACING_FILTERS_ENABLED == secondSettings.TRACING_FILTERS_ENABLED && this.DEBUGGER_TRANSPORT == secondSettings.DEBUGGER_TRANSPORT && StringUtil.equals((CharSequence)this.EVALUATE_FINALLY_ON_POP_FRAME, (CharSequence)secondSettings.EVALUATE_FINALLY_ON_POP_FRAME) && this.FORCE_CLASSIC_VM == secondSettings.FORCE_CLASSIC_VM && this.DISABLE_JIT == secondSettings.DISABLE_JIT && this.SHOW_ALTERNATIVE_SOURCE == secondSettings.SHOW_ALTERNATIVE_SOURCE && this.KILL_PROCESS_IMMEDIATELY == secondSettings.KILL_PROCESS_IMMEDIATELY && this.HOTSWAP_IN_BACKGROUND == secondSettings.HOTSWAP_IN_BACKGROUND && this.SKIP_SYNTHETIC_METHODS == secondSettings.SKIP_SYNTHETIC_METHODS && this.SKIP_CLASSLOADERS == secondSettings.SKIP_CLASSLOADERS && this.SKIP_CONSTRUCTORS == secondSettings.SKIP_CONSTRUCTORS && this.SKIP_GETTERS == secondSettings.SKIP_GETTERS && this.RESUME_ONLY_CURRENT_THREAD == secondSettings.RESUME_ONLY_CURRENT_THREAD && this.COMPILE_BEFORE_HOTSWAP == secondSettings.COMPILE_BEFORE_HOTSWAP && this.HOTSWAP_HANG_WARNING_ENABLED == secondSettings.HOTSWAP_HANG_WARNING_ENABLED && (this.RUN_HOTSWAP_AFTER_COMPILE != null ? this.RUN_HOTSWAP_AFTER_COMPILE.equals(secondSettings.RUN_HOTSWAP_AFTER_COMPILE) : secondSettings.RUN_HOTSWAP_AFTER_COMPILE == null) && DebuggerUtilsEx.filterEquals(this.mySteppingFilters, secondSettings.mySteppingFilters);
    }

    public DebuggerSettings clone() {
        try {
            DebuggerSettings cloned = (DebuggerSettings)super.clone();
            cloned.myContentStates = new HashMap<String, ContentState>();
            for (Map.Entry<String, ContentState> entry : this.myContentStates.entrySet()) {
                cloned.myContentStates.put(entry.getKey(), entry.getValue().clone());
            }
            cloned.mySteppingFilters = new ClassFilter[this.mySteppingFilters.length];
            for (int idx = 0; idx < this.mySteppingFilters.length; ++idx) {
                cloned.mySteppingFilters[idx] = this.mySteppingFilters[idx].clone();
            }
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static class ContentState
    implements Cloneable {
        private final String myType;
        private boolean myMinimized;
        private String mySelectedTab;
        private double mySplitProportion;
        private boolean myDetached;
        private boolean myHorizontalToolbar;
        private boolean myMaximized;

        public ContentState(String type) {
            this.myType = type;
        }

        public ContentState(Element element) {
            this.myType = element.getAttributeValue("type");
            this.myMinimized = "true".equalsIgnoreCase(element.getAttributeValue("minimized"));
            this.myMaximized = "true".equalsIgnoreCase(element.getAttributeValue("maximized"));
            this.mySelectedTab = element.getAttributeValue("selected");
            String split = element.getAttributeValue("split");
            if (split != null) {
                this.mySplitProportion = Double.valueOf(split);
            }
            this.myDetached = "true".equalsIgnoreCase(element.getAttributeValue("detached"));
            this.myHorizontalToolbar = !"false".equalsIgnoreCase(element.getAttributeValue("horizontal"));
        }

        public boolean write(Element element) {
            element.setAttribute("type", this.myType);
            element.setAttribute("minimized", Boolean.valueOf(this.myMinimized).toString());
            element.setAttribute("maximized", Boolean.valueOf(this.myMaximized).toString());
            if (this.mySelectedTab != null) {
                element.setAttribute("selected", this.mySelectedTab);
            }
            element.setAttribute("split", Double.toString(this.mySplitProportion));
            element.setAttribute("detached", Boolean.valueOf(this.myDetached).toString());
            element.setAttribute("horizontal", Boolean.valueOf(this.myHorizontalToolbar).toString());
            return true;
        }

        public String getType() {
            return this.myType;
        }

        public String getSelectedTab() {
            return this.mySelectedTab;
        }

        public boolean isMinimized() {
            return this.myMinimized;
        }

        public void setMinimized(boolean minimized) {
            this.myMinimized = minimized;
        }

        public void setMaximized(boolean maximized) {
            this.myMaximized = maximized;
        }

        public boolean isMaximized() {
            return this.myMaximized;
        }

        public void setSelectedTab(String selectedTab) {
            this.mySelectedTab = selectedTab;
        }

        public void setSplitProportion(double splitProportion) {
            this.mySplitProportion = splitProportion;
        }

        public double getSplitProportion(double defaultValue) {
            return this.mySplitProportion <= 0.0 || this.mySplitProportion >= 1.0 ? defaultValue : this.mySplitProportion;
        }

        public void setDetached(boolean detached) {
            this.myDetached = detached;
        }

        public boolean isDetached() {
            return this.myDetached;
        }

        public boolean isHorizontalToolbar() {
            return this.myHorizontalToolbar;
        }

        public void setHorizontalToolbar(boolean horizontalToolbar) {
            this.myHorizontalToolbar = horizontalToolbar;
        }

        public ContentState clone() throws CloneNotSupportedException {
            return (ContentState)super.clone();
        }
    }
}

