/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.Method;
import org.jetbrains.annotations.NotNull;

class JavaFramesListRenderer {
    private final EditorColorsScheme myColorScheme = EditorColorsManager.getInstance().getGlobalScheme();

    public void customizePresentation(StackFrameDescriptorImpl descriptor, @NotNull ColoredTextContainer component, StackFrameDescriptorImpl selectedDescriptor) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/debugger/engine/JavaFramesListRenderer", "customizePresentation"));
        }
        component.setIcon(descriptor.getIcon());
        boolean shouldHighlightAsRecursive = JavaFramesListRenderer.isOccurrenceOfSelectedFrame(selectedDescriptor, descriptor);
        ValueMarkup markup = descriptor.getValueMarkup();
        if (markup != null) {
            component.append("[" + markup.getText() + "] ", new SimpleTextAttributes(1, markup.getColor()));
        }
        boolean needSeparator = false;
        String label = descriptor.getLabel();
        int openingBrace = label.indexOf("{");
        int closingBrace = openingBrace < 0 ? -1 : label.indexOf("}");
        SimpleTextAttributes attributes = JavaFramesListRenderer.getAttributes(descriptor);
        if (openingBrace < 0 || closingBrace < 0) {
            component.append(label, attributes);
        } else {
            component.append(label.substring(0, openingBrace - 1), attributes);
            component.append(" (" + label.substring(openingBrace + 1, closingBrace) + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            component.append(label.substring(closingBrace + 1, label.length()), attributes);
            if (shouldHighlightAsRecursive && descriptor.isRecursiveCall()) {
                component.append(" [" + descriptor.getOccurrenceIndex() + "]", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
        }
    }

    private static boolean isOccurrenceOfSelectedFrame(StackFrameDescriptorImpl selectedDescriptor, StackFrameDescriptorImpl descriptor) {
        Method selectedMethod;
        Method currentMethod = descriptor.getMethod();
        return currentMethod != null && selectedDescriptor != null && (selectedMethod = selectedDescriptor.getMethod()) != null && Comparing.equal((Object)selectedMethod, (Object)currentMethod);
    }

    private static SimpleTextAttributes getAttributes(StackFrameDescriptorImpl descriptor) {
        if (descriptor.isSynthetic() || descriptor.isInLibraryContent()) {
            return SimpleTextAttributes.GRAYED_ATTRIBUTES;
        }
        return SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
    }
}

