/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.io.CipherOutputStream;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a(\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u000e\u0010\u0012\u001a\n \u0002*\u0004\u0018\u00010\u00130\u0013\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"AES_CIPHER", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "getDecryptedInputStream", "Ljava/io/InputStream;", "encryptedInputStream", "keyData", "", "ivData", "getEncryptedOutputStream", "Ljava/io/OutputStream;", "decryptedOutputStream", "getFinalKeyDigest", "key", "masterSeed", "transformSeed", "transformRounds", "", "sha256MessageDigest", "Ljava/security/MessageDigest;", "credential-store"})
public final class KdbxHeaderKt {
    private static final UUID AES_CIPHER = UUID.fromString("31C1F2E6-BF71-4350-BE58-05216AFC5AFF");

    /*
     * WARNING - void declaration
     */
    private static final byte[] getFinalKeyDigest(byte[] key2, byte[] masterSeed, byte[] transformSeed, long transformRounds) {
        AESEngine engine = new AESEngine();
        engine.init(true, (CipherParameters)new KeyParameter(transformSeed));
        byte[] transformedKey = new byte[key2.length];
        System.arraycopy(key2, 0, transformedKey, 0, transformedKey.length);
        long l = 0;
        long l2 = transformRounds - (long)1;
        if (l <= l2) {
            while (true) {
                void rounds;
                engine.processBlock(transformedKey, 0, transformedKey, 0);
                engine.processBlock(transformedKey, 16, transformedKey, 16);
                if (rounds == l2) break;
                ++rounds;
            }
        }
        MessageDigest md = KdbxHeaderKt.sha256MessageDigest();
        byte[] transformedKeyDigest = md.digest(transformedKey);
        md.update(masterSeed);
        byte[] byArray = md.digest(transformedKeyDigest);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"md.digest(transformedKeyDigest)");
        return byArray;
    }

    public static final MessageDigest sha256MessageDigest() {
        return MessageDigest.getInstance("SHA-256");
    }

    private static final InputStream getDecryptedInputStream(InputStream encryptedInputStream, byte[] keyData, byte[] ivData) {
        ParametersWithIV keyAndIV = new ParametersWithIV((CipherParameters)new KeyParameter(keyData), ivData);
        PaddedBufferedBlockCipher pbbc = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESFastEngine()));
        pbbc.init(false, (CipherParameters)keyAndIV);
        return (InputStream)new CipherInputStream(encryptedInputStream, (BufferedBlockCipher)pbbc);
    }

    private static final OutputStream getEncryptedOutputStream(OutputStream decryptedOutputStream, byte[] keyData, byte[] ivData) {
        ParametersWithIV keyAndIV = new ParametersWithIV((CipherParameters)new KeyParameter(keyData), ivData);
        PaddedBufferedBlockCipher pbbc = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESFastEngine()));
        pbbc.init(true, (CipherParameters)keyAndIV);
        return (OutputStream)new CipherOutputStream(decryptedOutputStream, (BufferedBlockCipher)pbbc);
    }

    @NotNull
    public static final /* synthetic */ byte[] access$getFinalKeyDigest(@NotNull byte[] key2, @NotNull byte[] masterSeed, @NotNull byte[] transformSeed, long transformRounds) {
        return KdbxHeaderKt.getFinalKeyDigest(key2, masterSeed, transformSeed, transformRounds);
    }

    @NotNull
    public static final /* synthetic */ InputStream access$getDecryptedInputStream(@NotNull InputStream encryptedInputStream, @NotNull byte[] keyData, @NotNull byte[] ivData) {
        return KdbxHeaderKt.getDecryptedInputStream(encryptedInputStream, keyData, ivData);
    }

    @NotNull
    public static final /* synthetic */ OutputStream access$getEncryptedOutputStream(@NotNull OutputStream decryptedOutputStream, @NotNull byte[] keyData, @NotNull byte[] ivData) {
        return KdbxHeaderKt.getEncryptedOutputStream(decryptedOutputStream, keyData, ivData);
    }

    public static final /* synthetic */ UUID access$getAES_CIPHER$p() {
        return AES_CIPHER;
    }
}

