/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.kdbx.KdbxEntry;
import com.intellij.credentialStore.kdbx.KdbxGroupKt;
import com.intellij.credentialStore.kdbx.KdbxKt;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.kdbx.KeePassDatabaseKt;
import com.intellij.util.JdomKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0011J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020!0 J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\"\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010\u0011J\u0010\u0010$\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0012\u001a\u00020\u0011J\u0018\u0010%\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010\u0011J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u0010'\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nJ\u001a\u0010'\u001a\u0004\u0018\u00010\n2\u0006\u0010\"\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010\u0011J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010(\u001a\u00020)2\u0006\u0010\u0012\u001a\u00020\u0011J\b\u0010*\u001a\u00020\u0011H\u0016J\u0006\u0010+\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00008\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014\u00a8\u0006,"}, d2={"Lcom/intellij/credentialStore/kdbx/KdbxGroup;", "", "element", "Lorg/jdom/Element;", "database", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "parent", "(Lorg/jdom/Element;Lcom/intellij/credentialStore/kdbx/KeePassDatabase;Lcom/intellij/credentialStore/kdbx/KdbxGroup;)V", "entries", "", "Lcom/intellij/credentialStore/kdbx/KdbxEntry;", "getEntries", "()Ljava/util/List;", "groups", "locationChanged", "", "value", "", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "path", "getPath", "addEntry", "entry", "addGroup", "group", "createGroup", "getEntry", "matcher", "Lkotlin/Function1;", "", "title", "userName", "getGroup", "getOrCreateEntry", "getOrCreateGroup", "removeEntry", "removeGroup", "", "toString", "toXml", "credential-store"})
public final class KdbxGroup {
    @NotNull
    private volatile String name;
    private final List<KdbxGroup> groups;
    @NotNull
    private final List<KdbxEntry> entries;
    private volatile long locationChanged;
    private final Element element;
    private final KeePassDatabase database;
    private volatile KdbxGroup parent;

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (Intrinsics.areEqual((Object)this.name, (Object)value) ^ true) {
            this.name = value;
            this.database.setDirty$credential_store(true);
        }
    }

    @NotNull
    public final List<KdbxEntry> getEntries() {
        return this.entries;
    }

    @NotNull
    public final Element toXml() {
        Element element = this.element.clone();
        JdomKt.getOrCreate(element, KeePassDatabaseKt.NAME_ELEMENT_NAME).setText(this.name);
        Element locationChangedElement = JdomKt.getOrCreate(JdomKt.getOrCreate(element, "Times"), "LocationChanged");
        if (this.locationChanged == 0L) {
            Object object = JdomKt.get(element, "Times");
            if (object != null && (object = JdomKt.get(object, "CreationTime")) != null && (object = object.getText()) != null) {
                Object object2 = object;
                String it = (String)object2;
                locationChangedElement.setText(it);
            }
        } else {
            locationChangedElement.setText(Instant.ofEpochMilli(this.locationChanged).atZone(ZoneOffset.UTC).format(KeePassDatabaseKt.getDateFormatter()));
        }
        for (KdbxGroup group : this.groups) {
            element.addContent(group.toXml());
        }
        for (KdbxEntry entry : this.entries) {
            element.addContent(entry.toXml());
        }
        Element element2 = element;
        Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"element");
        return element2;
    }

    @NotNull
    public final KdbxGroup addGroup(@NotNull KdbxGroup group) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        if (Intrinsics.areEqual((Object)group, (Object)this.database.getRootGroup())) {
            throw (Throwable)new IllegalStateException("Cannot set root group as child of another group");
        }
        KdbxGroup kdbxGroup = group.parent;
        if (kdbxGroup != null) {
            kdbxGroup.removeGroup(group);
        }
        this.groups.add(group);
        group.parent = this;
        group.locationChanged = LocalDateTime.now(ZoneOffset.UTC).toEpochSecond(ZoneOffset.UTC);
        this.database.setDirty$credential_store(true);
        return group;
    }

    @NotNull
    public final KdbxGroup removeGroup(@NotNull KdbxGroup group) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        if (this.groups.remove(group)) {
            group.parent = null;
            this.database.setDirty$credential_store(true);
        }
        return group;
    }

    public final void removeGroup(@NotNull String name) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            KdbxGroup kdbxGroup = this.getGroup(name);
            if (kdbxGroup == null) break block0;
            KdbxGroup kdbxGroup2 = kdbxGroup;
            KdbxGroup it = kdbxGroup2;
            this.removeGroup(it);
        }
    }

    @Nullable
    public final KdbxGroup getGroup(@NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Iterable $receiver$iv = this.groups;
            for (Object element$iv : $receiver$iv) {
                KdbxGroup it = (KdbxGroup)element$iv;
                if (!Intrinsics.areEqual((Object)it.name, (Object)name)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final KdbxGroup getOrCreateGroup(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        KdbxGroup kdbxGroup = this.getGroup(name);
        if (kdbxGroup == null) {
            kdbxGroup = this.createGroup(name);
        }
        return kdbxGroup;
    }

    @NotNull
    public final KdbxGroup createGroup(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        KdbxGroup result2 = KdbxGroupKt.createGroup(this.database, this);
        result2.setName(name);
        this.addGroup(result2);
        return result2;
    }

    @Nullable
    public final KdbxEntry getEntry(@NotNull Function1<? super KdbxEntry, Boolean> matcher) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull(matcher, (String)"matcher");
            Iterable $receiver$iv = this.entries;
            for (Object element$iv : $receiver$iv) {
                if (!((Boolean)matcher.invoke(element$iv)).booleanValue()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final KdbxEntry addEntry(@NotNull KdbxEntry entry) {
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        KdbxGroup kdbxGroup = entry.getGroup$credential_store();
        if (kdbxGroup != null) {
            KdbxGroup kdbxGroup2 = kdbxGroup;
            KdbxGroup it = kdbxGroup2;
            it.removeEntry(entry);
        }
        this.entries.add(entry);
        entry.setGroup$credential_store(this);
        this.database.setDirty$credential_store(true);
        return entry;
    }

    @NotNull
    public final KdbxEntry removeEntry(@NotNull KdbxEntry entry) {
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        if (this.entries.remove(entry)) {
            entry.setGroup$credential_store(null);
            this.database.setDirty$credential_store(true);
        }
        return entry;
    }

    @Nullable
    public final KdbxEntry getEntry(@NotNull String title, @Nullable String userName) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        return this.getEntry((Function1<? super KdbxEntry, Boolean>)((Function1)new Function1<KdbxEntry, Boolean>(title, userName){
            final /* synthetic */ String $title;
            final /* synthetic */ String $userName;

            public final boolean invoke(@NotNull KdbxEntry it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getTitle(), (Object)this.$title) && (Intrinsics.areEqual((Object)it.getUserName(), (Object)this.$userName) || this.$userName == null);
            }
            {
                this.$title = string;
                this.$userName = string2;
                super(1);
            }
        }));
    }

    @NotNull
    public final KdbxEntry getOrCreateEntry(@NotNull String title, @Nullable String userName) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        KdbxEntry entry = this.getEntry(title, userName);
        if (entry == null) {
            entry = this.database.createEntry(title);
            entry.setUserName(userName);
            this.addEntry(entry);
        }
        return entry;
    }

    @Nullable
    public final KdbxEntry removeEntry(@NotNull String title, @Nullable String userName) {
        KdbxEntry kdbxEntry;
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        KdbxEntry kdbxEntry2 = this.getEntry(title, userName);
        if (kdbxEntry2 != null) {
            KdbxEntry kdbxEntry3 = kdbxEntry2;
            KdbxEntry it = kdbxEntry3;
            kdbxEntry = this.removeEntry(it);
        } else {
            kdbxEntry = null;
        }
        return kdbxEntry;
    }

    @NotNull
    public final String getPath() {
        Stack parents = new Stack();
        KdbxGroup parent = this;
        parents.push((Object)this);
        while (parent.parent != null) {
            parents.push((Object)parent);
        }
        StringBuilder result2 = new StringBuilder("/");
        while (parents.size() > 0) {
            result2.append(((KdbxGroup)parents.pop()).name).append('/');
        }
        String string = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return string;
    }

    @NotNull
    public String toString() {
        return this.getPath();
    }

    public KdbxGroup(@NotNull Element element, @NotNull KeePassDatabase database, @Nullable KdbxGroup parent) {
        long l;
        long l2;
        long l3;
        String p1;
        KdbxGroup kdbxGroup;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        this.element = element;
        this.database = database;
        this.parent = parent;
        String string = this.element.getChildText(KeePassDatabaseKt.NAME_ELEMENT_NAME);
        if (string == null) {
            string = "Unnamed";
        }
        this.name = string;
        KdbxGroup kdbxGroup2 = this;
        Object object2 = JdomKt.get(this.element, "Times");
        if (object2 != null && (object2 = JdomKt.get(object2, "LocationChanged")) != null && (object2 = object2.getText()) != null) {
            object = object2;
            kdbxGroup = kdbxGroup2;
            p1 = (String)object;
            l3 = KdbxKt.parseTime(p1);
            kdbxGroup2 = kdbxGroup;
            l2 = l3;
        } else {
            l2 = 0L;
        }
        kdbxGroup2.locationChanged = l2;
        KdbxGroup kdbxGroup3 = this;
        Object object3 = JdomKt.get(this.element, "Times");
        if (object3 != null && (object3 = JdomKt.get(object3, "LocationChanged")) != null && (object3 = object3.getText()) != null) {
            object = object3;
            kdbxGroup = kdbxGroup3;
            p1 = (String)object;
            l3 = KdbxKt.parseTime(p1);
            kdbxGroup3 = kdbxGroup;
            l = l3;
        } else {
            l = 0L;
        }
        kdbxGroup3.locationChanged = l;
        List list = ContainerUtil.createLockFreeCopyOnWriteList((Collection)JdomKt.remove(this.element, KeePassDatabaseKt.GROUP_ELEMENT_NAME, (Function1)new Function1<Element, KdbxGroup>(){

            @NotNull
            public final KdbxGroup invoke(@NotNull Element it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return new KdbxGroup(it, database, this);
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ContainerUtil.createLock\u2026up(it, database, this) })");
        this.groups = list;
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList((Collection)JdomKt.remove(this.element, KeePassDatabaseKt.ENTRY_ELEMENT_NAME, (Function1)new Function1<Element, KdbxEntry>(){

            @NotNull
            public final KdbxEntry invoke(@NotNull Element it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return new KdbxEntry(it, database, this);
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ContainerUtil.createLock\u2026ry(it, database, this) })");
        this.entries = list2;
    }
}

