/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.MacOsKeychainLibrary;
import com.intellij.credentialStore.MacOsKeychainLibraryKt;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.credentialStore.SecKeychainAttribute;
import com.intellij.credentialStore.SecKeychainAttributeInfo;
import com.intellij.credentialStore.SecKeychainAttributeList;
import com.intellij.openapi.util.SystemInfo;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import gnu.trove.TIntObjectHashMap;
import java.nio.charset.Charset;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00020\u0012\"\u00020\u0007H\u0000\u001a\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0002\u001a\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0016\u001a\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002\"\u001a\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\"\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"LIBRARY", "Lcom/intellij/credentialStore/MacOsKeychainLibrary;", "getLIBRARY", "()Lcom/intellij/credentialStore/MacOsKeychainLibrary;", "LIBRARY$delegate", "Lkotlin/Lazy;", "errSecInvalidRecord", "", "errSecItemNotFound", "errSecSuccess", "isMacOsCredentialStoreSupported", "", "()Z", "kSecAccountItemAttr", "kSecFormatUnknown", "SecKeychainAttributeInfo", "Lcom/intellij/credentialStore/SecKeychainAttributeInfo;", "ids", "", "checkForError", "", "message", "", "code", "findGenericPassword", "Lcom/intellij/credentialStore/Credentials;", "serviceName", "", "accountName", "readAttributes", "Lgnu/trove/TIntObjectHashMap;", "list", "Lcom/intellij/credentialStore/SecKeychainAttributeList;", "credential-store"})
public final class MacOsKeychainLibraryKt {
    private static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final Lazy LIBRARY$delegate;
    private static final int errSecSuccess = 0;
    private static final int errSecItemNotFound = -25300;
    private static final int errSecInvalidRecord = -67701;
    private static final int kSecFormatUnknown = 0;
    private static final int kSecAccountItemAttr = 1633903476;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(MacOsKeychainLibraryKt.class, (String)"credential-store"), "LIBRARY", "getLIBRARY()Lcom/intellij/credentialStore/MacOsKeychainLibrary;"))};
        LIBRARY$delegate = LazyKt.lazy((Function0)LIBRARY.2.INSTANCE);
    }

    public static final boolean isMacOsCredentialStoreSupported() {
        return SystemInfo.isMacIntel64 && SystemInfo.isMacOSLeopard;
    }

    private static final MacOsKeychainLibrary getLIBRARY() {
        Lazy lazy = LIBRARY$delegate;
        Object var1_1 = null;
        KProperty kProperty = $$delegatedProperties[0];
        return (MacOsKeychainLibrary)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final Credentials findGenericPassword(@NotNull byte[] serviceName, @Nullable String accountName) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
        String string = accountName;
        if (string != null) {
            String string2 = string;
            Charset charset = null;
            boolean bl = true;
            Object var6_6 = null;
            if (var6_6 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toByteArray");
            }
            if (bl & true) {
                charset = Charsets.UTF_8;
            }
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray2 = string3.getBytes(charset);
            byArray = byArray2;
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        } else {
            byArray = null;
        }
        byte[] accountNameBytes = byArray;
        int[] passwordSize = new int[1];
        PointerByReference passwordRef = new PointerByReference();
        PointerByReference itemRef = new PointerByReference();
        MacOsKeychainLibraryKt.checkForError("find", MacOsKeychainLibraryKt.getLIBRARY().SecKeychainFindGenericPassword(null, serviceName.length, serviceName, accountNameBytes != null ? accountNameBytes.length : 0, accountNameBytes, passwordSize, passwordRef, itemRef));
        Pointer pointer = passwordRef.getValue();
        if (pointer == null) {
            return null;
        }
        Pointer pointer2 = pointer;
        byte[] byArray3 = pointer2.getByteArray(0L, passwordSize[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"pointer.getByteArray(0, passwordSize.get(0))");
        OneTimeString password = CredentialAttributesKt.OneTimeString$default((byte[])byArray3, (int)0, (int)0, (boolean)false, (int)14, null);
        MacOsKeychainLibraryKt.getLIBRARY().SecKeychainItemFreeContent(null, pointer2);
        String effectiveAccountName = accountName;
        if (effectiveAccountName == null) {
            PointerByReference attributes = new PointerByReference();
            MacOsKeychainLibrary macOsKeychainLibrary = MacOsKeychainLibraryKt.getLIBRARY();
            Pointer pointer3 = itemRef.getValue();
            if (pointer3 == null) {
                Intrinsics.throwNpe();
            }
            MacOsKeychainLibraryKt.checkForError("SecKeychainItemCopyAttributesAndData", macOsKeychainLibrary.SecKeychainItemCopyAttributesAndData(pointer3, MacOsKeychainLibraryKt.SecKeychainAttributeInfo(kSecAccountItemAttr), null, attributes, null, null));
            Pointer pointer4 = attributes.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)pointer4, (String)"attributes.value");
            SecKeychainAttributeList attributeList = new SecKeychainAttributeList(pointer4);
            try {
                attributeList.read();
                effectiveAccountName = (String)MacOsKeychainLibraryKt.readAttributes(attributeList).get(kSecAccountItemAttr);
            }
            finally {
                MacOsKeychainLibraryKt.getLIBRARY().SecKeychainItemFreeAttributesAndData(attributeList, null);
            }
        }
        return new Credentials(effectiveAccountName, password);
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkForError(String message, int code2) {
        if (code2 == errSecSuccess || code2 == errSecItemNotFound) {
            return;
        }
        Pointer translated = MacOsKeychainLibraryKt.getLIBRARY().SecCopyErrorMessageString(code2, null);
        StringBuilder builder = new StringBuilder(message).append(": ");
        if (translated == null) {
            builder.append(code2);
        } else {
            int n = 0;
            char[] buf = new char[(int)MacOsKeychainLibraryKt.getLIBRARY().CFStringGetLength(translated)];
            int n2 = buf.length - 1;
            if (n <= n2) {
                while (true) {
                    void i2;
                    buf[i2] = MacOsKeychainLibraryKt.getLIBRARY().CFStringGetCharacterAtIndex(translated, (long)i2);
                    if (i2 == n2) break;
                    ++i2;
                }
            }
            MacOsKeychainLibraryKt.getLIBRARY().CFRelease(translated);
            builder.append(buf).append(" (").append(code2).append(')');
        }
        CredentialStoreKt.getLOG().error(builder.toString());
    }

    @NotNull
    public static final SecKeychainAttributeInfo SecKeychainAttributeInfo(int ... ids) {
        int length;
        Intrinsics.checkParameterIsNotNull((Object)ids, (String)"ids");
        SecKeychainAttributeInfo info = new SecKeychainAttributeInfo();
        info.count = length = ids.length;
        int size = length << 2;
        Memory tag = new Memory((long)(size << 1));
        Pointer format = tag.share((long)size, (long)size);
        info.tag = (Pointer)tag;
        info.format = format;
        int offset = 0;
        for (int j = 0; j < ids.length; ++j) {
            int id = ids[j];
            tag.setInt((long)offset, id);
            format.setInt((long)offset, kSecFormatUnknown);
            offset += 4;
        }
        return info;
    }

    private static final TIntObjectHashMap<String> readAttributes(SecKeychainAttributeList list) {
        TIntObjectHashMap map = new TIntObjectHashMap();
        Pointer pointer = list.attr;
        if (pointer == null) {
            Intrinsics.throwNpe();
        }
        SecKeychainAttribute attrList = new SecKeychainAttribute(pointer);
        attrList.read();
        Structure[] structureArray = attrList.toArray(list.count);
        if (structureArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<com.intellij.credentialStore.SecKeychainAttribute>");
        }
        SecKeychainAttribute[] secKeychainAttributeArray = (SecKeychainAttribute[])structureArray;
        for (int j = 0; j < secKeychainAttributeArray.length; ++j) {
            byte[] byArray;
            Pointer data;
            SecKeychainAttribute attr = secKeychainAttributeArray[j];
            if (attr.data == null) {
                continue;
            }
            int n = attr.tag;
            Intrinsics.checkExpressionValueIsNotNull((Object)data.getByteArray(0L, attr.length), (String)"data.getByteArray(0, attr.length)");
            int n2 = n;
            TIntObjectHashMap tIntObjectHashMap = map;
            String string = new String(byArray, Charsets.UTF_8);
            tIntObjectHashMap.put(n2, (Object)string);
        }
        return map;
    }

    @NotNull
    public static final /* synthetic */ MacOsKeychainLibrary access$getLIBRARY$p() {
        return MacOsKeychainLibraryKt.getLIBRARY();
    }

    public static final /* synthetic */ int access$getErrSecItemNotFound$p() {
        return errSecItemNotFound;
    }

    public static final /* synthetic */ int access$getErrSecInvalidRecord$p() {
        return errSecInvalidRecord;
    }

    public static final /* synthetic */ void access$checkForError(@NotNull String message, int code2) {
        MacOsKeychainLibraryKt.checkForError(message, code2);
    }

    public static final /* synthetic */ int access$getKSecAccountItemAttr$p() {
        return kSecAccountItemAttr;
    }
}

