/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.ui.InspectionGroupNode;
import com.intellij.codeInspection.ui.InspectionModuleNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionRootNode;
import com.intellij.codeInspection.ui.InspectionSeverityGroupNode;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeComparator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Comparator;

public class InspectionResultsViewComparator
implements Comparator {
    private static final Logger LOG = Logger.getInstance(InspectionResultsViewComparator.class);

    public boolean areEqual(Object o1, Object o2) {
        return o1.getClass().equals(o2.getClass()) && this.compare(o1, o2) == 0;
    }

    public int compare(Object o1, Object o2) {
        InspectionTreeNode node1 = (InspectionTreeNode)o1;
        InspectionTreeNode node2 = (InspectionTreeNode)o2;
        if (node1 instanceof InspectionSeverityGroupNode && node2 instanceof InspectionSeverityGroupNode) {
            InspectionSeverityGroupNode groupNode1 = (InspectionSeverityGroupNode)node1;
            InspectionSeverityGroupNode groupNode2 = (InspectionSeverityGroupNode)node2;
            return -SeverityRegistrar.getSeverityRegistrar(groupNode1.getProject()).compare(groupNode1.getSeverityLevel().getSeverity(), groupNode2.getSeverityLevel().getSeverity());
        }
        if (node1 instanceof InspectionSeverityGroupNode) {
            return -1;
        }
        if (node2 instanceof InspectionSeverityGroupNode) {
            return 1;
        }
        if (node1 instanceof InspectionGroupNode && node2 instanceof InspectionGroupNode) {
            return ((InspectionGroupNode)node1).getGroupTitle().compareToIgnoreCase(((InspectionGroupNode)node2).getGroupTitle());
        }
        if (node1 instanceof InspectionGroupNode) {
            return -1;
        }
        if (node2 instanceof InspectionGroupNode) {
            return 1;
        }
        if (node1 instanceof InspectionNode && node2 instanceof InspectionNode) {
            return InspectionsConfigTreeComparator.getDisplayTextToSort(node1.toString()).compareToIgnoreCase(InspectionsConfigTreeComparator.getDisplayTextToSort(node2.toString()));
        }
        if (node1 instanceof InspectionNode) {
            return -1;
        }
        if (node2 instanceof InspectionNode) {
            return 1;
        }
        if (node1 instanceof InspectionModuleNode && node2 instanceof InspectionModuleNode) {
            return Comparing.compare((Comparable)((Object)node1.toString()), (Comparable)((Object)node2.toString()));
        }
        if (node1 instanceof InspectionModuleNode) {
            return -1;
        }
        if (node2 instanceof InspectionModuleNode) {
            return 1;
        }
        if (node1 instanceof InspectionPackageNode && node2 instanceof InspectionPackageNode) {
            return ((InspectionPackageNode)node1).getPackageName().compareToIgnoreCase(((InspectionPackageNode)node2).getPackageName());
        }
        if (node1 instanceof InspectionPackageNode) {
            return -1;
        }
        if (node2 instanceof InspectionPackageNode) {
            return 1;
        }
        if (node1 instanceof RefElementNode && node2 instanceof RefElementNode) {
            return InspectionResultsViewComparator.compareEntities(((RefElementNode)node1).getElement(), ((RefElementNode)node2).getElement());
        }
        if (node1 instanceof ProblemDescriptionNode && node2 instanceof ProblemDescriptionNode) {
            CommonProblemDescriptor descriptor1 = ((ProblemDescriptionNode)node1).getDescriptor();
            CommonProblemDescriptor descriptor2 = ((ProblemDescriptionNode)node2).getDescriptor();
            if (descriptor1 instanceof ProblemDescriptor && descriptor2 instanceof ProblemDescriptor) {
                int diff = ((ProblemDescriptor)descriptor1).getLineNumber() - ((ProblemDescriptor)descriptor2).getLineNumber();
                if (diff != 0) {
                    return diff;
                }
                diff = ((ProblemDescriptor)descriptor1).getHighlightType().compareTo((Enum)((ProblemDescriptor)descriptor2).getHighlightType());
                if (diff != 0) {
                    return diff;
                }
                diff = PsiUtilCore.compareElementsByPosition((PsiElement)((ProblemDescriptor)descriptor1).getStartElement(), (PsiElement)((ProblemDescriptor)descriptor2).getStartElement());
                if (diff != 0) {
                    return diff;
                }
                diff = PsiUtilCore.compareElementsByPosition((PsiElement)((ProblemDescriptor)descriptor2).getEndElement(), (PsiElement)((ProblemDescriptor)descriptor1).getEndElement());
                if (diff != 0) {
                    return diff;
                }
                TextRange range1 = ((ProblemDescriptor)descriptor1).getTextRangeInElement();
                TextRange range2 = ((ProblemDescriptor)descriptor2).getTextRangeInElement();
                if (range1 != null && range2 != null) {
                    diff = range1.getStartOffset() - range2.getStartOffset();
                    if (diff != 0) {
                        return diff;
                    }
                    diff = range1.getEndOffset() - range2.getEndOffset();
                    if (diff != 0) {
                        return diff;
                    }
                }
            }
            if (descriptor1 != null && descriptor2 != null) {
                return descriptor1.getDescriptionTemplate().compareToIgnoreCase(descriptor2.getDescriptionTemplate());
            }
            if (descriptor1 == null) {
                return descriptor2 == null ? 0 : -1;
            }
            return 1;
        }
        if (node1 instanceof RefElementNode && node2 instanceof ProblemDescriptionNode) {
            CommonProblemDescriptor descriptor = ((ProblemDescriptionNode)node2).getDescriptor();
            if (descriptor instanceof ProblemDescriptor) {
                return InspectionResultsViewComparator.compareEntity(((RefElementNode)node1).getElement(), ((ProblemDescriptor)descriptor).getPsiElement());
            }
            return InspectionResultsViewComparator.compareEntities(((RefElementNode)node1).getElement(), ((ProblemDescriptionNode)node2).getElement());
        }
        if (node2 instanceof RefElementNode && node1 instanceof ProblemDescriptionNode) {
            CommonProblemDescriptor descriptor = ((ProblemDescriptionNode)node1).getDescriptor();
            if (descriptor instanceof ProblemDescriptor) {
                return -InspectionResultsViewComparator.compareEntity(((RefElementNode)node2).getElement(), ((ProblemDescriptor)descriptor).getPsiElement());
            }
            return -InspectionResultsViewComparator.compareEntities(((RefElementNode)node2).getElement(), ((ProblemDescriptionNode)node1).getElement());
        }
        if (node1 instanceof InspectionRootNode && node2 instanceof InspectionRootNode) {
            return 0;
        }
        LOG.error("node1: " + node1 + ", node2: " + node2);
        return 0;
    }

    private static int compareEntity(RefEntity entity, PsiElement element) {
        if (entity instanceof RefElement) {
            PsiElement psiElement = ((RefElement)entity).getElement();
            if (psiElement != null && element != null) {
                return PsiUtilCore.compareElementsByPosition((PsiElement)psiElement, (PsiElement)element);
            }
            if (element == null) {
                return psiElement == null ? 0 : 1;
            }
        }
        if (element instanceof PsiQualifiedNamedElement) {
            return StringUtil.compare((String)entity.getQualifiedName(), (String)((PsiQualifiedNamedElement)element).getQualifiedName(), (boolean)true);
        }
        if (element instanceof PsiNamedElement) {
            return StringUtil.compare((String)entity.getName(), (String)((PsiNamedElement)element).getName(), (boolean)true);
        }
        return -1;
    }

    private static int compareEntities(RefEntity entity1, RefEntity entity2) {
        if (entity1 instanceof RefElement && entity2 instanceof RefElement) {
            SmartPsiElementPointer p1 = ((RefElement)entity1).getPointer();
            SmartPsiElementPointer p2 = ((RefElement)entity2).getPointer();
            if (p1 != null && p2 != null) {
                int positionComparing;
                VirtualFile file1 = p1.getVirtualFile();
                VirtualFile file2 = p2.getVirtualFile();
                if (file1 != null && Comparing.equal((Object)file1, (Object)file2) && file1.isValid() && (positionComparing = PsiUtilCore.compareElementsByPosition((PsiElement)((RefElement)entity1).getElement(), (PsiElement)((RefElement)entity2).getElement())) != 0) {
                    return positionComparing;
                }
            }
        }
        if (entity1 instanceof RefFile && entity2 instanceof RefFile) {
            VirtualFile file1 = ((RefFile)entity1).getPointer().getVirtualFile();
            VirtualFile file2 = ((RefFile)entity2).getPointer().getVirtualFile();
            if (file1 != null && file2 != null) {
                if (file1.equals(file2)) {
                    return 0;
                }
                int cmp = InspectionResultsViewComparator.compareEntitiesByName(entity1, entity2);
                if (cmp != 0) {
                    return cmp;
                }
                return file1.hashCode() - file2.hashCode();
            }
        }
        if (entity1 != null && entity2 != null) {
            return InspectionResultsViewComparator.compareEntitiesByName(entity1, entity2);
        }
        if (entity1 != null) {
            return -1;
        }
        return entity2 != null ? 1 : 0;
    }

    private static int compareEntitiesByName(RefEntity entity1, RefEntity entity2) {
        int nameComparing = entity1.getName().compareToIgnoreCase(entity2.getName());
        if (nameComparing != 0) {
            return nameComparing;
        }
        return entity1.getQualifiedName().compareToIgnoreCase(entity2.getQualifiedName());
    }

    public static InspectionResultsViewComparator getInstance() {
        return InspectionResultsViewComparatorHolder.ourInstance;
    }

    private static class InspectionResultsViewComparatorHolder {
        private static final InspectionResultsViewComparator ourInstance = new InspectionResultsViewComparator();

        private InspectionResultsViewComparatorHolder() {
        }
    }
}

