/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionNode
extends InspectionTreeNode {
    @NotNull
    private final InspectionProfileImpl myProfile;

    public InspectionNode(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionProfileImpl profile) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ui/InspectionNode", "<init>"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/codeInspection/ui/InspectionNode", "<init>"));
        }
        super(toolWrapper);
        this.myProfile = profile;
    }

    @Override
    public String toString() {
        return this.getToolWrapper().getDisplayName();
    }

    @NotNull
    public InspectionToolWrapper getToolWrapper() {
        InspectionToolWrapper inspectionToolWrapper = (InspectionToolWrapper)this.getUserObject();
        if (inspectionToolWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionNode", "getToolWrapper"));
        }
        return inspectionToolWrapper;
    }

    @Override
    @Nullable
    public String getCustomizedTailText() {
        ToolsImpl tools = this.myProfile.getTools(this.getToolWrapper().getShortName(), null);
        return tools.isEnabled() ? null : "Disabled";
    }
}

