/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.streamMigration.ReplaceWithCollectFix;
import com.intellij.codeInspection.streamMigration.ReplaceWithCountFix;
import com.intellij.codeInspection.streamMigration.ReplaceWithFindFirstFix;
import com.intellij.codeInspection.streamMigration.ReplaceWithForeachCallFix;
import com.intellij.codeInspection.streamMigration.ReplaceWithMatchFix;
import com.intellij.codeInspection.streamMigration.ReplaceWithSumFix;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamApiMigrationInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)("#" + StreamApiMigrationInspection.class.getName()));
    static final Map<String, String> COLLECTION_TO_ARRAY = EntryStream.of((Object)"java.util.ArrayList", (Object)"toArray", (Object)"java.util.LinkedList", (Object)"toArray", (Object)"java.util.HashSet", (Object)"distinct().toArray", (Object)"java.util.LinkedHashSet", (Object)"distinct().toArray", (Object)"java.util.TreeSet", (Object)"distinct().sorted().toArray").toMap();
    public boolean REPLACE_TRIVIAL_FOREACH;
    public boolean SUGGEST_FOREACH;
    private HighlightDisplayKey myKey;

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox("Suggest to replace with forEach or forEachOrdered", "SUGGEST_FOREACH");
        panel2.addCheckbox("Replace trivial foreach statements", "REPLACE_TRIVIAL_FOREACH");
        return panel2;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("foreach loop can be collapsed with Stream API" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection", "getDisplayName"));
        }
        return "foreach loop can be collapsed with Stream API";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        if ("Convert2streamapi" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection", "getShortName"));
        }
        return "Convert2streamapi";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        StreamApiMigrationVisitor streamApiMigrationVisitor = new StreamApiMigrationVisitor(holder, isOnTheFly);
        if (streamApiMigrationVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection", "buildVisitor"));
        }
        return streamApiMigrationVisitor;
    }

    @Contract(value="_, null -> false")
    static boolean isVariableReferenced(PsiVariable variable, PsiExpression value) {
        return value != null && ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope((PsiElement)value)).findFirst() != null;
    }

    static boolean isReferencedInOperations(PsiElement element, TerminalBlock tb) {
        return ReferencesSearch.search((PsiElement)element, (SearchScope)new LocalSearchScope((PsiElement[])tb.intermediateAndSourceExpressions().toArray(PsiElement[]::new))).findFirst() != null;
    }

    @Nullable
    static PsiReturnStatement getNextReturnStatement(PsiStatement statement2) {
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)statement2, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
        if (nextStatement instanceof PsiReturnStatement) {
            return (PsiReturnStatement)nextStatement;
        }
        PsiElement parent = statement2.getParent();
        if (parent instanceof PsiCodeBlock) {
            PsiStatement[] statements = ((PsiCodeBlock)parent).getStatements();
            if (statements.length == 0 || statements[statements.length - 1] != statement2) {
                return null;
            }
            if (!((parent = parent.getParent()) instanceof PsiBlockStatement)) {
                return null;
            }
            parent = parent.getParent();
        }
        if (parent instanceof PsiIfStatement) {
            return StreamApiMigrationInspection.getNextReturnStatement((PsiStatement)parent);
        }
        return null;
    }

    @Contract(value="null, null -> true; null, !null -> false")
    private static boolean sameReference(PsiExpression expr1, PsiExpression expr2) {
        if (expr1 == null && expr2 == null) {
            return true;
        }
        if (!(expr1 instanceof PsiReferenceExpression) || !(expr2 instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression ref1 = (PsiReferenceExpression)expr1;
        PsiReferenceExpression ref2 = (PsiReferenceExpression)expr2;
        return Objects.equals(ref1.getReferenceName(), ref2.getReferenceName()) && StreamApiMigrationInspection.sameReference(ref1.getQualifierExpression(), ref2.getQualifierExpression());
    }

    @Nullable
    static PsiExpression extractAddend(PsiAssignmentExpression assignment) {
        PsiBinaryExpression binOp;
        if (JavaTokenType.PLUSEQ.equals(assignment.getOperationTokenType())) {
            return assignment.getRExpression();
        }
        if (JavaTokenType.EQ.equals(assignment.getOperationTokenType()) && assignment.getRExpression() instanceof PsiBinaryExpression && JavaTokenType.PLUS.equals((binOp = (PsiBinaryExpression)assignment.getRExpression()).getOperationTokenType())) {
            if (StreamApiMigrationInspection.sameReference(binOp.getLOperand(), assignment.getLExpression())) {
                return binOp.getROperand();
            }
            if (StreamApiMigrationInspection.sameReference(binOp.getROperand(), assignment.getLExpression())) {
                return binOp.getLOperand();
            }
        }
        return null;
    }

    @Nullable
    static PsiVariable extractAccumulator(PsiAssignmentExpression assignment) {
        PsiBinaryExpression binOp;
        if (!(assignment.getLExpression() instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression lExpr = (PsiReferenceExpression)assignment.getLExpression();
        PsiElement accumulator = lExpr.resolve();
        if (!(accumulator instanceof PsiVariable)) {
            return null;
        }
        PsiVariable var = (PsiVariable)accumulator;
        if (JavaTokenType.PLUSEQ.equals(assignment.getOperationTokenType())) {
            return var;
        }
        if (JavaTokenType.EQ.equals(assignment.getOperationTokenType()) && assignment.getRExpression() instanceof PsiBinaryExpression && JavaTokenType.PLUS.equals((binOp = (PsiBinaryExpression)assignment.getRExpression()).getOperationTokenType())) {
            PsiExpression left = binOp.getLOperand();
            PsiExpression right = binOp.getROperand();
            if (StreamApiMigrationInspection.sameReference(left, (PsiExpression)lExpr) || StreamApiMigrationInspection.sameReference(right, (PsiExpression)lExpr)) {
                return var;
            }
        }
        return null;
    }

    @Contract(value="null -> null")
    static PsiExpression extractIncrementedLValue(PsiExpression expression) {
        PsiAssignmentExpression assignment;
        if (expression instanceof PsiPostfixExpression) {
            if (JavaTokenType.PLUSPLUS.equals(((PsiPostfixExpression)expression).getOperationTokenType())) {
                return ((PsiPostfixExpression)expression).getOperand();
            }
        } else if (expression instanceof PsiPrefixExpression) {
            if (JavaTokenType.PLUSPLUS.equals(((PsiPrefixExpression)expression).getOperationTokenType())) {
                return ((PsiPrefixExpression)expression).getOperand();
            }
        } else if (expression instanceof PsiAssignmentExpression && ExpressionUtils.isLiteral((PsiElement)StreamApiMigrationInspection.extractAddend(assignment = (PsiAssignmentExpression)expression), 1)) {
            return assignment.getLExpression();
        }
        return null;
    }

    @Nullable
    private static PsiLocalVariable getIncrementedVariable(TerminalBlock tb, List<PsiVariable> variables) {
        if (variables.size() != 1) {
            return null;
        }
        PsiExpression operand = StreamApiMigrationInspection.extractIncrementedLValue(tb.getSingleExpression(PsiExpression.class));
        if (!(operand instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement element = ((PsiReferenceExpression)operand).resolve();
        if (!(element instanceof PsiLocalVariable) || !variables.contains(element) || StreamApiMigrationInspection.isReferencedInOperations(element, tb)) {
            return null;
        }
        return (PsiLocalVariable)element;
    }

    @Nullable
    private static PsiVariable getAccumulatedVariable(TerminalBlock tb, List<PsiVariable> variables) {
        if (variables.size() != 1) {
            return null;
        }
        PsiAssignmentExpression assignment = tb.getSingleExpression(PsiAssignmentExpression.class);
        if (assignment == null) {
            return null;
        }
        PsiVariable var = StreamApiMigrationInspection.extractAccumulator(assignment);
        if (var == null || !variables.contains(var)) {
            return null;
        }
        if (!(var.getType() instanceof PsiPrimitiveType) || var.getType().equalsToText("float")) {
            return null;
        }
        if (StreamApiMigrationInspection.isReferencedInOperations((PsiElement)var, tb)) {
            return null;
        }
        PsiExpression addend = StreamApiMigrationInspection.extractAddend(assignment);
        LOG.assertTrue(addend != null);
        if (ReferencesSearch.search((PsiElement)var, (SearchScope)new LocalSearchScope((PsiElement)addend)).findFirst() != null) {
            return null;
        }
        return var;
    }

    static boolean isAddAllCall(TerminalBlock tb) {
        PsiVariable variable = tb.getVariable();
        PsiMethodCallExpression methodCallExpression = tb.getSingleMethodCall();
        LOG.assertTrue(methodCallExpression != null);
        if (!StreamApiMigrationInspection.isIdentityMapping(variable, methodCallExpression.getArgumentList().getExpressions()[0])) {
            return false;
        }
        PsiExpression qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
        if (qualifierExpression == null || qualifierExpression instanceof PsiThisExpression) {
            PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiMethod.class);
            return method2 == null || !method2.getName().equals("addAll");
        }
        return true;
    }

    private static boolean isCollectCall(TerminalBlock tb) {
        PsiMethodCallExpression methodCallExpression = tb.getSingleMethodCall();
        if (methodCallExpression != null) {
            PsiClass enclosingClass;
            PsiElement resolve;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            PsiClass qualifierClass = null;
            if (qualifierExpression instanceof PsiReferenceExpression) {
                if (ReferencesSearch.search((PsiElement)tb.getVariable(), (SearchScope)new LocalSearchScope((PsiElement)qualifierExpression)).findFirst() != null) {
                    return false;
                }
                resolve = ((PsiReferenceExpression)qualifierExpression).resolve();
                if (resolve instanceof PsiVariable && ReferencesSearch.search((PsiElement)resolve, (SearchScope)new LocalSearchScope((PsiElement)methodCallExpression.getArgumentList())).findFirst() != null) {
                    return false;
                }
                qualifierClass = PsiUtil.resolveClassInType((PsiType)qualifierExpression.getType());
            } else if ((qualifierExpression == null || qualifierExpression instanceof PsiThisExpression) && PsiUtil.getEnclosingStaticElement((PsiElement)methodCallExpression, (PsiClass)(enclosingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiClass.class))) == null) {
                qualifierClass = enclosingClass;
            }
            if (qualifierClass != null && InheritanceUtil.isInheritor(qualifierClass, (boolean)false, (String)"java.util.Collection")) {
                PsiExpression[] args;
                if (tb.intermediateExpressions().anyMatch(expression -> StreamApiMigrationInspection.isExpressionDependsOnUpdatedCollections(expression, qualifierExpression))) {
                    return false;
                }
                resolve = methodExpression.resolve();
                if (resolve instanceof PsiMethod && "add".equals(((PsiMethod)resolve).getName()) && ((PsiMethod)resolve).getParameterList().getParametersCount() == 1 && (args = methodCallExpression.getArgumentList().getExpressions()).length == 1) {
                    if (args[0] instanceof PsiCallExpression) {
                        PsiMethod method2 = ((PsiCallExpression)args[0]).resolveMethod();
                        return method2 != null && !method2.hasTypeParameters() && !StreamApiMigrationInspection.isThrowsCompatible(method2);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isExpressionDependsOnUpdatedCollections(PsiExpression condition, PsiExpression qualifierExpression) {
        PsiElement collection;
        PsiElement psiElement = collection = qualifierExpression instanceof PsiReferenceExpression ? ((PsiReferenceExpression)qualifierExpression).resolve() : null;
        if (collection != null) {
            return ReferencesSearch.search((PsiElement)collection, (SearchScope)new LocalSearchScope((PsiElement)condition)).findFirst() != null;
        }
        final boolean[] dependsOnCollection = new boolean[]{false};
        condition.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                super.visitMethodCallExpression(expression);
                PsiExpression callQualifier = expression.getMethodExpression().getQualifierExpression();
                if (callQualifier == null || callQualifier instanceof PsiThisExpression && ((PsiThisExpression)callQualifier).getQualifier() == null || callQualifier instanceof PsiSuperExpression && ((PsiSuperExpression)callQualifier).getQualifier() == null) {
                    dependsOnCollection[0] = true;
                }
            }

            public void visitThisExpression(PsiThisExpression expression) {
                super.visitThisExpression(expression);
                if (expression.getQualifier() == null && expression.getParent() instanceof PsiExpressionList) {
                    dependsOnCollection[0] = true;
                }
            }

            public void visitClass(PsiClass aClass) {
            }

            public void visitLambdaExpression(PsiLambdaExpression expression) {
            }
        });
        return dependsOnCollection[0];
    }

    @Contract(value="_, null -> false")
    private static boolean isTrivial(PsiStatement body, PsiLoopStatement loopStatement) {
        PsiParameter parameter;
        if (!(loopStatement instanceof PsiForeachStatement)) {
            return false;
        }
        PsiExpression candidate = new LambdaCanBeMethodReferenceInspection().canBeMethodReferenceProblem((PsiElement)(body instanceof PsiBlockStatement ? ((PsiBlockStatement)body).getCodeBlock() : body), (PsiVariable[])new PsiParameter[]{parameter = ((PsiForeachStatement)loopStatement).getIterationParameter()}, (PsiType)StreamApiMigrationInspection.createDefaultConsumerType(parameter.getProject(), (PsiVariable)parameter), null);
        if (!(candidate instanceof PsiCallExpression)) {
            return true;
        }
        PsiMethod method2 = ((PsiCallExpression)candidate).resolveMethod();
        return method2 != null && StreamApiMigrationInspection.isThrowsCompatible(method2);
    }

    static boolean isSupported(PsiType type) {
        if (type instanceof PsiPrimitiveType) {
            return type.equals(PsiType.INT) || type.equals(PsiType.LONG) || type.equals(PsiType.DOUBLE);
        }
        return true;
    }

    private static boolean isThrowsCompatible(PsiMethod method2) {
        return ContainerUtil.find((Object[])method2.getThrowsList().getReferencedTypes(), type -> !ExceptionUtil.isUncheckedException(type)) != null;
    }

    @Contract(value="_, null -> false")
    static boolean isIdentityMapping(PsiVariable variable, PsiExpression mapperCall) {
        return mapperCall instanceof PsiReferenceExpression && ((PsiReferenceExpression)mapperCall).isReferenceTo((PsiElement)variable);
    }

    @Nullable
    private static PsiClassType createDefaultConsumerType(Project project2, PsiVariable variable) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiClass consumerClass = psiFacade.findClass("java.util.function.Consumer", GlobalSearchScope.allScope((Project)project2));
        return consumerClass != null ? psiFacade.getElementFactory().createType(consumerClass, variable.getType()) : null;
    }

    static boolean isVariableSuitableForStream(PsiVariable variable, PsiStatement statement2) {
        PsiStatement body;
        PsiForStatement forStatement;
        PsiElement grandParent;
        PsiElement declaration = variable.getParent();
        if (declaration instanceof PsiDeclarationStatement && (grandParent = declaration.getParent()) instanceof PsiForStatement && (forStatement = (PsiForStatement)grandParent).getInitialization() == declaration && (body = forStatement.getBody()) != null && PsiTreeUtil.isAncestor((PsiElement)statement2, (PsiElement)body, (boolean)false)) {
            return ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope((PsiElement)body)).forEach(ref -> {
                PsiElement element = ref.getElement();
                return !(element instanceof PsiExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element));
            });
        }
        return HighlightControlFlowUtil.isEffectivelyFinal(variable, (PsiElement)statement2, null);
    }

    @Contract(value="null -> null")
    static PsiLocalVariable extractCollectionVariable(PsiExpression qualifierExpression) {
        PsiExpressionList argumentList;
        PsiLocalVariable var;
        PsiExpression initializer;
        PsiElement resolve;
        if (qualifierExpression instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiLocalVariable && (initializer = (var = (PsiLocalVariable)resolve).getInitializer()) instanceof PsiNewExpression && (argumentList = ((PsiNewExpression)initializer).getArgumentList()) != null && argumentList.getExpressions().length == 0) {
            return var;
        }
        return null;
    }

    static InitializerUsageStatus getInitializerUsageStatus(PsiVariable var, PsiStatement nextStatement) {
        ControlFlow controlFlow;
        if (!(var instanceof PsiLocalVariable) || var.getInitializer() == null) {
            return InitializerUsageStatus.UNKNOWN;
        }
        if (StreamApiMigrationInspection.isDeclarationJustBefore(var, nextStatement)) {
            return InitializerUsageStatus.DECLARED_JUST_BEFORE;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)var, (Class[])new Class[]{PsiLambdaExpression.class, PsiMethod.class}) != PsiTreeUtil.getParentOfType((PsiElement)nextStatement, (Class[])new Class[]{PsiLambdaExpression.class, PsiMethod.class})) {
            return InitializerUsageStatus.UNKNOWN;
        }
        PsiElement block = PsiUtil.getVariableCodeBlock((PsiVariable)var, null);
        if (block == null) {
            return InitializerUsageStatus.UNKNOWN;
        }
        try {
            controlFlow = ControlFlowFactory.getInstance(nextStatement.getProject()).getControlFlow(block, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
        }
        catch (AnalysisCanceledException ignored) {
            return InitializerUsageStatus.UNKNOWN;
        }
        int start = controlFlow.getEndOffset((PsiElement)var.getInitializer()) + 1;
        int stop2 = controlFlow.getStartOffset((PsiElement)nextStatement);
        if (ControlFlowUtil.isVariableReferencedBetween(controlFlow, start, stop2, var)) {
            return InitializerUsageStatus.UNKNOWN;
        }
        if (!ControlFlowUtil.isValueUsedWithoutVisitingStop(controlFlow, start, stop2, var)) {
            return InitializerUsageStatus.AT_WANTED_PLACE_ONLY;
        }
        return var.hasModifierProperty("final") ? InitializerUsageStatus.UNKNOWN : InitializerUsageStatus.AT_WANTED_PLACE;
    }

    static boolean isDeclarationJustBefore(PsiVariable var, PsiStatement nextStatement) {
        Object[] elements;
        PsiElement declaration = var.getParent();
        PsiElement nextStatementParent = nextStatement.getParent();
        if (nextStatementParent instanceof PsiLabeledStatement) {
            nextStatement = (PsiStatement)nextStatementParent;
        }
        return declaration instanceof PsiDeclarationStatement && ArrayUtil.getLastElement((Object[])(elements = ((PsiDeclarationStatement)declaration).getDeclaredElements())) == var && nextStatement.equals(PsiTreeUtil.skipSiblingsForward((PsiElement)declaration, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class}));
    }

    static String tryUnbox(PsiVariable variable) {
        PsiType type = variable.getType();
        String mapOp = null;
        if (type.equals(PsiType.INT)) {
            mapOp = "mapToInt";
        } else if (type.equals(PsiType.LONG)) {
            mapOp = "mapToLong";
        } else if (type.equals(PsiType.DOUBLE)) {
            mapOp = "mapToDouble";
        }
        return mapOp == null ? "" : "." + mapOp + "(" + variable.getName() + " -> " + variable.getName() + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Contract(value="null, _ -> null")
    static String tryExtractSortComparatorText(PsiElement element, PsiVariable list) {
        if (!(element instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiExpression expression = ((PsiExpressionStatement)element).getExpression();
        if (!(expression instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression;
        PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
        if (!"sort".equals(methodExpression.getReferenceName())) {
            return null;
        }
        PsiMethod method2 = methodCall.resolveMethod();
        if (method2 == null) {
            return null;
        }
        PsiClass containingClass = method2.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        PsiExpression listExpression = null;
        PsiExpression comparatorExpression = null;
        if ("java.util.Collections".equals(containingClass.getQualifiedName())) {
            PsiExpression[] args = methodCall.getArgumentList().getExpressions();
            if (args.length == 1) {
                listExpression = args[0];
            } else {
                if (args.length != 2) return null;
                listExpression = args[0];
                comparatorExpression = args[1];
            }
        } else if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.List")) {
            listExpression = methodExpression.getQualifierExpression();
            PsiExpression[] args = methodCall.getArgumentList().getExpressions();
            if (args.length != 1) {
                return null;
            }
            comparatorExpression = args[0];
        }
        if (!(listExpression instanceof PsiReferenceExpression) || !((PsiReferenceExpression)listExpression).isReferenceTo((PsiElement)list)) {
            return null;
        }
        if (comparatorExpression != null && !ExpressionUtils.isNullLiteral(comparatorExpression)) return comparatorExpression.getText();
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    static PsiMethodCallExpression extractToArrayExpression(PsiLoopStatement statement2, PsiMethodCallExpression expression) {
        PsiExpression toArrayCandidate;
        PsiElement nextElement = PsiTreeUtil.skipSiblingsForward((PsiElement)statement2, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class});
        if (nextElement instanceof PsiReturnStatement) {
            toArrayCandidate = ((PsiReturnStatement)nextElement).getReturnValue();
        } else {
            PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(nextElement);
            if (assignment != null) {
                toArrayCandidate = assignment.getRExpression();
            } else {
                if (!(nextElement instanceof PsiDeclarationStatement)) return null;
                PsiElement[] elements = ((PsiDeclarationStatement)nextElement).getDeclaredElements();
                if (elements.length != 1 || !(elements[0] instanceof PsiLocalVariable)) return null;
                toArrayCandidate = ((PsiLocalVariable)elements[0]).getInitializer();
            }
        }
        if (!(toArrayCandidate instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)toArrayCandidate;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        if (!"toArray".equals(methodExpression.getReferenceName())) {
            return null;
        }
        PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
        if (!(qualifierExpression instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiLocalVariable collectionVariable = StreamApiMigrationInspection.extractCollectionVariable(expression.getMethodExpression().getQualifierExpression());
        if (collectionVariable == null || !((PsiReferenceExpression)qualifierExpression).isReferenceTo((PsiElement)collectionVariable)) {
            return null;
        }
        PsiExpression initializer = collectionVariable.getInitializer();
        if (initializer == null) {
            return null;
        }
        PsiType type = initializer.getType();
        if (!(type instanceof PsiClassType) || !COLLECTION_TO_ARRAY.containsKey(((PsiClassType)type).rawType().getCanonicalText())) {
            return null;
        }
        if (!(nextElement instanceof PsiReturnStatement) && !ReferencesSearch.search((PsiElement)collectionVariable, (SearchScope)collectionVariable.getUseScope()).forEach(ref -> ref.getElement() == collectionVariable || PsiTreeUtil.isAncestor((PsiElement)statement2, (PsiElement)ref.getElement(), (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)toArrayCandidate, (PsiElement)ref.getElement(), (boolean)false))) {
            return null;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length == 0) {
            return call;
        }
        if (args.length != 1 || !(args[0] instanceof PsiNewExpression)) {
            return null;
        }
        PsiNewExpression newArray = (PsiNewExpression)args[0];
        PsiExpression[] dimensions = newArray.getArrayDimensions();
        if (dimensions.length != 1) {
            return null;
        }
        if (ExpressionUtils.isLiteral((PsiElement)dimensions[0], 0)) {
            return call;
        }
        if (!(dimensions[0] instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression maybeSizeCall = (PsiMethodCallExpression)dimensions[0];
        if (maybeSizeCall.getArgumentList().getExpressions().length != 0) {
            return null;
        }
        PsiReferenceExpression maybeSizeExpression = maybeSizeCall.getMethodExpression();
        PsiExpression sizeQualifier = maybeSizeExpression.getQualifierExpression();
        if (sizeQualifier == null || "size".equals(maybeSizeExpression.getReferenceName()) && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifierExpression, (PsiElement)sizeQualifier)) return call;
        return null;
    }

    static class TerminalBlock {
        @NotNull
        private final Operation myPreviousOp;
        @NotNull
        private final PsiVariable myVariable;
        @NotNull
        private final PsiStatement[] myStatements;

        private TerminalBlock(@NotNull Operation previousOp, @NotNull PsiVariable variable, PsiStatement ... statements) {
            if (previousOp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previousOp", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$TerminalBlock", "<init>"));
            }
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$TerminalBlock", "<init>"));
            }
            if (statements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$TerminalBlock", "<init>"));
            }
            for (PsiStatement statement2 : statements) {
                Objects.requireNonNull(statement2);
            }
            this.myVariable = variable;
            while (true) {
                if (statements.length == 1 && statements[0] instanceof PsiBlockStatement) {
                    statements = ((PsiBlockStatement)statements[0]).getCodeBlock().getStatements();
                    continue;
                }
                if (statements.length != 1 || !(statements[0] instanceof PsiLabeledStatement)) break;
                statements = new PsiStatement[]{((PsiLabeledStatement)statements[0]).getStatement()};
            }
            this.myStatements = statements;
            this.myPreviousOp = previousOp;
        }

        int getStartOffset(ControlFlow cf) {
            return cf.getStartOffset((PsiElement)this.myStatements[0]);
        }

        int getEndOffset(ControlFlow cf) {
            return cf.getEndOffset((PsiElement)this.myStatements[this.myStatements.length - 1]);
        }

        PsiStatement getSingleStatement() {
            return this.myStatements.length == 1 ? this.myStatements[0] : null;
        }

        @NotNull
        PsiStatement[] getStatements() {
            if (this.myStatements == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$TerminalBlock", "getStatements"));
            }
            return this.myStatements;
        }

        @Nullable
        <T extends PsiExpression> T getSingleExpression(Class<T> wantedType) {
            PsiExpression expression;
            PsiStatement statement2 = this.getSingleStatement();
            if (statement2 instanceof PsiExpressionStatement && wantedType.isInstance(expression = ((PsiExpressionStatement)statement2).getExpression())) {
                return (T)((PsiExpression)wantedType.cast(expression));
            }
            return null;
        }

        @Nullable
        PsiMethodCallExpression getSingleMethodCall() {
            return this.getSingleExpression(PsiMethodCallExpression.class);
        }

        @Nullable
        private TerminalBlock extractFilter() {
            PsiStatement first;
            PsiStatement thenBranch;
            PsiIfStatement ifStatement;
            if (this.getSingleStatement() instanceof PsiIfStatement && (ifStatement = (PsiIfStatement)this.getSingleStatement()).getElseBranch() == null && ifStatement.getCondition() != null && (thenBranch = ifStatement.getThenBranch()) != null) {
                return new TerminalBlock(new FilterOp(this.myPreviousOp, ifStatement.getCondition(), this.myVariable, false), this.myVariable, thenBranch);
            }
            if (this.myStatements.length >= 1 && (first = this.myStatements[0]) instanceof PsiIfStatement) {
                PsiStatement[] statements;
                PsiIfStatement ifStatement2 = (PsiIfStatement)first;
                if (ifStatement2.getCondition() == null) {
                    return null;
                }
                PsiStatement branch = ifStatement2.getThenBranch();
                if (branch instanceof PsiBlockStatement && (statements = ((PsiBlockStatement)branch).getCodeBlock().getStatements()).length == 1) {
                    branch = statements[0];
                }
                if (!(branch instanceof PsiContinueStatement) || ((PsiContinueStatement)branch).getLabelIdentifier() != null) {
                    return null;
                }
                if (ifStatement2.getElseBranch() != null) {
                    statements = (PsiStatement[])this.myStatements.clone();
                    statements[0] = ifStatement2.getElseBranch();
                } else {
                    statements = Arrays.copyOfRange(this.myStatements, 1, this.myStatements.length);
                }
                return new TerminalBlock(new FilterOp(this.myPreviousOp, ifStatement2.getCondition(), this.myVariable, true), this.myVariable, statements);
            }
            return null;
        }

        @Nullable
        TerminalBlock extractOperation() {
            PsiLocalVariable declaredVar;
            PsiElement element;
            PsiDeclarationStatement decl;
            PsiElement[] elements;
            PsiStatement first;
            TerminalBlock withFilter = this.extractFilter();
            if (withFilter != null) {
                return withFilter;
            }
            if (this.getSingleStatement() instanceof PsiLoopStatement) {
                PsiStatement[] statements;
                PsiStatement lastStatement;
                PsiLoopStatement loopStatement = (PsiLoopStatement)this.getSingleStatement();
                StreamSource source = StreamSource.tryCreate(loopStatement);
                PsiStatement body = loopStatement.getBody();
                if (source == null || body == null) {
                    return null;
                }
                if (this.myVariable.getType() instanceof PsiPrimitiveType && !this.myVariable.getType().equals(source.getVariable().getType())) {
                    return null;
                }
                FlatMapOp op = new FlatMapOp(this.myPreviousOp, source, this.myVariable, loopStatement);
                TerminalBlock withFlatMap = new TerminalBlock(op, source.getVariable(), body);
                if (ReferencesSearch.search((PsiElement)this.myVariable, (SearchScope)new LocalSearchScope((PsiElement)body)).findFirst() == null) {
                    return withFlatMap;
                }
                TerminalBlock withFlatMapFilter = withFlatMap.extractFilter();
                if (withFlatMapFilter != null && !withFlatMapFilter.isEmpty() && (lastStatement = (statements = withFlatMapFilter.getStatements())[statements.length - 1]) instanceof PsiBreakStatement && op.breaksMe((PsiBreakStatement)lastStatement) && ReferencesSearch.search((PsiElement)withFlatMapFilter.getVariable(), (SearchScope)new LocalSearchScope((PsiElement[])statements)).findFirst() == null) {
                    return new TerminalBlock(new CompoundFilterOp((FilterOp)withFlatMapFilter.getLastOperation(), op), this.myVariable, Arrays.copyOfRange(statements, 0, statements.length - 1));
                }
            }
            if (this.myStatements.length >= 1 && (first = this.myStatements[0]) instanceof PsiDeclarationStatement && (elements = (decl = (PsiDeclarationStatement)first).getDeclaredElements()).length == 1 && (element = elements[0]) instanceof PsiLocalVariable && StreamApiMigrationInspection.isSupported((declaredVar = (PsiLocalVariable)element).getType())) {
                PsiExpression initializer = declaredVar.getInitializer();
                PsiStatement[] leftOver = Arrays.copyOfRange(this.myStatements, 1, this.myStatements.length);
                if (initializer != null && ReferencesSearch.search((PsiElement)this.myVariable, (SearchScope)new LocalSearchScope((PsiElement[])leftOver)).findFirst() == null) {
                    MapOp op = new MapOp(this.myPreviousOp, initializer, this.myVariable, declaredVar.getType());
                    return new TerminalBlock(op, (PsiVariable)declaredVar, leftOver);
                }
            }
            return null;
        }

        @NotNull
        public Operation getLastOperation() {
            Operation operation = this.myPreviousOp;
            if (operation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$TerminalBlock", "getLastOperation"));
            }
            return operation;
        }

        @NotNull
        TerminalBlock extractOperations() {
            TerminalBlock terminalBlock = StreamEx.iterate((Object)this, Objects::nonNull, TerminalBlock::extractOperation).reduce((a, b) -> b).orElse(this);
            if (terminalBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$TerminalBlock", "extractOperations"));
            }
            return terminalBlock;
        }

        @NotNull
        public PsiVariable getVariable() {
            PsiVariable psiVariable = this.myVariable;
            if (psiVariable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$TerminalBlock", "getVariable"));
            }
            return psiVariable;
        }

        public boolean hasOperations() {
            return !(this.myPreviousOp instanceof StreamSource);
        }

        public boolean isEmpty() {
            return this.myStatements.length == 0;
        }

        @NotNull
        private StreamEx<Operation> operations() {
            StreamEx streamEx = StreamEx.iterate((Object)this.myPreviousOp, Objects::nonNull, Operation::getPreviousOp);
            if (streamEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$TerminalBlock", "operations"));
            }
            return streamEx;
        }

        public Collection<Operation> getOperations() {
            ArrayDeque<Operation> ops = new ArrayDeque<Operation>();
            this.operations().forEach(ops::addFirst);
            return ops;
        }

        public StreamEx<PsiExpression> intermediateExpressions() {
            return ((StreamEx)this.operations().remove(StreamSource.class::isInstance)).flatMap(Operation::expressions);
        }

        public StreamEx<PsiExpression> intermediateAndSourceExpressions() {
            return this.operations().flatMap(Operation::expressions);
        }

        public PsiElement convertToElement(PsiElementFactory factory) {
            if (this.myStatements.length == 1) {
                return this.myStatements[0];
            }
            PsiCodeBlock block = factory.createCodeBlock();
            for (PsiStatement statement2 : this.myStatements) {
                block.add((PsiElement)statement2);
            }
            return block;
        }

        @NotNull
        public static TerminalBlock from(StreamSource source, @NotNull PsiStatement body) {
            if (body == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$TerminalBlock", "from"));
            }
            TerminalBlock terminalBlock = new TerminalBlock(source, source.myVariable, body).extractOperations();
            if (terminalBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$TerminalBlock", "from"));
            }
            return terminalBlock;
        }
    }

    static class CountingLoop
    extends StreamSource {
        final PsiExpression myBound;
        final boolean myIncluding;

        private CountingLoop(PsiLocalVariable counter, PsiExpression initializer, PsiExpression bound, boolean including) {
            super((PsiVariable)counter, initializer);
            this.myBound = bound;
            this.myIncluding = including;
        }

        @Override
        StreamEx<PsiExpression> expressions() {
            return StreamEx.of((Object[])new PsiExpression[]{this.myExpression, this.myBound});
        }

        @Override
        public String createReplacement() {
            String className = this.myVariable.getType().equals(PsiType.LONG) ? "java.util.stream.LongStream" : "java.util.stream.IntStream";
            String methodName = this.myIncluding ? "rangeClosed" : "range";
            return className + "." + methodName + "(" + this.myExpression.getText() + ", " + this.myBound.getText() + ")";
        }

        @Nullable
        public static CountingLoop from(PsiForStatement forStatement) {
            PsiExpression ref;
            PsiExpression bound;
            if (!(forStatement.getInitialization() instanceof PsiDeclarationStatement)) {
                return null;
            }
            PsiDeclarationStatement initialization = (PsiDeclarationStatement)forStatement.getInitialization();
            if (initialization.getDeclaredElements().length != 1) {
                return null;
            }
            PsiElement declaration = initialization.getDeclaredElements()[0];
            if (!(declaration instanceof PsiLocalVariable)) {
                return null;
            }
            PsiLocalVariable counter = (PsiLocalVariable)declaration;
            if (!counter.getType().equals(PsiType.INT) && !counter.getType().equals(PsiType.LONG)) {
                return null;
            }
            PsiExpression initializer = counter.getInitializer();
            if (initializer == null) {
                return null;
            }
            if (!(forStatement.getUpdate() instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpression lValue = StreamApiMigrationInspection.extractIncrementedLValue(((PsiExpressionStatement)forStatement.getUpdate()).getExpression());
            if (!(lValue instanceof PsiReferenceExpression) || !((PsiReferenceExpression)lValue).isReferenceTo((PsiElement)counter)) {
                return null;
            }
            if (!(forStatement.getCondition() instanceof PsiBinaryExpression)) {
                return null;
            }
            PsiBinaryExpression condition = (PsiBinaryExpression)forStatement.getCondition();
            IElementType type = condition.getOperationTokenType();
            boolean closed = false;
            if (type.equals(JavaTokenType.LE)) {
                bound = condition.getROperand();
                ref = condition.getLOperand();
                closed = true;
            } else if (type.equals(JavaTokenType.LT)) {
                bound = condition.getROperand();
                ref = condition.getLOperand();
            } else if (type.equals(JavaTokenType.GE)) {
                bound = condition.getLOperand();
                ref = condition.getROperand();
                closed = true;
            } else if (type.equals(JavaTokenType.GT)) {
                bound = condition.getLOperand();
                ref = condition.getROperand();
            } else {
                return null;
            }
            if (bound == null || !(ref instanceof PsiReferenceExpression) || !((PsiReferenceExpression)ref).isReferenceTo((PsiElement)counter)) {
                return null;
            }
            if (!TypeConversionUtil.areTypesAssignmentCompatible((PsiType)counter.getType(), (PsiExpression)bound)) {
                return null;
            }
            return new CountingLoop(counter, initializer, bound, closed);
        }
    }

    static class CollectionStream
    extends StreamSource {
        private CollectionStream(PsiVariable variable, PsiExpression expression) {
            super(variable, expression);
        }

        @Override
        String createReplacement() {
            return ParenthesesUtils.getText(this.myExpression, 2) + ".stream()" + StreamApiMigrationInspection.tryUnbox(this.myVariable);
        }

        @Contract(value="null, _ -> false")
        static boolean isRawSubstitution(PsiType iteratedValueType, PsiClass collectionClass) {
            return iteratedValueType instanceof PsiClassType && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)collectionClass, (PsiSubstitutor)TypeConversionUtil.getSuperClassSubstitutor((PsiClass)collectionClass, (PsiClassType)((PsiClassType)iteratedValueType)));
        }

        @Nullable
        public static CollectionStream from(PsiForeachStatement statement2) {
            PsiExpression iteratedValue = statement2.getIteratedValue();
            if (iteratedValue == null) {
                return null;
            }
            PsiType iteratedValueType = iteratedValue.getType();
            PsiClass collectionClass = JavaPsiFacade.getInstance((Project)statement2.getProject()).findClass("java.util.Collection", statement2.getResolveScope());
            PsiClass iteratorClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)iteratedValueType);
            if (collectionClass == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)iteratorClass, (PsiClass)collectionClass, (boolean)true) || CollectionStream.isRawSubstitution(iteratedValueType, collectionClass) || !StreamApiMigrationInspection.isSupported(statement2.getIterationParameter().getType())) {
                return null;
            }
            return new CollectionStream((PsiVariable)statement2.getIterationParameter(), iteratedValue);
        }
    }

    static class ArrayStream
    extends StreamSource {
        private ArrayStream(PsiVariable variable, PsiExpression expression) {
            super(variable, expression);
        }

        @Override
        String createReplacement() {
            return "java.util.Arrays.stream(" + this.myExpression.getText() + ")";
        }

        @Nullable
        public static ArrayStream from(PsiForeachStatement statement2) {
            PsiExpression iteratedValue = statement2.getIteratedValue();
            if (iteratedValue == null) {
                return null;
            }
            PsiType iteratedValueType = iteratedValue.getType();
            PsiParameter parameter = statement2.getIterationParameter();
            if (!(iteratedValueType instanceof PsiArrayType) || !StreamApiMigrationInspection.isSupported(((PsiArrayType)iteratedValueType).getComponentType()) || parameter.getType() instanceof PsiPrimitiveType && !parameter.getType().equals(((PsiArrayType)iteratedValueType).getComponentType())) {
                return null;
            }
            return new ArrayStream((PsiVariable)parameter, iteratedValue);
        }
    }

    static abstract class StreamSource
    extends Operation {
        protected StreamSource(PsiVariable variable, PsiExpression expression) {
            super(null, expression, variable);
        }

        @Contract(value="null -> null")
        static StreamSource tryCreate(PsiLoopStatement statement2) {
            if (statement2 instanceof PsiForStatement) {
                return CountingLoop.from((PsiForStatement)statement2);
            }
            if (statement2 instanceof PsiForeachStatement) {
                ArrayStream source = ArrayStream.from((PsiForeachStatement)statement2);
                return source == null ? CollectionStream.from((PsiForeachStatement)statement2) : source;
            }
            return null;
        }
    }

    static class FlatMapOp
    extends Operation {
        private final PsiLoopStatement myLoop;
        private final StreamSource mySource;

        FlatMapOp(@Nullable Operation previousOp, StreamSource source, PsiVariable variable, PsiLoopStatement loop) {
            super(previousOp, source.getExpression(), variable);
            this.myLoop = loop;
            this.mySource = source;
        }

        @Override
        public String createReplacement() {
            String operation = "flatMap";
            PsiType type = this.mySource.getVariable().getType();
            if (type instanceof PsiPrimitiveType && !type.equals(this.myVariable.getType())) {
                if (type.equals(PsiType.INT)) {
                    operation = "flatMapToInt";
                } else if (type.equals(PsiType.LONG)) {
                    operation = "flatMapToLong";
                } else if (type.equals(PsiType.DOUBLE)) {
                    operation = "flatMapToDouble";
                }
            }
            return "." + operation + "(" + this.myVariable.getName() + " -> " + this.getStreamExpression() + ")";
        }

        @NotNull
        String getStreamExpression() {
            String string = this.mySource.createReplacement();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$FlatMapOp", "getStreamExpression"));
            }
            return string;
        }

        boolean breaksMe(PsiBreakStatement statement2) {
            return statement2.findExitedStatement() == this.myLoop;
        }
    }

    static class MapOp
    extends Operation {
        @Nullable
        private final PsiType myType;

        MapOp(@Nullable Operation previousOp, PsiExpression expression, PsiVariable variable, @Nullable PsiType targetType) {
            super(previousOp, expression, variable);
            this.myType = targetType;
        }

        @Override
        public String createReplacement() {
            if (StreamApiMigrationInspection.isIdentityMapping(this.myVariable, this.myExpression)) {
                if (!(this.myType instanceof PsiPrimitiveType)) {
                    return this.myVariable.getType() instanceof PsiPrimitiveType ? ".boxed()" : "";
                }
                if (this.myType.equals(this.myVariable.getType())) {
                    return "";
                }
                if (PsiType.LONG.equals((Object)this.myType) && PsiType.INT.equals((Object)this.myVariable.getType())) {
                    return ".asLongStream()";
                }
                if (PsiType.DOUBLE.equals((Object)this.myType) && (PsiType.LONG.equals((Object)this.myVariable.getType()) || PsiType.INT.equals((Object)this.myVariable.getType()))) {
                    return ".asDoubleStream()";
                }
            }
            String operationName = "map";
            if (this.myType instanceof PsiPrimitiveType) {
                if (!this.myType.equals(this.myVariable.getType())) {
                    if (PsiType.INT.equals((Object)this.myType)) {
                        operationName = "mapToInt";
                    } else if (PsiType.LONG.equals((Object)this.myType)) {
                        operationName = "mapToLong";
                    } else if (PsiType.DOUBLE.equals((Object)this.myType)) {
                        operationName = "mapToDouble";
                    }
                }
            } else if (this.myVariable.getType() instanceof PsiPrimitiveType) {
                operationName = "mapToObj";
            }
            PsiExpression expression = this.myType == null ? this.myExpression : RefactoringUtil.convertInitializerToNormalExpression(this.myExpression, this.myType);
            return "." + operationName + "(" + LambdaUtil.createLambda((PsiVariable)this.myVariable, (PsiExpression)expression) + ")";
        }
    }

    static class CompoundFilterOp
    extends FilterOp {
        private final FlatMapOp myFlatMapOp;
        private final PsiVariable myMatchVariable;

        CompoundFilterOp(FilterOp source, FlatMapOp flatMapOp) {
            super(flatMapOp.myPreviousOp, source.getExpression(), flatMapOp.myVariable, source.myNegated);
            this.myMatchVariable = source.myVariable;
            this.myFlatMapOp = flatMapOp;
        }

        @Override
        PsiExpression makeIntermediateExpression(PsiElementFactory factory) {
            return factory.createExpressionFromText(this.myFlatMapOp.getStreamExpression() + ".anyMatch(" + LambdaUtil.createLambda((PsiVariable)this.myMatchVariable, (PsiExpression)this.myExpression) + ")", (PsiElement)this.myExpression);
        }

        @Override
        StreamEx<PsiExpression> expressions() {
            return StreamEx.of((Object[])new PsiExpression[]{this.myExpression, this.myFlatMapOp.myExpression});
        }
    }

    static class FilterOp
    extends Operation {
        private final boolean myNegated;

        FilterOp(@Nullable Operation previousOp, PsiExpression condition, PsiVariable variable, boolean negated) {
            super(previousOp, condition, variable);
            this.myNegated = negated;
        }

        public boolean isNegated() {
            return this.myNegated;
        }

        @Override
        public String createReplacement() {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myExpression.getProject());
            PsiExpression intermediate = this.makeIntermediateExpression(factory);
            PsiExpression expression = this.myNegated ? factory.createExpressionFromText(BoolUtils.getNegatedExpressionText(intermediate), (PsiElement)this.myExpression) : intermediate;
            return ".filter(" + LambdaUtil.createLambda((PsiVariable)this.myVariable, (PsiExpression)expression) + ")";
        }

        PsiExpression makeIntermediateExpression(PsiElementFactory factory) {
            return this.myExpression;
        }
    }

    static abstract class Operation {
        final PsiExpression myExpression;
        final PsiVariable myVariable;
        @Nullable
        final Operation myPreviousOp;

        protected Operation(@Nullable Operation previousOp, PsiExpression expression, PsiVariable variable) {
            this.myExpression = expression;
            this.myVariable = variable;
            this.myPreviousOp = previousOp;
        }

        public PsiVariable getVariable() {
            return this.myVariable;
        }

        @Nullable
        public Operation getPreviousOp() {
            return this.myPreviousOp;
        }

        PsiExpression getExpression() {
            return this.myExpression;
        }

        StreamEx<PsiExpression> expressions() {
            return StreamEx.of((Object)this.myExpression);
        }

        abstract String createReplacement();
    }

    private class StreamApiMigrationVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myIsOnTheFly;

        public StreamApiMigrationVisitor(ProblemsHolder holder, boolean isOnTheFly) {
            this.myHolder = holder;
            this.myIsOnTheFly = isOnTheFly;
        }

        public void visitForeachStatement(PsiForeachStatement statement2) {
            super.visitForeachStatement(statement2);
            this.processLoop((PsiLoopStatement)statement2);
        }

        public void visitForStatement(PsiForStatement statement2) {
            super.visitForStatement(statement2);
            this.processLoop((PsiLoopStatement)statement2);
        }

        void processLoop(PsiLoopStatement statement2) {
            ControlFlow controlFlow;
            PsiStatement body = statement2.getBody();
            if (body == null) {
                return;
            }
            StreamSource source = StreamSource.tryCreate(statement2);
            if (source == null) {
                return;
            }
            if (!ExceptionUtil.getThrownCheckedExceptions(new PsiElement[]{body}).isEmpty()) {
                return;
            }
            TerminalBlock tb = TerminalBlock.from(source, body);
            if (tb.isEmpty()) {
                return;
            }
            try {
                controlFlow = ControlFlowFactory.getInstance(this.myHolder.getProject()).getControlFlow((PsiElement)body, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
            }
            catch (AnalysisCanceledException ignored) {
                return;
            }
            int startOffset = tb.getStartOffset(controlFlow);
            int endOffset = tb.getEndOffset(controlFlow);
            if (startOffset < 0 || endOffset < 0) {
                return;
            }
            Collection<PsiStatement> exitPoints = ControlFlowUtil.findExitPointsAndStatements(controlFlow, startOffset, endOffset, new IntArrayList(), PsiContinueStatement.class, PsiBreakStatement.class, PsiReturnStatement.class, PsiThrowStatement.class);
            startOffset = controlFlow.getStartOffset((PsiElement)body);
            endOffset = controlFlow.getEndOffset((PsiElement)body);
            if (startOffset < 0 || endOffset < 0) {
                return;
            }
            PsiElement surrounder = PsiTreeUtil.getParentOfType((PsiElement)statement2, (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class});
            List nonFinalVariables = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(ControlFlowUtil.getUsedVariables(controlFlow, startOffset, endOffset)).remove(variable -> variable instanceof PsiField)).remove(variable -> PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class}) != surrounder)).remove(variable -> StreamApiMigrationInspection.isVariableSuitableForStream(variable, (PsiStatement)statement2))).toList();
            if (exitPoints.isEmpty()) {
                if (StreamApiMigrationInspection.getIncrementedVariable(tb, nonFinalVariables) != null) {
                    this.registerProblem(statement2, "count", new ReplaceWithCountFix());
                }
                if (StreamApiMigrationInspection.getAccumulatedVariable(tb, nonFinalVariables) != null) {
                    this.registerProblem(statement2, "sum", new ReplaceWithSumFix());
                }
                if (!nonFinalVariables.isEmpty()) {
                    return;
                }
                if (StreamApiMigrationInspection.isCollectCall(tb)) {
                    String methodName;
                    boolean addAll;
                    boolean bl = addAll = statement2 instanceof PsiForeachStatement && !tb.hasOperations() && StreamApiMigrationInspection.isAddAllCall(tb);
                    if (addAll) {
                        methodName = "addAll";
                    } else {
                        PsiMethodCallExpression methodCallExpression = tb.getSingleMethodCall();
                        if (this.canCollect(statement2, methodCallExpression)) {
                            methodName = StreamApiMigrationInspection.extractToArrayExpression(statement2, methodCallExpression) != null ? "toArray" : "collect";
                        } else {
                            if (!StreamApiMigrationInspection.this.SUGGEST_FOREACH) {
                                return;
                            }
                            methodName = "forEach";
                        }
                    }
                    this.registerProblem(statement2, methodName, new ReplaceWithCollectFix(methodName));
                } else if (StreamApiMigrationInspection.this.SUGGEST_FOREACH && (tb.hasOperations() || !(source instanceof ArrayStream) && (StreamApiMigrationInspection.this.REPLACE_TRIVIAL_FOREACH || !StreamApiMigrationInspection.isTrivial(body, statement2)))) {
                    ReplaceWithForeachCallFix forEachFix = new ReplaceWithForeachCallFix("forEach");
                    LocalQuickFix[] fixes = new LocalQuickFix[]{forEachFix};
                    if (tb.hasOperations()) {
                        fixes = new LocalQuickFix[]{forEachFix, new ReplaceWithForeachCallFix("forEachOrdered")};
                    }
                    this.registerProblem(statement2, "forEach", fixes);
                }
            } else {
                if (!tb.hasOperations() && !StreamApiMigrationInspection.this.REPLACE_TRIVIAL_FOREACH) {
                    return;
                }
                if (nonFinalVariables.isEmpty() && tb.getSingleStatement() instanceof PsiReturnStatement) {
                    this.handleSingleReturn(statement2, tb);
                }
                if (tb.intermediateAndSourceExpressions().flatCollection(expr -> PsiTreeUtil.collectElementsOfType((PsiElement)expr, (Class[])new Class[]{PsiReferenceExpression.class})).map(PsiReference::resolve).anyMatch(nonFinalVariables::contains)) {
                    return;
                }
                PsiStatement[] statements = tb.getStatements();
                if (statements.length == 2) {
                    PsiStatement breakStatement = statements[1];
                    if (!ControlFlowUtils.statementBreaksLoop(breakStatement, statement2)) {
                        return;
                    }
                    if (ReferencesSearch.search((PsiElement)tb.getVariable(), (SearchScope)new LocalSearchScope((PsiElement[])statements)).findFirst() == null && exitPoints.size() == 1 && exitPoints.contains(breakStatement)) {
                        this.registerProblem(statement2, "anyMatch", new ReplaceWithMatchFix("anyMatch"));
                        return;
                    }
                    if (nonFinalVariables.isEmpty() && statements[0] instanceof PsiExpressionStatement) {
                        this.registerProblem(statement2, "findFirst", new ReplaceWithFindFirstFix());
                    } else if (nonFinalVariables.size() == 1) {
                        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)statements[0]);
                        if (assignment == null) {
                            return;
                        }
                        PsiExpression lValue = assignment.getLExpression();
                        if (!(lValue instanceof PsiReferenceExpression)) {
                            return;
                        }
                        PsiElement var = ((PsiReferenceExpression)lValue).resolve();
                        if (!(var instanceof PsiVariable) || !nonFinalVariables.contains(var)) {
                            return;
                        }
                        PsiExpression rValue = assignment.getRExpression();
                        if (rValue == null || StreamApiMigrationInspection.isVariableReferenced((PsiVariable)var, rValue)) {
                            return;
                        }
                        if (tb.getVariable().getType() instanceof PsiPrimitiveType && !StreamApiMigrationInspection.isIdentityMapping(tb.getVariable(), rValue)) {
                            return;
                        }
                        this.registerProblem(statement2, "findFirst", new ReplaceWithFindFirstFix());
                    }
                }
            }
        }

        boolean canCollect(PsiLoopStatement statement2, PsiMethodCallExpression methodCallExpression) {
            if (methodCallExpression == null) {
                return false;
            }
            PsiLocalVariable variable = StreamApiMigrationInspection.extractCollectionVariable(methodCallExpression.getMethodExpression().getQualifierExpression());
            if (variable == null) {
                return false;
            }
            return StreamApiMigrationInspection.getInitializerUsageStatus((PsiVariable)variable, (PsiStatement)statement2) != InitializerUsageStatus.UNKNOWN;
        }

        void handleSingleReturn(PsiLoopStatement statement2, TerminalBlock tb) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)tb.getSingleStatement();
            PsiExpression value = returnStatement.getReturnValue();
            PsiReturnStatement nextReturnStatement = StreamApiMigrationInspection.getNextReturnStatement((PsiStatement)statement2);
            if (nextReturnStatement != null && (ExpressionUtils.isLiteral((PsiElement)value, Boolean.TRUE) || ExpressionUtils.isLiteral((PsiElement)value, Boolean.FALSE))) {
                String methodName;
                boolean foundResult = (Boolean)((PsiLiteralExpression)value).getValue();
                if (foundResult) {
                    methodName = "anyMatch";
                } else {
                    methodName = "noneMatch";
                    Operation lastOp = tb.getLastOperation();
                    if (lastOp instanceof FilterOp && ((FilterOp)lastOp).isNegated() ^ BoolUtils.isNegation(lastOp.getExpression())) {
                        methodName = "allMatch";
                    }
                }
                if (nextReturnStatement.getParent() == statement2.getParent() || ExpressionUtils.isLiteral((PsiElement)nextReturnStatement.getReturnValue(), !foundResult)) {
                    this.registerProblem(statement2, methodName, new ReplaceWithMatchFix(methodName));
                    return;
                }
            }
            if (!StreamApiMigrationInspection.isVariableReferenced(tb.getVariable(), value)) {
                Operation lastOp = tb.getLastOperation();
                if (!StreamApiMigrationInspection.this.REPLACE_TRIVIAL_FOREACH && lastOp instanceof StreamSource || lastOp instanceof FilterOp && lastOp.getPreviousOp() instanceof StreamSource) {
                    return;
                }
                this.registerProblem(statement2, "anyMatch", new ReplaceWithMatchFix("anyMatch"));
            }
            if (nextReturnStatement != null && ExpressionUtils.isSimpleExpression(nextReturnStatement.getReturnValue()) && (!(tb.getVariable().getType() instanceof PsiPrimitiveType) || StreamApiMigrationInspection.isIdentityMapping(tb.getVariable(), value))) {
                this.registerProblem(statement2, "findFirst", new ReplaceWithFindFirstFix());
            }
        }

        @NotNull
        private TextRange getRange(PsiLoopStatement statement2) {
            PsiJavaToken rParenth;
            boolean wholeStatement = false;
            if (this.myIsOnTheFly) {
                if (StreamApiMigrationInspection.this.myKey == null) {
                    StreamApiMigrationInspection.this.myKey = HighlightDisplayKey.find((String)StreamApiMigrationInspection.this.getShortName());
                }
                if (StreamApiMigrationInspection.this.myKey != null) {
                    InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(statement2.getProject()).getCurrentProfile();
                    HighlightDisplayLevel level = profile.getErrorLevel(StreamApiMigrationInspection.this.myKey, (PsiElement)statement2);
                    wholeStatement = HighlightDisplayLevel.DO_NOT_SHOW.equals(level);
                }
            }
            if (statement2 instanceof PsiForeachStatement) {
                rParenth = ((PsiForeachStatement)statement2).getRParenth();
                if (wholeStatement && rParenth != null) {
                    TextRange textRange = new TextRange(statement2.getTextOffset(), rParenth.getTextOffset() + 1);
                    if (textRange == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$StreamApiMigrationVisitor", "getRange"));
                    }
                    return textRange;
                }
                PsiExpression iteratedValue = ((PsiForeachStatement)statement2).getIteratedValue();
                LOG.assertTrue(iteratedValue != null);
                TextRange textRange = iteratedValue.getTextRange();
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$StreamApiMigrationVisitor", "getRange"));
                }
                return textRange;
            }
            if (statement2 instanceof PsiForStatement) {
                rParenth = ((PsiForStatement)statement2).getRParenth();
                if (wholeStatement && rParenth != null) {
                    TextRange textRange = new TextRange(statement2.getTextOffset(), rParenth.getTextOffset() + 1);
                    if (textRange == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$StreamApiMigrationVisitor", "getRange"));
                    }
                    return textRange;
                }
                PsiStatement initialization = ((PsiForStatement)statement2).getInitialization();
                LOG.assertTrue(initialization != null);
                TextRange textRange = initialization.getTextRange();
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$StreamApiMigrationVisitor", "getRange"));
                }
                return textRange;
            }
            throw new IllegalStateException("Unexpected statement type: " + statement2);
        }

        private void registerProblem(PsiLoopStatement statement2, String methodName, LocalQuickFix ... fixes) {
            this.myHolder.registerProblem((PsiElement)statement2, this.getRange(statement2).shiftRight(-statement2.getTextOffset()), "Can be replaced with '" + methodName + "' call", fixes);
        }
    }

    static enum InitializerUsageStatus {
        DECLARED_JUST_BEFORE,
        AT_WANTED_PLACE_ONLY,
        AT_WANTED_PLACE,
        UNKNOWN;

    }
}

