/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.MigrateToStreamFix;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

class ReplaceWithMatchFix
extends MigrateToStreamFix {
    private static final Logger LOG = Logger.getInstance((String)("#" + ReplaceWithMatchFix.class.getName()));
    private final String myMethodName;

    public ReplaceWithMatchFix(String methodName) {
        this.myMethodName = methodName;
    }

    @NotNull
    public String getFamilyName() {
        String string = "Replace with " + this.myMethodName + "()";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/ReplaceWithMatchFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    PsiElement migrate(@NotNull Project project2, @NotNull PsiLoopStatement loopStatement, @NotNull PsiStatement body, @NotNull StreamApiMigrationInspection.TerminalBlock tb) {
        PsiStatement[] statements;
        PsiReturnStatement returnStatement;
        PsiExpression value;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/streamMigration/ReplaceWithMatchFix", "migrate"));
        }
        if (loopStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopStatement", "com/intellij/codeInspection/streamMigration/ReplaceWithMatchFix", "migrate"));
        }
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/codeInspection/streamMigration/ReplaceWithMatchFix", "migrate"));
        }
        if (tb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/streamMigration/ReplaceWithMatchFix", "migrate"));
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        StringBuilder builder = ReplaceWithMatchFix.generateStream(tb.getLastOperation());
        if (tb.getSingleStatement() instanceof PsiReturnStatement && (ExpressionUtils.isLiteral((PsiElement)(value = (returnStatement = (PsiReturnStatement)tb.getSingleStatement()).getReturnValue()), Boolean.TRUE) || ExpressionUtils.isLiteral((PsiElement)value, Boolean.FALSE))) {
            boolean foundResult = (Boolean)((PsiLiteralExpression)value).getValue();
            PsiReturnStatement nextReturnStatement = StreamApiMigrationInspection.getNextReturnStatement((PsiStatement)loopStatement);
            if (nextReturnStatement != null) {
                PsiExpression returnValue = nextReturnStatement.getReturnValue();
                if (returnValue == null) {
                    return null;
                }
                String methodName = foundResult ? "anyMatch" : "noneMatch";
                String streamText = ReplaceWithMatchFix.addTerminalOperation(builder.toString(), methodName, (PsiElement)loopStatement, tb);
                ReplaceWithMatchFix.restoreComments(loopStatement, body);
                if (nextReturnStatement.getParent() == loopStatement.getParent()) {
                    if (!ExpressionUtils.isLiteral((PsiElement)returnValue, !foundResult)) {
                        streamText = streamText + (foundResult ? "||" : "&&") + ParenthesesUtils.getText(returnValue, 13);
                    }
                    ReplaceWithMatchFix.removeLoop(loopStatement);
                    return returnValue.replace((PsiElement)elementFactory.createExpressionFromText(streamText, (PsiElement)nextReturnStatement));
                }
                PsiElement result2 = loopStatement.replace((PsiElement)elementFactory.createStatementFromText("return " + streamText + ";", (PsiElement)loopStatement));
                if (!ReplaceWithMatchFix.isReachable(nextReturnStatement)) {
                    nextReturnStatement.delete();
                }
                return result2;
            }
        }
        if (!((statements = tb.getStatements()).length == 1 || statements.length == 2 && ControlFlowUtils.statementBreaksLoop(statements[1], loopStatement))) {
            return null;
        }
        ReplaceWithMatchFix.restoreComments(loopStatement, body);
        String streamText = ReplaceWithMatchFix.addTerminalOperation(builder.toString(), "anyMatch", (PsiElement)loopStatement, tb);
        PsiStatement statement2 = statements[0];
        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)statement2);
        if (assignment != null) {
            PsiElement maybeVar;
            PsiExpression lValue = assignment.getLExpression();
            PsiExpression rValue = assignment.getRExpression();
            if (lValue instanceof PsiReferenceExpression && rValue != null && (maybeVar = ((PsiReferenceExpression)lValue).resolve()) instanceof PsiVariable) {
                PsiVariable var = (PsiVariable)maybeVar;
                PsiExpression initializer = var.getInitializer();
                StreamApiMigrationInspection.InitializerUsageStatus status = StreamApiMigrationInspection.getInitializerUsageStatus(var, (PsiStatement)loopStatement);
                if (initializer != null && status != StreamApiMigrationInspection.InitializerUsageStatus.UNKNOWN) {
                    String replacement = ExpressionUtils.isLiteral((PsiElement)initializer, Boolean.FALSE) && ExpressionUtils.isLiteral((PsiElement)rValue, Boolean.TRUE) ? streamText : (ExpressionUtils.isLiteral((PsiElement)initializer, Boolean.TRUE) && ExpressionUtils.isLiteral((PsiElement)rValue, Boolean.FALSE) ? "!" + streamText : streamText + "?" + rValue.getText() + ":" + initializer.getText());
                    return ReplaceWithMatchFix.replaceInitializer(loopStatement, var, initializer, replacement, status);
                }
            }
        }
        String replacement = "if(" + streamText + "){" + statement2.getText() + "}";
        return loopStatement.replace((PsiElement)elementFactory.createStatementFromText(replacement, (PsiElement)loopStatement));
    }

    private static String addTerminalOperation(String origStream, String methodName, @NotNull PsiElement contextElement, @NotNull StreamApiMigrationInspection.TerminalBlock tb) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/codeInspection/streamMigration/ReplaceWithMatchFix", "addTerminalOperation"));
        }
        if (tb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/streamMigration/ReplaceWithMatchFix", "addTerminalOperation"));
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)contextElement.getProject());
        PsiExpression stream = elementFactory.createExpressionFromText(origStream, contextElement);
        LOG.assertTrue(stream instanceof PsiMethodCallExpression);
        PsiElement nameElement = ((PsiMethodCallExpression)stream).getMethodExpression().getReferenceNameElement();
        if (nameElement != null && nameElement.getText().equals("filter")) {
            PsiLambdaExpression lambda2;
            PsiElement lambdaBody;
            PsiExpression[] expressions;
            if (methodName.equals("noneMatch") && (expressions = ((PsiMethodCallExpression)stream).getArgumentList().getExpressions()).length == 1 && expressions[0] instanceof PsiLambdaExpression && (lambdaBody = (lambda2 = (PsiLambdaExpression)expressions[0]).getBody()) instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)lambdaBody)) {
                PsiExpression negated = BoolUtils.getNegated((PsiExpression)lambdaBody);
                LOG.assertTrue(negated != null, (Object)lambdaBody.getText());
                lambdaBody.replace((PsiElement)negated);
                methodName = "allMatch";
            }
            nameElement.replace((PsiElement)elementFactory.createIdentifier(methodName));
            return stream.getText();
        }
        return origStream + "." + methodName + "(" + tb.getVariable().getName() + " -> true)";
    }
}

