/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

abstract class MigrateToStreamFix
implements LocalQuickFix {
    MigrateToStreamFix() {
    }

    @NotNull
    public String getName() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/MigrateToStreamFix", "getName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/streamMigration/MigrateToStreamFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/streamMigration/MigrateToStreamFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (element instanceof PsiLoopStatement) {
            PsiLoopStatement loopStatement = (PsiLoopStatement)element;
            StreamApiMigrationInspection.StreamSource source = StreamApiMigrationInspection.StreamSource.tryCreate(loopStatement);
            PsiStatement body = loopStatement.getBody();
            if (body == null || source == null) {
                return;
            }
            StreamApiMigrationInspection.TerminalBlock tb = StreamApiMigrationInspection.TerminalBlock.from(source, body);
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)loopStatement)) {
                return;
            }
            PsiElement result2 = this.migrate(project2, loopStatement, body, tb);
            if (result2 != null) {
                MigrateToStreamFix.simplifyAndFormat(project2, result2);
            }
        }
    }

    abstract PsiElement migrate(@NotNull Project var1, @NotNull PsiLoopStatement var2, @NotNull PsiStatement var3, @NotNull StreamApiMigrationInspection.TerminalBlock var4);

    static PsiElement replaceWithNumericAddition(@NotNull Project project2, PsiLoopStatement loopStatement, PsiVariable var, StringBuilder builder, PsiType expressionType) {
        PsiExpression initializer;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/streamMigration/MigrateToStreamFix", "replaceWithNumericAddition"));
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        MigrateToStreamFix.restoreComments(loopStatement, loopStatement.getBody());
        StreamApiMigrationInspection.InitializerUsageStatus status = StreamApiMigrationInspection.getInitializerUsageStatus(var, (PsiStatement)loopStatement);
        if (status != StreamApiMigrationInspection.InitializerUsageStatus.UNKNOWN && ExpressionUtils.isZero(initializer = var.getInitializer())) {
            PsiType type = var.getType();
            String replacement = (type.equals(expressionType) ? "" : "(" + type.getCanonicalText() + ") ") + builder;
            return MigrateToStreamFix.replaceInitializer(loopStatement, var, initializer, replacement, status);
        }
        return loopStatement.replace((PsiElement)elementFactory.createStatementFromText(var.getName() + "+=" + builder + ";", (PsiElement)loopStatement));
    }

    static PsiElement replaceInitializer(PsiLoopStatement loopStatement, PsiVariable var, PsiExpression initializer, String replacement, StreamApiMigrationInspection.InitializerUsageStatus status) {
        Project project2 = loopStatement.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        if (status == StreamApiMigrationInspection.InitializerUsageStatus.DECLARED_JUST_BEFORE) {
            initializer.replace((PsiElement)elementFactory.createExpressionFromText(replacement, (PsiElement)loopStatement));
            MigrateToStreamFix.removeLoop(loopStatement);
            return var;
        }
        if (status == StreamApiMigrationInspection.InitializerUsageStatus.AT_WANTED_PLACE_ONLY) {
            initializer.delete();
        }
        return loopStatement.replace((PsiElement)elementFactory.createStatementFromText(var.getName() + " = " + replacement + ";", (PsiElement)loopStatement));
    }

    static void simplifyAndFormat(@NotNull Project project2, PsiElement result2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/streamMigration/MigrateToStreamFix", "simplifyAndFormat"));
        }
        if (result2 == null) {
            return;
        }
        LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result2);
        CodeStyleManager.getInstance((Project)project2).reformat(JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(result2));
    }

    static void restoreComments(PsiLoopStatement loopStatement, PsiStatement body) {
        PsiElement parent = loopStatement.getParent();
        for (PsiElement comment : PsiTreeUtil.findChildrenOfType((PsiElement)body, PsiComment.class)) {
            parent.addBefore(comment, (PsiElement)loopStatement);
        }
    }

    @NotNull
    static StringBuilder generateStream(@NotNull StreamApiMigrationInspection.Operation lastOperation) {
        if (lastOperation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastOperation", "com/intellij/codeInspection/streamMigration/MigrateToStreamFix", "generateStream"));
        }
        StringBuilder stringBuilder = MigrateToStreamFix.generateStream(lastOperation, false);
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/MigrateToStreamFix", "generateStream"));
        }
        return stringBuilder;
    }

    @NotNull
    static StringBuilder generateStream(@NotNull StreamApiMigrationInspection.Operation lastOperation, boolean noStreamForEmpty) {
        if (lastOperation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastOperation", "com/intellij/codeInspection/streamMigration/MigrateToStreamFix", "generateStream"));
        }
        StringBuilder buffer = new StringBuilder();
        if (noStreamForEmpty && lastOperation instanceof StreamApiMigrationInspection.CollectionStream) {
            StringBuilder stringBuilder = buffer.append(lastOperation.getExpression().getText());
            if (stringBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/MigrateToStreamFix", "generateStream"));
            }
            return stringBuilder;
        }
        List replacements = StreamEx.iterate((Object)lastOperation, Objects::nonNull, StreamApiMigrationInspection.Operation::getPreviousOp).map(StreamApiMigrationInspection.Operation::createReplacement).toList();
        ListIterator it = replacements.listIterator(replacements.size());
        while (it.hasPrevious()) {
            buffer.append((String)it.previous());
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/MigrateToStreamFix", "generateStream"));
        }
        return stringBuilder;
    }

    static String getIteratedValueText(PsiExpression iteratedValue) {
        return iteratedValue instanceof PsiCallExpression || iteratedValue instanceof PsiReferenceExpression || iteratedValue instanceof PsiQualifiedExpression || iteratedValue instanceof PsiParenthesizedExpression ? iteratedValue.getText() : "(" + iteratedValue.getText() + ")";
    }

    static void removeLoop(@NotNull PsiLoopStatement statement2) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInspection/streamMigration/MigrateToStreamFix", "removeLoop"));
        }
        PsiElement parent = statement2.getParent();
        if (parent instanceof PsiLabeledStatement) {
            parent.delete();
        } else {
            statement2.delete();
        }
    }

    static boolean isReachable(PsiReturnStatement target) {
        ControlFlow flow;
        try {
            flow = ControlFlowFactory.getInstance(target.getProject()).getControlFlow(target.getParent(), LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        return ControlFlowUtil.isInstructionReachable(flow, flow.getStartOffset((PsiElement)target), 0);
    }
}

