/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;

public class FlushVariableInstruction
extends Instruction {
    private final DfaVariableValue myVariable;
    private final boolean myDependentsOnly;

    public FlushVariableInstruction(DfaVariableValue expr) {
        this(expr, false);
    }

    public FlushVariableInstruction(DfaVariableValue variable, boolean dependentsOnly) {
        this.myVariable = variable;
        this.myDependentsOnly = dependentsOnly;
    }

    public boolean isDependentsOnly() {
        return this.myDependentsOnly;
    }

    public DfaVariableValue getVariable() {
        return this.myVariable;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
        return visitor.visitFlushVariable(this, runner, stateBefore);
    }

    public String toString() {
        return "FLUSH " + (this.myVariable != null ? this.myVariable.toString() : " all fields");
    }
}

