/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import java.util.ArrayList;

public class DupInstruction
extends Instruction {
    private final int myValueCount;
    private final int myDuplicationCount;

    public DupInstruction() {
        this(1, 1);
    }

    public DupInstruction(int valueCount, int duplicationCount) {
        this.myValueCount = valueCount;
        this.myDuplicationCount = duplicationCount;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState memState, InstructionVisitor visitor) {
        if (this.myDuplicationCount == 1 && this.myValueCount == 1) {
            memState.push(memState.peek());
        } else {
            ArrayList<DfaValue> values = new ArrayList<DfaValue>(this.myValueCount);
            for (int i2 = 0; i2 < this.myValueCount; ++i2) {
                values.add(memState.pop());
            }
            for (int j = 0; j < this.myDuplicationCount + 1; ++j) {
                for (int i3 = values.size() - 1; i3 >= 0; --i3) {
                    memState.push((DfaValue)values.get(i3));
                }
            }
        }
        Instruction nextInstruction = runner.getInstruction(this.getIndex() + 1);
        return new DfaInstructionState[]{new DfaInstructionState(nextInstruction, memState)};
    }

    public String toString() {
        return "DUP(" + this.myValueCount + " top stack values, " + this.myDuplicationCount + " times)";
    }
}

