/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.jetbrains.annotations.Nullable;

public class WorkingTimeMeasurer {
    private final long myTimeLimit;
    private final long myStart;
    @Nullable
    private static final ThreadMXBean ourThreadMXBean;

    private static long getCurrentTime() {
        return ourThreadMXBean != null ? ourThreadMXBean.getCurrentThreadUserTime() : System.nanoTime();
    }

    public WorkingTimeMeasurer(long nanoLimit) {
        this.myTimeLimit = nanoLimit;
        this.myStart = WorkingTimeMeasurer.getCurrentTime();
    }

    public boolean isTimeOver() {
        return WorkingTimeMeasurer.getCurrentTime() - this.myStart > this.myTimeLimit;
    }

    static {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        ourThreadMXBean = bean.isCurrentThreadCpuTimeSupported() ? bean : null;
    }
}

