/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractInferenceInterpreter;
import com.intellij.codeInspection.dataFlow.KnownContract;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.PreContract;
import com.intellij.psi.PsiMethod;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NegatingContract
extends PreContract {
    private final PreContract myNegated;

    private NegatingContract(PreContract negated) {
        this.myNegated = negated;
    }

    @Override
    @NotNull
    List<MethodContract> toContracts(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/NegatingContract", "toContracts"));
        }
        List list = ContainerUtil.mapNotNull(this.myNegated.toContracts(method2), NegatingContract::negateContract);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/NegatingContract", "toContracts"));
        }
        return list;
    }

    @Nullable
    static PreContract negate(@NotNull PreContract contract) {
        if (contract == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contract", "com/intellij/codeInspection/dataFlow/NegatingContract", "negate"));
        }
        if (contract instanceof KnownContract) {
            MethodContract negated = NegatingContract.negateContract(((KnownContract)contract).getContract());
            return negated == null ? null : new KnownContract(negated);
        }
        return new NegatingContract(contract);
    }

    @Nullable
    private static MethodContract negateContract(MethodContract c) {
        MethodContract.ValueConstraint ret = c.returnValue;
        return ret == MethodContract.ValueConstraint.TRUE_VALUE || ret == MethodContract.ValueConstraint.FALSE_VALUE ? new MethodContract(c.arguments, ContractInferenceInterpreter.negateConstraint(ret)) : null;
    }
}

