/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.ContractInferenceInterpreter;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.PreContract;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class MethodCallContract
extends PreContract {
    private final PsiMethodCallExpression myCall;
    private final List<MethodContract.ValueConstraint[]> myStates;

    MethodCallContract(PsiMethodCallExpression call, List<MethodContract.ValueConstraint[]> states) {
        this.myCall = call;
        this.myStates = states;
    }

    @Override
    @NotNull
    List<MethodContract> toContracts(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/MethodCallContract", "toContracts"));
        }
        PsiMethod target = this.myCall.resolveMethod();
        if (target != null && NullableNotNullManager.isNotNull((PsiModifierListOwner)target)) {
            List<MethodContract> list = ContractInferenceInterpreter.toContracts(this.myStates, MethodContract.ValueConstraint.NOT_NULL_VALUE);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/MethodCallContract", "toContracts"));
            }
            return list;
        }
        List<MethodContract> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/MethodCallContract", "toContracts"));
        }
        return list;
    }
}

