/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.Subroutine;
import java.util.List;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;

abstract class SubroutineFinder
implements Opcodes {
    InsnList insns;
    List<TryCatchBlockNode>[] handlers;
    Subroutine[] subroutines;
    int n;

    SubroutineFinder() {
    }

    void findSubroutine(int insn, Subroutine sub, List<AbstractInsnNode> calls) throws AnalyzerException {
        while (true) {
            LabelNode l;
            int i2;
            if (insn < 0 || insn >= this.n) {
                throw new AnalyzerException(null, "Execution can fall off end of the code");
            }
            if (this.subroutines[insn] != null) {
                return;
            }
            this.subroutines[insn] = sub.copy();
            AbstractInsnNode node = this.insns.get(insn);
            if (node instanceof JumpInsnNode) {
                if (node.getOpcode() == 168) {
                    calls.add(node);
                } else {
                    JumpInsnNode jnode = (JumpInsnNode)node;
                    this.findSubroutine(this.insns.indexOf((AbstractInsnNode)jnode.label), sub, calls);
                }
            } else if (node instanceof TableSwitchInsnNode) {
                TableSwitchInsnNode tsnode = (TableSwitchInsnNode)node;
                this.findSubroutine(this.insns.indexOf((AbstractInsnNode)tsnode.dflt), sub, calls);
                for (i2 = tsnode.labels.size() - 1; i2 >= 0; --i2) {
                    l = (LabelNode)tsnode.labels.get(i2);
                    this.findSubroutine(this.insns.indexOf((AbstractInsnNode)l), sub, calls);
                }
            } else if (node instanceof LookupSwitchInsnNode) {
                LookupSwitchInsnNode lsnode = (LookupSwitchInsnNode)node;
                this.findSubroutine(this.insns.indexOf((AbstractInsnNode)lsnode.dflt), sub, calls);
                for (i2 = lsnode.labels.size() - 1; i2 >= 0; --i2) {
                    l = (LabelNode)lsnode.labels.get(i2);
                    this.findSubroutine(this.insns.indexOf((AbstractInsnNode)l), sub, calls);
                }
            }
            List<TryCatchBlockNode> insnHandlers = this.handlers[insn];
            if (insnHandlers != null) {
                for (i2 = 0; i2 < insnHandlers.size(); ++i2) {
                    TryCatchBlockNode tcb = insnHandlers.get(i2);
                    this.findSubroutine(this.insns.indexOf((AbstractInsnNode)tcb.handler), sub, calls);
                }
            }
            switch (node.getOpcode()) {
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
            }
            ++insn;
        }
    }
}

