/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.BaseAnalysisAction;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.profile.codeInspection.ui.header.InspectionToolsConfigurable;
import com.intellij.profile.codeInspection.ui.header.ProfilesComboBox;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CodeInspectionAction
extends BaseAnalysisAction {
    private GlobalInspectionContextImpl myGlobalInspectionContext;
    protected InspectionProfileImpl myExternalProfile;

    public CodeInspectionAction() {
        super(InspectionsBundle.message((String)"inspection.action.title", (Object[])new Object[0]), InspectionsBundle.message((String)"inspection.action.noun", (Object[])new Object[0]));
    }

    public CodeInspectionAction(String title, String analysisNoon) {
        super(title, analysisNoon);
    }

    @Override
    protected void analyze(@NotNull Project project2, @NotNull AnalysisScope scope) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/CodeInspectionAction", "analyze"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/actions/CodeInspectionAction", "analyze"));
        }
        try {
            this.runInspections(project2, scope);
        }
        finally {
            this.myGlobalInspectionContext = null;
            this.myExternalProfile = null;
        }
    }

    protected void runInspections(Project project2, AnalysisScope scope) {
        scope.setSearchInLibraries(false);
        FileDocumentManager.getInstance().saveAllDocuments();
        GlobalInspectionContextImpl inspectionContext = this.getGlobalInspectionContext(project2);
        inspectionContext.setExternalProfile(this.myExternalProfile);
        inspectionContext.setCurrentScope(scope);
        inspectionContext.doInspections(scope);
    }

    private GlobalInspectionContextImpl getGlobalInspectionContext(Project project2) {
        if (this.myGlobalInspectionContext == null) {
            this.myGlobalInspectionContext = ((InspectionManagerEx)InspectionManager.getInstance((Project)project2)).createNewGlobalContext(false);
        }
        return this.myGlobalInspectionContext;
    }

    @Override
    @NonNls
    protected String getHelpTopic() {
        return "reference.dialogs.inspection.scope";
    }

    @Override
    protected void canceled() {
        super.canceled();
        this.myGlobalInspectionContext = null;
    }

    @Override
    protected JComponent getAdditionalActionSettings(final @NotNull Project project2, final BaseAnalysisActionDialog dialog2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/CodeInspectionAction", "getAdditionalActionSettings"));
        }
        AdditionalPanel panel2 = new AdditionalPanel();
        final InspectionManagerEx manager = (InspectionManagerEx)InspectionManager.getInstance((Project)project2);
        final ProfilesComboBox profiles = (ProfilesComboBox)((Object)panel2.myBrowseProfilesCombo.getComboBox());
        final InspectionProfileManager profileManager = InspectionProfileManager.getInstance();
        final ProjectInspectionProfileManager projectProfileManager = ProjectInspectionProfileManager.getInstanceImpl(project2);
        this.reloadProfiles(profiles, profileManager, projectProfileManager, manager);
        panel2.myBrowseProfilesCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InspectionToolsConfigurable errorConfigurable = CodeInspectionAction.this.createConfigurable(projectProfileManager, profileManager, profiles);
                MySingleConfigurableEditor editor = new MySingleConfigurableEditor(project2, errorConfigurable, manager);
                if (editor.showAndGet()) {
                    CodeInspectionAction.this.reloadProfiles(profiles, profileManager, projectProfileManager, manager);
                } else {
                    InspectionProfile profile = (InspectionProfile)profiles.getSelectedItem();
                    boolean canExecute = profile != null && profile.isExecutable(project2);
                    dialog2.setOKActionEnabled(canExecute);
                }
            }
        });
        profiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeInspectionAction.this.myExternalProfile = (InspectionProfileImpl)profiles.getSelectedItem();
                boolean canExecute = CodeInspectionAction.this.myExternalProfile != null && CodeInspectionAction.this.myExternalProfile.isExecutable(project2);
                dialog2.setOKActionEnabled(canExecute);
                if (canExecute) {
                    manager.setProfile(CodeInspectionAction.this.myExternalProfile.getName());
                }
            }
        });
        InspectionProfile profile = (InspectionProfile)profiles.getSelectedItem();
        dialog2.setOKActionEnabled(profile != null && profile.isExecutable(project2));
        return panel2.myAdditionalPanel;
    }

    protected InspectionToolsConfigurable createConfigurable(ProjectInspectionProfileManager projectProfileManager, InspectionProfileManager profileManager, ProfilesComboBox profilesCombo) {
        return new ExternalProfilesComboboxAwareInspectionToolsConfigurable(projectProfileManager, profilesCombo);
    }

    private void reloadProfiles(ProfilesComboBox profilesCombo, InspectionProfileManager inspectionProfileManager, InspectionProjectProfileManager inspectionProjectProfileManager, InspectionManagerEx inspectionManager) {
        InspectionProfileImpl selectedProfile = this.getGlobalInspectionContext(inspectionManager.getProject()).getCurrentProfile();
        ArrayList<InspectionProfileImpl> profiles = new ArrayList<InspectionProfileImpl>();
        profiles.addAll(inspectionProfileManager.getProfiles());
        profiles.addAll(inspectionProjectProfileManager.getProfiles());
        profilesCombo.reset(profiles);
        profilesCombo.selectProfile(selectedProfile);
    }

    private static class MySingleConfigurableEditor
    extends SingleConfigurableEditor {
        private final InspectionManagerEx myManager;

        public MySingleConfigurableEditor(Project project2, ErrorsConfigurable configurable, InspectionManagerEx manager) {
            super(project2, (Configurable)configurable, MySingleConfigurableEditor.createDimensionKey(configurable));
            this.myManager = manager;
        }

        @Override
        protected void doOKAction() {
            Object o = ((ErrorsConfigurable)this.getConfigurable()).getSelectedObject();
            if (o instanceof InspectionProfile) {
                this.myManager.setProfile(((InspectionProfile)o).getName());
            }
            super.doOKAction();
        }
    }

    private static class AdditionalPanel {
        public ComboboxWithBrowseButton myBrowseProfilesCombo;
        public JPanel myAdditionalPanel;

        private AdditionalPanel() {
            this.$$$setupUI$$$();
        }

        private void createUIComponents() {
            this.myBrowseProfilesCombo = new ComboboxWithBrowseButton((JComboBox)((Object)new ProfilesComboBox(){

                @Override
                protected void onProfileChosen(InspectionProfileImpl inspectionProfile) {
                }
            }));
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            this.createUIComponents();
            this.myAdditionalPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
            jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.action.profile.label"), (int)0, (int)0, null, null));
            ComboboxWithBrowseButton comboboxWithBrowseButton = this.myBrowseProfilesCombo;
            jPanel2.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
            ButtonGroup buttonGroup2 = new ButtonGroup();
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myAdditionalPanel;
        }
    }

    protected static class ExternalProfilesComboboxAwareInspectionToolsConfigurable
    extends InspectionToolsConfigurable {
        private final ProfilesComboBox myProfilesCombo;

        public ExternalProfilesComboboxAwareInspectionToolsConfigurable(@NotNull ProjectInspectionProfileManager projectProfileManager, ProfilesComboBox profilesCombo) {
            if (projectProfileManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectProfileManager", "com/intellij/codeInspection/actions/CodeInspectionAction$ExternalProfilesComboboxAwareInspectionToolsConfigurable", "<init>"));
            }
            super(projectProfileManager);
            this.myProfilesCombo = profilesCombo;
        }

        @Override
        protected InspectionProfileImpl getCurrentProfile() {
            return (InspectionProfileImpl)this.myProfilesCombo.getSelectedItem();
        }

        @Override
        protected void addProfile(InspectionProfileImpl model) {
            super.addProfile(model);
            this.myProfilesCombo.addProfile(model.getParentProfile());
        }

        @Override
        protected void applyRootProfile(@NotNull String name, boolean isProjectLevel) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/actions/CodeInspectionAction$ExternalProfilesComboboxAwareInspectionToolsConfigurable", "applyRootProfile"));
            }
            for (int i2 = 0; i2 < this.myProfilesCombo.getItemCount(); ++i2) {
                InspectionProfileImpl profile = (InspectionProfileImpl)this.myProfilesCombo.getItemAt(i2);
                if (!name.equals(profile.getName())) continue;
                this.myProfilesCombo.setSelectedIndex(i2);
                break;
            }
        }
    }
}

