/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;

public class ShortenFQNamesProcessor
implements TemplateOptionalProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.template.impl.ShortenFQNamesProcessor");

    @Override
    public void processText(Project project2, Template template, Document document, RangeMarker templateRange, Editor editor) {
        if (!template.isToShortenLongNames()) {
            return;
        }
        try {
            PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
            JavaCodeStyleManager javaStyle = JavaCodeStyleManager.getInstance((Project)project2);
            PsiFile file2 = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project2);
            assert (file2 != null);
            javaStyle.shortenClassReferences((PsiElement)file2, templateRange.getStartOffset(), templateRange.getEndOffset());
            PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(document);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public String getOptionName() {
        return CodeInsightBundle.message((String)"dialog.edit.template.checkbox.shorten.fq.names", (Object[])new Object[0]);
    }

    @Override
    public boolean isEnabled(Template template) {
        return template.isToShortenLongNames();
    }

    @Override
    public void setEnabled(Template template, boolean value) {
        template.setToShortenLongNames(value);
    }
}

