/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.actions;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.LiveTemplatesConfigurable;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Set;

public class SaveAsTemplateAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + SaveAsTemplateAction.class.getName()));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent e) {
        PsiFile copy;
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        Project project2 = file2.getProject();
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        final TextRange selection = new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
        PsiElement current = file2.findElementAt(selection.getStartOffset());
        int startOffset = selection.getStartOffset();
        while (current instanceof PsiWhiteSpace && (current = current.getNextSibling()) != null) {
            startOffset = current.getTextRange().getStartOffset();
        }
        if (startOffset >= selection.getEndOffset()) {
            startOffset = selection.getStartOffset();
        }
        final PsiElement[] psiElements = PsiTreeUtil.collectElements((PsiElement)file2, (PsiElementFilter)new PsiElementFilter(){

            public boolean isAccepted(PsiElement element) {
                return selection.contains(element.getTextRange()) && element.getReferences().length > 0;
            }
        });
        final Document document = EditorFactory.getInstance().createDocument((CharSequence)editor.getDocument().getText().substring(startOffset, selection.getEndOffset()));
        final boolean isXml = file2.getLanguage().is(StdLanguages.XML);
        final int offsetDelta = startOffset;
        new WriteCommandAction.Simple(project2, null, new PsiFile[0]){

            protected void run() throws Throwable {
                HashMap rangeToText = new HashMap();
                for (PsiElement element : psiElements) {
                    for (PsiReference reference : element.getReferences()) {
                        if (reference instanceof PsiQualifiedReference && ((PsiQualifiedReference)reference).getQualifier() != null) continue;
                        String canonicalText = reference.getCanonicalText();
                        TextRange referenceRange = reference.getRangeInElement();
                        TextRange elementTextRange = element.getTextRange();
                        LOG.assertTrue(elementTextRange != null, (Object)elementTextRange);
                        TextRange range = elementTextRange.cutOut(referenceRange).shiftRight(-offsetDelta);
                        String oldText = document.getText(range);
                        int pos = canonicalText.indexOf(60);
                        if (pos > 0 && !oldText.contains("<")) {
                            canonicalText = canonicalText.substring(0, pos);
                        }
                        if (isXml && (pos = canonicalText.lastIndexOf(58)) >= 0 && pos < canonicalText.length() - 1 && !oldText.contains(":")) {
                            canonicalText = canonicalText.substring(pos + 1);
                        }
                        if (canonicalText.equals(oldText)) continue;
                        rangeToText.put(document.createRangeMarker(range), canonicalText);
                    }
                }
                ArrayList<RangeMarker> markers = new ArrayList<RangeMarker>();
                for (RangeMarker m1 : rangeToText.keySet()) {
                    boolean nested = false;
                    for (RangeMarker m2 : rangeToText.keySet()) {
                        if (m1 == m2 || m2.getStartOffset() > m1.getStartOffset() || m1.getEndOffset() > m2.getEndOffset()) continue;
                        nested = true;
                        break;
                    }
                    if (nested) continue;
                    markers.add(m1);
                }
                for (RangeMarker marker : markers) {
                    String value = (String)rangeToText.get(marker);
                    document.replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)value);
                }
            }
        }.execute();
        TemplateImpl template = new TemplateImpl("<abbreviation>", document.getText(), "user");
        template.setToReformat(true);
        AccessToken token = WriteAction.start();
        try {
            copy = TemplateManagerImpl.insertDummyIdentifier(editor, file2);
        }
        finally {
            token.finish();
        }
        Set<TemplateContextType> applicable = TemplateManagerImpl.getApplicableContextTypes(copy, startOffset);
        for (TemplateContextType contextType : TemplateManagerImpl.getAllContextTypes()) {
            template.getTemplateContext().setEnabled(contextType, applicable.contains(contextType));
        }
        LiveTemplatesConfigurable configurable = new LiveTemplatesConfigurable();
        ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)configurable, () -> configurable.getTemplateListPanel().addTemplate(template));
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file2 == null || editor == null) {
            e.getPresentation().setEnabled(false);
        } else {
            e.getPresentation().setEnabled(editor.getSelectionModel().hasSelection());
        }
    }
}

