/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.io.IOUtil;
import com.intellij.xml.util.XmlUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToBasicLatinAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.ConvertToBasicLatinAction");
    private static final Handler[] ourHandlers = new Handler[]{new MyLiteralHandler(), new MyDocCommentHandler(), new MyCommentHandler()};

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ConvertToBasicLatinAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ConvertToBasicLatinAction", "isAvailable"));
        }
        if (!element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return false;
        }
        Pair<PsiElement, Handler> pair = ConvertToBasicLatinAction.findHandler(element);
        if (pair == null) {
            return false;
        }
        String text = ((PsiElement)pair.first).getText();
        return !IOUtil.isAscii((String)text);
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.convert.to.basic.latin", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ConvertToBasicLatinAction", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ConvertToBasicLatinAction", "getText"));
        }
        return string;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ConvertToBasicLatinAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ConvertToBasicLatinAction", "invoke"));
        }
        Pair<PsiElement, Handler> pair = ConvertToBasicLatinAction.findHandler(element);
        if (pair == null) {
            return;
        }
        PsiElement workElement = (PsiElement)pair.first;
        Handler handler2 = (Handler)pair.second;
        if (!FileModificationService.getInstance().preparePsiElementForWrite(workElement)) {
            return;
        }
        String newText = handler2.processText(workElement);
        PsiElement newElement = handler2.createReplacement(workElement, newText);
        workElement.replace(newElement);
    }

    @Nullable
    private static Pair<PsiElement, Handler> findHandler(PsiElement element) {
        for (Handler handler2 : ourHandlers) {
            PsiElement applicable = handler2.findApplicable(element);
            if (applicable == null) continue;
            return Pair.create((Object)applicable, (Object)handler2);
        }
        return null;
    }

    private static boolean shouldConvert(char ch) {
        return Character.UnicodeBlock.of(ch) != Character.UnicodeBlock.BASIC_LATIN;
    }

    private static class MyCommentHandler
    extends MyDocCommentHandler {
        private MyCommentHandler() {
        }

        @Override
        public PsiElement findApplicable(PsiElement element) {
            return element instanceof PsiComment ? element : null;
        }

        @Override
        public PsiElement createReplacement(PsiElement element, String newText) {
            return JavaPsiFacade.getElementFactory((Project)element.getProject()).createCommentFromText(newText, element.getParent());
        }
    }

    private static class MyDocCommentHandler
    extends Handler {
        private static Map<Character, String> ourEntities;

        private MyDocCommentHandler() {
        }

        @Override
        public PsiElement findApplicable(PsiElement element) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocComment.class, (boolean)false);
        }

        @Override
        public String processText(PsiElement element) {
            MyDocCommentHandler.loadEntities(element.getProject());
            return super.processText(element);
        }

        @Override
        protected void convert(StringBuilder sb, char ch) {
            assert (ourEntities != null);
            String entity = ourEntities.get(Character.valueOf(ch));
            if (entity != null) {
                sb.append('&').append(entity).append(';');
            } else {
                sb.append("&#x").append(Integer.toHexString(ch)).append(';');
            }
        }

        @Override
        public PsiElement createReplacement(PsiElement element, String newText) {
            return JavaPsiFacade.getElementFactory((Project)element.getProject()).createDocCommentFromText(newText);
        }

        private static void loadEntities(Project project2) {
            XmlFile file2;
            if (ourEntities != null) {
                return;
            }
            try {
                String url = ExternalResourceManager.getInstance().getResourceLocation("http://www.w3.org/TR/html4/loose.dtd", project2);
                if (url == null) {
                    LOG.error("Namespace not found: http://www.w3.org/TR/html4/loose.dtd");
                    return;
                }
                VirtualFile vFile = VfsUtil.findFileByURL((URL)new URL(url));
                if (vFile == null) {
                    LOG.error("Resource not found: " + url);
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(vFile);
                if (!(psiFile instanceof XmlFile)) {
                    LOG.error("Unexpected resource: " + psiFile);
                    return;
                }
                file2 = (XmlFile)psiFile;
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
                return;
            }
            ourEntities = new HashMap<Character, String>();
            final Pattern pattern = Pattern.compile("&#(\\d+);");
            XmlUtil.processXmlElements((XmlElement)file2, new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    char i2;
                    XmlEntityDecl entity;
                    Matcher m;
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ConvertToBasicLatinAction$MyDocCommentHandler$1", "execute"));
                    }
                    if (element instanceof XmlEntityDecl && (m = pattern.matcher((entity = (XmlEntityDecl)element).getValueElement().getValue())).matches() && ConvertToBasicLatinAction.shouldConvert(i2 = (char)Integer.parseInt(m.group(1)))) {
                        ourEntities.put(Character.valueOf(i2), entity.getName());
                    }
                    return true;
                }
            }, true);
        }
    }

    private static class MyLiteralHandler
    extends Handler {
        private static final TokenSet LITERALS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.CHARACTER_LITERAL, JavaTokenType.STRING_LITERAL});

        private MyLiteralHandler() {
        }

        @Override
        public PsiElement findApplicable(PsiElement element) {
            PsiElement parent = element.getParent();
            return element instanceof PsiJavaToken && LITERALS.contains(((PsiJavaToken)element).getTokenType()) && parent instanceof PsiLiteralExpression ? parent : null;
        }

        @Override
        public PsiElement createReplacement(PsiElement element, String newText) {
            return JavaPsiFacade.getElementFactory((Project)element.getProject()).createExpressionFromText(newText, element.getParent());
        }

        @Override
        protected void convert(StringBuilder sb, char ch) {
            sb.append(String.format("\\u%04x", ch));
        }
    }

    private static abstract class Handler {
        private Handler() {
        }

        @Nullable
        public abstract PsiElement findApplicable(PsiElement var1);

        public String processText(PsiElement element) {
            String text = element.getText();
            StringBuilder sb = new StringBuilder();
            for (int i2 = 0; i2 < text.length(); ++i2) {
                char ch = text.charAt(i2);
                if (!ConvertToBasicLatinAction.shouldConvert(ch)) {
                    sb.append(ch);
                    continue;
                }
                this.convert(sb, ch);
            }
            return sb.toString();
        }

        protected abstract void convert(StringBuilder var1, char var2);

        public abstract PsiElement createReplacement(PsiElement var1, String var2);
    }
}

