/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.FieldFromParameterUtils;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignFieldFromParameterAction
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(AssignFieldFromParameterAction.class);

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiClass targetClass;
        PsiType type;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/AssignFieldFromParameterAction", "isAvailable"));
        }
        PsiParameter myParameter = FieldFromParameterUtils.findParameterAtCursor(file2, editor);
        if (!FieldFromParameterUtils.isAvailable(myParameter, type = FieldFromParameterUtils.getType(myParameter), targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)myParameter, PsiClass.class))) {
            return false;
        }
        PsiField field = AssignFieldFromParameterAction.findFieldToAssign(project2, myParameter);
        if (field == null) {
            return false;
        }
        if (!field.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return false;
        }
        this.setText(CodeInsightBundle.message((String)"intention.assign.field.from.parameter.text", (Object[])new Object[]{field.getName()}));
        return true;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.assign.field.from.parameter.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/AssignFieldFromParameterAction", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/AssignFieldFromParameterAction", "invoke"));
        }
        PsiParameter myParameter = FieldFromParameterUtils.findParameterAtCursor(file2, editor);
        if (!FileModificationService.getInstance().prepareFileForWrite(myParameter.getContainingFile())) {
            return;
        }
        IdeDocumentHistory.getInstance(project2).includeCurrentPlaceAsChangePlace();
        try {
            PsiField field = AssignFieldFromParameterAction.findFieldToAssign(project2, myParameter);
            if (field != null) {
                AssignFieldFromParameterAction.addFieldAssignmentStatement(project2, field, myParameter, editor);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    private static PsiField findFieldToAssign(@NotNull Project project2, @NotNull PsiParameter myParameter) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/AssignFieldFromParameterAction", "findFieldToAssign"));
        }
        if (myParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myParameter", "com/intellij/codeInsight/intention/impl/AssignFieldFromParameterAction", "findFieldToAssign"));
        }
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project2);
        String parameterName = myParameter.getName();
        String propertyName = styleManager.variableNameToPropertyName(parameterName, VariableKind.PARAMETER);
        PsiMethod method2 = (PsiMethod)myParameter.getDeclarationScope();
        boolean isMethodStatic = method2.hasModifierProperty("static");
        VariableKind kind = isMethodStatic ? VariableKind.STATIC_FIELD : VariableKind.FIELD;
        SuggestedNameInfo suggestedNameInfo = styleManager.suggestVariableName(kind, propertyName, null, FieldFromParameterUtils.getSubstitutedType(myParameter));
        String fieldName = suggestedNameInfo.names[0];
        PsiClass aClass = method2.getContainingClass();
        if (aClass == null) {
            return null;
        }
        PsiField field = aClass.findFieldByName(fieldName, false);
        if (field == null) {
            return null;
        }
        if (!field.hasModifierProperty("static") && isMethodStatic) {
            return null;
        }
        return field;
    }

    public static PsiElement addFieldAssignmentStatement(@NotNull Project project2, @NotNull PsiField field, @NotNull PsiParameter parameter, @NotNull Editor editor) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/AssignFieldFromParameterAction", "addFieldAssignmentStatement"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/intention/impl/AssignFieldFromParameterAction", "addFieldAssignmentStatement"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/intention/impl/AssignFieldFromParameterAction", "addFieldAssignmentStatement"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/intention/impl/AssignFieldFromParameterAction", "addFieldAssignmentStatement"));
        }
        PsiMethod method2 = (PsiMethod)parameter.getDeclarationScope();
        PsiCodeBlock methodBody = method2.getBody();
        if (methodBody == null) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        String fieldName = field.getName();
        String parameterName = parameter.getName();
        boolean isMethodStatic = method2.hasModifierProperty("static");
        PsiClass targetClass = method2.getContainingClass();
        if (targetClass == null) {
            return null;
        }
        String stmtText = fieldName + " = " + parameterName + ";";
        if (Comparing.strEqual((String)fieldName, (String)parameterName) || JavaPsiFacade.getInstance((Project)project2).getResolveHelper().resolveReferencedVariable(fieldName, (PsiElement)methodBody) != field) {
            String prefix = isMethodStatic ? (targetClass.getName() == null ? "" : targetClass.getName() + ".") : "this.";
            stmtText = prefix + stmtText;
        }
        PsiStatement assignmentStmt = (PsiStatement)CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)factory.createStatementFromText(stmtText, (PsiElement)methodBody));
        PsiStatement[] statements = methodBody.getStatements();
        int i2 = FieldFromParameterUtils.findFieldAssignmentAnchor(statements, null, targetClass, parameter);
        PsiElement inserted = i2 == statements.length ? methodBody.add((PsiElement)assignmentStmt) : methodBody.addAfter((PsiElement)assignmentStmt, i2 > 0 ? statements[i2 - 1] : null);
        editor.getCaretModel().moveToOffset(inserted.getTextRange().getEndOffset());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        return inserted;
    }
}

