/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.highlighting.TooltipLinkHandler;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class InspectionDescriptionLinkHandler
extends TooltipLinkHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.hint.InspectionDescriptionLinkHandler");

    public String getDescription(@NotNull String refSuffix, @NotNull Editor editor) {
        if (refSuffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refSuffix", "com/intellij/codeInsight/hint/InspectionDescriptionLinkHandler", "getDescription"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/InspectionDescriptionLinkHandler", "getDescription"));
        }
        Project project2 = editor.getProject();
        if (project2 == null) {
            LOG.error((Object)editor);
            return null;
        }
        if (project2.isDisposed()) {
            return null;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return null;
        }
        InspectionProfileImpl profile = InspectionProfileManager.getInstance().getCurrentProfile();
        InspectionToolWrapper toolWrapper = profile.getInspectionTool(refSuffix, (PsiElement)file2);
        if (toolWrapper == null) {
            return null;
        }
        String description = toolWrapper.loadDescription();
        if (description == null) {
            LOG.warn("No description for inspection '" + refSuffix + "'");
            description = InspectionsBundle.message((String)"inspection.tool.description.under.construction.text", (Object[])new Object[0]);
        }
        return description;
    }
}

