/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.XmlGtTypedHandler;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;

public class XmlAutoPopupHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, Project project2, Editor editor, PsiFile file2) {
        boolean spaceInTag;
        boolean isXmlLikeFile = XmlGtTypedHandler.fileContainsXmlLanguage(file2);
        boolean bl = spaceInTag = isXmlLikeFile && charTyped == ' ';
        if (spaceInTag) {
            PsiElement parent;
            spaceInTag = false;
            PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
            if (at != null && (parent = at.getParent()) instanceof XmlTag) {
                spaceInTag = true;
            }
        }
        if ((charTyped == '<' || charTyped == '{' || charTyped == '/' || spaceInTag) && isXmlLikeFile) {
            XmlAutoPopupHandler.autoPopupXmlLookup(project2, editor);
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    public static void autoPopupXmlLookup(Project project2, Editor editor) {
        AutoPopupController.getInstance(project2).autoPopupMemberLookup(editor, (Condition<PsiFile>)((Condition)file2 -> {
            Language templateDataLanguage;
            int offset = editor.getCaretModel().getOffset();
            PsiElement lastElement = InjectedLanguageUtil.findElementAtNoCommit(file2, offset - 1);
            if (lastElement instanceof PsiFile) {
                lastElement = file2.findElementAt(offset - 1);
            }
            if (lastElement == null || !lastElement.isValid()) {
                return false;
            }
            if (XmlAutoPopupHandler.doCompleteIfNeeded(offset, file2, lastElement)) {
                return true;
            }
            FileViewProvider fileViewProvider = file2.getViewProvider();
            PsiElement parent = lastElement.getParent();
            if (fileViewProvider instanceof TemplateLanguageFileViewProvider && (templateDataLanguage = ((TemplateLanguageFileViewProvider)fileViewProvider).getTemplateDataLanguage()) != parent.getLanguage()) {
                lastElement = fileViewProvider.findElementAt(offset - 1, templateDataLanguage);
                if (lastElement == null || !lastElement.isValid()) {
                    return false;
                }
                return XmlAutoPopupHandler.doCompleteIfNeeded(offset, file2, lastElement);
            }
            return false;
        }));
    }

    private static boolean doCompleteIfNeeded(int offset, PsiFile file2, PsiElement lastElement) {
        Ref isRelevantLanguage = new Ref();
        Ref isAnt = new Ref();
        String text = lastElement.getText();
        int len = offset - lastElement.getTextRange().getStartOffset();
        if (len < text.length()) {
            text = text.substring(0, len);
        }
        return text.equals("<") && XmlAutoPopupHandler.isLanguageRelevant(lastElement, file2, (Ref<Boolean>)isRelevantLanguage, (Ref<Boolean>)isAnt) || text.equals(" ") && XmlAutoPopupHandler.isLanguageRelevant(lastElement, file2, (Ref<Boolean>)isRelevantLanguage, (Ref<Boolean>)isAnt) || text.endsWith("${") && XmlAutoPopupHandler.isLanguageRelevant(lastElement, file2, (Ref<Boolean>)isRelevantLanguage, (Ref<Boolean>)isAnt) && (Boolean)isAnt.get() != false || text.endsWith("@{") && XmlAutoPopupHandler.isLanguageRelevant(lastElement, file2, (Ref<Boolean>)isRelevantLanguage, (Ref<Boolean>)isAnt) && (Boolean)isAnt.get() != false || text.endsWith("</") && XmlAutoPopupHandler.isLanguageRelevant(lastElement, file2, (Ref<Boolean>)isRelevantLanguage, (Ref<Boolean>)isAnt);
    }

    private static boolean isLanguageRelevant(PsiElement element, PsiFile file2, Ref<Boolean> isRelevantLanguage, Ref<Boolean> isAnt) {
        Boolean result2;
        Boolean isAntFile = (Boolean)isAnt.get();
        if (isAntFile == null) {
            isAntFile = XmlUtil.isAntFile(file2);
            isAnt.set((Object)isAntFile);
        }
        if ((result2 = (Boolean)isRelevantLanguage.get()) == null) {
            Language language = element.getLanguage();
            PsiElement parent = element.getParent();
            if (element instanceof PsiWhiteSpace && parent != null) {
                language = parent.getLanguage();
            }
            result2 = language instanceof XMLLanguage || HtmlUtil.supportsXmlTypedHandlers(file2) || isAntFile != false;
            isRelevantLanguage.set((Object)result2);
        }
        return result2;
    }
}

