/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyThisOrSuperArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class QualifyThisArgumentFix
extends QualifyThisOrSuperArgumentFix {
    public QualifyThisArgumentFix(@NotNull PsiExpression expression, @NotNull PsiClass psiClass) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/quickfix/QualifyThisArgumentFix", "<init>"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/daemon/impl/quickfix/QualifyThisArgumentFix", "<init>"));
        }
        super(expression, psiClass);
    }

    @Override
    protected String getQualifierText() {
        return "this";
    }

    @Override
    protected PsiExpression getQualifier(PsiManager manager) {
        return RefactoringChangeUtil.createThisExpression(manager, this.myPsiClass);
    }

    public static void registerQuickFixAction(CandidateInfo[] candidates, PsiCall call, HighlightInfo highlightInfo, TextRange fixRange) {
        if (candidates.length == 0) {
            return;
        }
        HashSet<PsiClass> containingClasses = new HashSet<PsiClass>();
        PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)call, PsiClass.class);
        while (parentClass != null && !parentClass.hasModifierProperty("static")) {
            if (!(parentClass instanceof PsiAnonymousClass)) {
                containingClasses.add(parentClass);
            }
            parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parentClass, PsiClass.class, (boolean)true);
        }
        if (containingClasses.isEmpty()) {
            return;
        }
        PsiExpressionList list = call.getArgumentList();
        PsiExpression[] expressions = list.getExpressions();
        if (expressions.length == 0) {
            return;
        }
        int expressionsLength = expressions.length;
        for (int i1 = 0; i1 < expressionsLength; ++i1) {
            PsiExpression expression = expressions[i1];
            if (!(expression instanceof PsiThisExpression)) continue;
            PsiType exprType = expression.getType();
            for (CandidateInfo candidate : candidates) {
                PsiClass psiClass;
                PsiMethod method2 = (PsiMethod)candidate.getElement();
                PsiSubstitutor substitutor = candidate.getSubstitutor();
                PsiParameter[] parameters = method2.getParameterList().getParameters();
                if (expressions.length != parameters.length) continue;
                PsiParameter parameter = parameters[i1];
                PsiType parameterType = substitutor.substitute(parameter.getType());
                if (exprType == null || parameterType == null || TypeConversionUtil.isAssignable((PsiType)parameterType, (PsiType)exprType) || (psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)parameterType)) == null || !containingClasses.contains(psiClass)) continue;
                QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, new QualifyThisArgumentFix((PsiExpression)((PsiThisExpression)expression), psiClass));
            }
        }
    }
}

