/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PackageUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class MoveClassToModuleFix
implements IntentionAction {
    private final Map<PsiClass, Module> myModules = new LinkedHashMap<PsiClass, Module>();
    private final String myReferenceName;
    private final Module myCurrentModule;
    private final PsiDirectory mySourceRoot;
    private static final Logger LOG = Logger.getInstance((String)("#" + MoveClassToModuleFix.class.getName()));

    public MoveClassToModuleFix(String referenceName, Module currentModule, PsiDirectory root, PsiElement psiElement) {
        this.myReferenceName = referenceName;
        this.myCurrentModule = currentModule;
        this.mySourceRoot = root;
        Project project2 = psiElement.getProject();
        PsiClass[] classes = PsiShortNamesCache.getInstance((Project)project2).getClassesByName(referenceName, GlobalSearchScope.allScope((Project)project2));
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        for (PsiClass aClass : classes) {
            Module classModule;
            VirtualFile virtualFile;
            PsiFile psiFile;
            if (!facade.getResolveHelper().isAccessible((PsiMember)aClass, psiElement, aClass) || !((psiFile = aClass.getContainingFile()) instanceof PsiJavaFile) || aClass.getQualifiedName() == null || (virtualFile = psiFile.getVirtualFile()) == null || (classModule = fileIndex.getModuleForFile(virtualFile)) == null || classModule == currentModule || ModuleRootManager.getInstance((Module)currentModule).isDependsOn(classModule)) continue;
            this.myModules.put(aClass, classModule);
        }
    }

    @NotNull
    public String getText() {
        if (this.myModules.size() == 1) {
            PsiClass aClass = this.myModules.keySet().iterator().next();
            String string = "Move '" + aClass.getQualifiedName() + "' from module '" + this.myModules.get(aClass).getName() + "' to '" + this.myCurrentModule.getName() + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToModuleFix", "getText"));
            }
            return string;
        }
        String string = "Move '" + this.myReferenceName + "' in '" + this.myCurrentModule.getName() + "'...";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToModuleFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("move it" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToModuleFix", "getFamilyName"));
        }
        return "move it";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToModuleFix", "isAvailable"));
        }
        return !this.myModules.isEmpty();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToModuleFix", "invoke"));
        }
        if (this.myModules.size() == 1) {
            this.moveClass(project2, editor, file2, this.myModules.keySet().iterator().next());
        } else {
            LOG.assertTrue(editor != null);
            JBList list = new JBList(this.myModules.keySet());
            list.setCellRenderer((ListCellRenderer)new PsiElementListCellRenderer<PsiClass>(){

                @Override
                public String getElementText(PsiClass psiClass) {
                    return psiClass.getQualifiedName();
                }

                @Override
                @Nullable
                protected String getContainerText(PsiClass element, String name) {
                    return null;
                }

                @Override
                protected int getIconFlags() {
                    return 0;
                }
            });
            JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose Class to Move").setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToModuleFix", "lambda$invoke$0"));
                }
                Object value = list.getSelectedValue();
                if (value instanceof PsiClass) {
                    this.moveClass(project2, editor, file2, (PsiClass)value);
                }
            }).createPopup().showInBestPositionFor(editor);
        }
    }

    private void moveClass(Project project2, Editor editor, PsiFile file2, PsiClass aClass) {
        RefactoringActionHandler moveHandler = RefactoringActionHandlerFactory.getInstance().createMoveHandler();
        DataManager dataManager = DataManager.getInstance();
        DataContext dataContext = dataManager.getDataContext();
        String fqName = aClass.getQualifiedName();
        LOG.assertTrue(fqName != null);
        PsiDirectory directory = PackageUtil.findOrCreateDirectoryForPackage(this.myCurrentModule, StringUtil.getPackageName((String)fqName), this.mySourceRoot, true);
        DataContext context = SimpleDataContext.getSimpleContext(LangDataKeys.TARGET_PSI_ELEMENT.getName(), directory, dataContext);
        moveHandler.invoke(project2, new PsiElement[]{aClass}, context);
        PsiReference reference = file2.findReferenceAt(editor.getCaretModel().getOffset());
        PsiClass newClass = JavaPsiFacade.getInstance((Project)project2).findClass(fqName, GlobalSearchScope.moduleScope((Module)this.myCurrentModule));
        if (reference != null && newClass != null) {
            AddImportAction action = new AddImportAction(project2, reference, editor, newClass);
            action.execute();
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void registerFixes(QuickFixActionRegistrar registrar, PsiJavaCodeReferenceElement reference) {
        PsiElement psiElement = reference.getElement();
        String referenceName = reference.getRangeInElement().substring(psiElement.getText());
        Project project2 = psiElement.getProject();
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return;
        }
        PsiDirectory dir = containingFile.getContainingDirectory();
        if (dir == null) {
            return;
        }
        VirtualFile classVFile = containingFile.getVirtualFile();
        if (classVFile == null) {
            return;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        Module currentModule = fileIndex.getModuleForFile(classVFile);
        if (currentModule == null) {
            return;
        }
        List sourceRoots = ModuleRootManager.getInstance((Module)currentModule).getSourceRoots(JavaModuleSourceRootTypes.SOURCES);
        if (sourceRoots.isEmpty()) {
            return;
        }
        PsiDirectory sourceDirectory = PsiManager.getInstance((Project)project2).findDirectory((VirtualFile)sourceRoots.get(0));
        if (sourceDirectory == null) {
            return;
        }
        VirtualFile vsourceRoot = fileIndex.getSourceRootForFile(classVFile);
        if (vsourceRoot == null) {
            return;
        }
        PsiDirectory sourceRoot = PsiManager.getInstance((Project)project2).findDirectory(vsourceRoot);
        if (sourceRoot == null) {
            return;
        }
        registrar.register((IntentionAction)new MoveClassToModuleFix(referenceName, currentModule, sourceRoot, psiElement));
    }
}

