/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFix;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaReferenceImporter
implements ReferenceImporter {
    @Override
    public boolean autoImportReferenceAtCursor(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/JavaReferenceImporter", "autoImportReferenceAtCursor"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/JavaReferenceImporter", "autoImportReferenceAtCursor"));
        }
        return CodeInsightSettings.getInstance().ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY && JavaReferenceImporter.autoImportReferenceAtCursor(editor, file2, false);
    }

    public static boolean autoImportReferenceAtCursor(@NotNull Editor editor, @NotNull PsiFile file2, boolean allowCaretNearRef) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/JavaReferenceImporter", "autoImportReferenceAtCursor"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/JavaReferenceImporter", "autoImportReferenceAtCursor"));
        }
        if (!file2.getViewProvider().getLanguages().contains(JavaLanguage.INSTANCE)) {
            return false;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(caretOffset);
        int startOffset = document.getLineStartOffset(lineNumber);
        int endOffset = document.getLineEndOffset(lineNumber);
        List<PsiElement> elements = CollectHighlightsUtil.getElementsInRange((PsiElement)file2, startOffset, endOffset);
        for (PsiElement element : elements) {
            PsiJavaCodeReferenceElement ref;
            if (!(element instanceof PsiJavaCodeReferenceElement) || (ref = (PsiJavaCodeReferenceElement)element).multiResolve(true).length != 0) continue;
            new ImportClassFix(ref).doFix(editor, false, allowCaretNearRef);
            return true;
        }
        return false;
    }

    @Override
    public boolean autoImportReferenceAt(@NotNull Editor editor, @NotNull PsiFile file2, int offset) {
        PsiJavaCodeReferenceElement ref;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/JavaReferenceImporter", "autoImportReferenceAt"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/JavaReferenceImporter", "autoImportReferenceAt"));
        }
        if (!CodeInsightSettings.getInstance().ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY) {
            return false;
        }
        if (!file2.getViewProvider().getLanguages().contains(JavaLanguage.INSTANCE)) {
            return false;
        }
        PsiReference element = file2.findReferenceAt(offset);
        if (element instanceof PsiJavaCodeReferenceElement && (ref = (PsiJavaCodeReferenceElement)element).multiResolve(true).length == 0) {
            new ImportClassFix(ref).doFix(editor, false, true);
            return true;
        }
        return false;
    }
}

