/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.completion.XmlClosingTagInsertHandler;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlTagNameProvider;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class TagNameReferenceCompletionProvider
extends CompletionProvider<CompletionParameters> {
    public static LookupElement[] getTagNameVariants(@NotNull XmlTag tag, String prefix) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInsight/completion/TagNameReferenceCompletionProvider", "getTagNameVariants"));
        }
        ArrayList<LookupElement> elements = new ArrayList<LookupElement>();
        for (XmlTagNameProvider tagNameProvider : (XmlTagNameProvider[])XmlTagNameProvider.EP_NAME.getExtensions()) {
            tagNameProvider.addTagNameVariants(elements, tag, prefix);
        }
        return elements.toArray(new LookupElement[elements.size()]);
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/TagNameReferenceCompletionProvider", "addCompletions"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/TagNameReferenceCompletionProvider", "addCompletions"));
        }
        LegacyCompletionContributor.processReferences(parameters, result2, (PairConsumer<PsiReference, CompletionResultSet>)((PairConsumer)(reference, set2) -> {
            TagNameReference tagNameReference;
            if (reference instanceof TagNameReference) {
                TagNameReferenceCompletionProvider.collectCompletionVariants((TagNameReference)reference, (Consumer<LookupElement>)set2);
            } else if (reference instanceof SchemaPrefixReference && (tagNameReference = ((SchemaPrefixReference)reference).getTagNameReference()) != null && !tagNameReference.isStartTagFlag()) {
                set2.consume(TagNameReferenceCompletionProvider.createClosingTagLookupElement((XmlTag)tagNameReference.getElement(), true, tagNameReference.getNameElement()));
            }
        }));
    }

    public static void collectCompletionVariants(TagNameReference tagNameReference, Consumer<LookupElement> consumer) {
        PsiElement element = tagNameReference.getElement();
        if (element instanceof XmlTag) {
            if (!tagNameReference.isStartTagFlag()) {
                consumer.consume((Object)TagNameReferenceCompletionProvider.createClosingTagLookupElement((XmlTag)element, false, tagNameReference.getNameElement()));
            } else {
                XmlTag tag = (XmlTag)element;
                for (LookupElement variant : TagNameReferenceCompletionProvider.getTagNameVariants(tag, tag.getNamespacePrefix())) {
                    consumer.consume((Object)variant);
                }
            }
        }
    }

    public static LookupElement createClosingTagLookupElement(XmlTag tag, boolean includePrefix, ASTNode nameElement) {
        LookupElementBuilder builder = LookupElementBuilder.create((String)(includePrefix || !nameElement.getText().contains(":") ? tag.getName() : tag.getLocalName()));
        return LookupElementDecorator.withInsertHandler(TailTypeDecorator.withTail(AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE.applyPolicy((LookupElement)builder), TailType.createSimpleTailType((char)'>')), (InsertHandler)XmlClosingTagInsertHandler.INSTANCE);
    }
}

