/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Set;

class LimitedAccessibleClassPreprocessor
implements Processor<PsiClass> {
    private final PsiElement myContext;
    private final CompletionParameters myParameters;
    private final boolean myFilterByScope;
    private final Consumer<PsiClass> myConsumer;
    private final int myLimit = Registry.intValue((String)"ide.completion.variant.limit");
    private int myCount;
    private final Set<String> myQNames = new THashSet();
    private final boolean myPkgContext;
    private final String myPackagePrefix;

    LimitedAccessibleClassPreprocessor(CompletionParameters parameters, boolean filterByScope, Consumer<PsiClass> consumer) {
        this.myContext = parameters.getPosition();
        this.myParameters = parameters;
        this.myFilterByScope = filterByScope;
        this.myConsumer = consumer;
        this.myPkgContext = JavaCompletionUtil.inSomePackage(this.myContext);
        this.myPackagePrefix = LimitedAccessibleClassPreprocessor.getPackagePrefix(this.myContext, this.myParameters.getOffset());
    }

    private static String getPackagePrefix(PsiElement context, int offset) {
        char c;
        int i2;
        CharSequence fileText = context.getContainingFile().getViewProvider().getContents();
        for (i2 = offset - 1; i2 >= 0 && (Character.isJavaIdentifierPart(c = fileText.charAt(i2)) || c == '.'); --i2) {
        }
        String prefix = fileText.subSequence(i2 + 1, offset).toString();
        int j = prefix.lastIndexOf(46);
        return j > 0 ? prefix.substring(0, j) : "";
    }

    public boolean process(PsiClass psiClass) {
        String qName;
        if (this.myParameters.getInvocationCount() < 2) {
            if (PsiReferenceExpressionImpl.seemsScrambled(psiClass)) {
                return true;
            }
            if (!StringUtil.isCapitalized((String)psiClass.getName()) && !Registry.is((String)"ide.completion.show.lower.case.classes")) {
                return true;
            }
        }
        assert (psiClass != null);
        if (AllClassesGetter.isAcceptableInContext(this.myContext, psiClass, this.myFilterByScope, this.myPkgContext) && (qName = psiClass.getQualifiedName()) != null && qName.startsWith(this.myPackagePrefix) && this.myQNames.add(qName)) {
            this.myConsumer.consume((Object)psiClass);
            if (++this.myCount > this.myLimit) {
                return false;
            }
        }
        return true;
    }
}

