/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ExtendedTagInsertHandler
extends XmlTagInsertHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.ExtendedTagInsertHandler");
    protected final String myElementName;
    @Nullable
    protected final String myNamespace;
    @Nullable
    protected final String myNamespacePrefix;

    public ExtendedTagInsertHandler(String elementName, @Nullable String namespace, @Nullable String namespacePrefix) {
        this.myElementName = elementName;
        this.myNamespace = namespace;
        this.myNamespacePrefix = namespacePrefix;
    }

    @Override
    public void handleInsert(final InsertionContext context, final LookupElement item) {
        XmlFile contextFile = (XmlFile)context.getFile();
        XmlExtension extension = XmlExtension.getExtension((PsiFile)contextFile);
        final XmlFile file2 = extension.getContainingFile((PsiElement)contextFile);
        final Project project2 = context.getProject();
        assert (file2 != null);
        PsiElement psiElement = file2.findElementAt(context.getStartOffset());
        assert (psiElement != null);
        if (this.isNamespaceBound(psiElement)) {
            this.doDefault(context, item);
            return;
        }
        final Editor editor = context.getEditor();
        final Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        int caretOffset = editor.getCaretModel().getOffset();
        final RangeMarker caretMarker = document.createRangeMarker(caretOffset, caretOffset);
        caretMarker.setGreedyToRight(true);
        XmlNamespaceHelper.Runner<String, IncorrectOperationException> runAfter = new XmlNamespaceHelper.Runner<String, IncorrectOperationException>(){

            @Override
            public void run(String namespacePrefix) {
                PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
                PsiElement element = file2.findElementAt(context.getStartOffset());
                if (element != null) {
                    ExtendedTagInsertHandler.this.qualifyWithPrefix(namespacePrefix, element, document);
                    PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
                }
                editor.getCaretModel().moveToOffset(caretMarker.getEndOffset());
                PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(document);
                ExtendedTagInsertHandler.this.doDefault(context, item);
            }
        };
        try {
            String prefixByNamespace = ExtendedTagInsertHandler.getPrefixByNamespace(file2, this.myNamespace);
            if (this.myNamespacePrefix != null || StringUtil.isEmpty((String)prefixByNamespace)) {
                String nsPrefix = this.myNamespacePrefix == null ? ExtendedTagInsertHandler.suggestPrefix(file2, this.myNamespace) : this.myNamespacePrefix;
                XmlNamespaceHelper.getHelper((PsiFile)file2).insertNamespaceDeclaration(file2, editor, Collections.singleton(this.myNamespace), nsPrefix, runAfter);
                FeatureUsageTracker.getInstance().triggerFeatureUsed("tag.name.completion");
            } else {
                runAfter.run(prefixByNamespace);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void doDefault(InsertionContext context, LookupElement item) {
        super.handleInsert(context, item);
    }

    protected boolean isNamespaceBound(PsiElement psiElement) {
        PsiElement parent = psiElement.getParent();
        if (!(parent instanceof XmlTag)) {
            return false;
        }
        XmlTag tag = (XmlTag)parent;
        XmlElementDescriptor tagDescriptor = tag.getDescriptor();
        String tagNamespace = tag.getNamespace();
        assert (this.myNamespace != null);
        return tagDescriptor != null && !(tagDescriptor instanceof AnyXmlElementDescriptor) && this.myNamespace.equals(tagNamespace);
    }

    @Nullable
    public static String getPrefixByNamespace(XmlFile file2, String namespace) {
        XmlTag tag = file2.getRootTag();
        return tag == null ? null : tag.getPrefixByNamespace(namespace);
    }

    @Nullable
    public static String suggestPrefix(XmlFile file2, @Nullable String namespace) {
        if (namespace == null) {
            return null;
        }
        for (XmlSchemaProvider provider : XmlSchemaProvider.getAvailableProviders((XmlFile)file2)) {
            String prefix = provider.getDefaultPrefix(namespace, file2);
            if (prefix == null) continue;
            return prefix;
        }
        return null;
    }

    protected Set<String> getNamespaces(XmlFile file2) {
        return XmlNamespaceHelper.getHelper((PsiFile)file2).getNamespacesByTagName(this.myElementName, file2);
    }

    protected void qualifyWithPrefix(String namespacePrefix, PsiElement element, Document document) {
        ExtendedTagInsertHandler.qualifyWithPrefix(namespacePrefix, element);
    }

    public static void qualifyWithPrefix(String namespacePrefix, PsiElement element) {
        String prefix;
        PsiElement tag = element.getParent();
        if (tag instanceof XmlTag && !(prefix = ((XmlTag)tag).getNamespacePrefix()).equals(namespacePrefix) && StringUtil.isNotEmpty((String)namespacePrefix)) {
            String name = namespacePrefix + ":" + ((XmlTag)tag).getLocalName();
            try {
                ((XmlTag)tag).setName(name);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

