/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.LimitedAccessibleClassPreprocessor;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.AllClassesSearchExecutor;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AllClassesGetter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.AllClassesGetter");
    public static final InsertHandler<JavaPsiClassReferenceElement> TRY_SHORTENING = new InsertHandler<JavaPsiClassReferenceElement>(){

        private void _handleInsert(InsertionContext context, JavaPsiClassReferenceElement item) {
            boolean insertFqn;
            RangeMarker toDelete;
            Document document;
            block15: {
                Editor editor = context.getEditor();
                PsiClass psiClass = item.getObject();
                if (!psiClass.isValid()) {
                    return;
                }
                int endOffset = editor.getCaretModel().getOffset();
                String qname = psiClass.getQualifiedName();
                if (qname == null) {
                    return;
                }
                if (endOffset == 0) {
                    return;
                }
                document = editor.getDocument();
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)psiClass.getProject());
                PsiFile file2 = context.getFile();
                if (file2.findElementAt(endOffset - 1) == null) {
                    return;
                }
                OffsetKey key2 = OffsetKey.create((String)"endOffset", (boolean)false);
                context.getOffsetMap().addOffset(key2, endOffset);
                PostprocessReformattingAspect.getInstance(context.getProject()).doPostponedFormatting();
                int newOffset = context.getOffsetMap().getOffset(key2);
                if (newOffset >= 0) {
                    endOffset = newOffset;
                } else {
                    LOG.error(endOffset + " became invalid: " + context.getOffsetMap() + "; inserting " + qname);
                }
                toDelete = JavaCompletionUtil.insertTemporary(endOffset, document, " ");
                psiDocumentManager.commitAllDocuments();
                PsiReference psiReference = file2.findReferenceAt(endOffset - 1);
                insertFqn = true;
                if (psiReference != null) {
                    PsiManager psiManager = file2.getManager();
                    if (psiManager.areElementsEquivalent((PsiElement)psiClass, JavaCompletionUtil.resolveReference(psiReference))) {
                        insertFqn = false;
                    } else if (psiClass.isValid()) {
                        try {
                            PsiElement psiElement;
                            context.setTailOffset(psiReference.getRangeInElement().getEndOffset() + psiReference.getElement().getTextRange().getStartOffset());
                            PsiElement newUnderlying = psiReference.bindToElement((PsiElement)psiClass);
                            if (newUnderlying == null || (psiElement = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(newUnderlying)) == null) break block15;
                            for (PsiReference reference : psiElement.getReferences()) {
                                if (!psiManager.areElementsEquivalent((PsiElement)psiClass, JavaCompletionUtil.resolveReference(reference))) continue;
                                insertFqn = false;
                                break;
                            }
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (toDelete.isValid()) {
                document.deleteString(toDelete.getStartOffset(), toDelete.getEndOffset());
                context.setTailOffset(toDelete.getStartOffset());
            }
            if (insertFqn) {
                INSERT_FQN.handleInsert(context, (LookupElement)item);
            }
        }

        public void handleInsert(InsertionContext context, JavaPsiClassReferenceElement item) {
            this._handleInsert(context, item);
            item.getTailType().processTail(context.getEditor(), context.getEditor().getCaretModel().getOffset());
        }
    };
    public static final InsertHandler<JavaPsiClassReferenceElement> INSERT_FQN = (context, item) -> {
        String qName = item.getQualifiedName();
        if (qName != null) {
            int start = JavaCompletionUtil.findQualifiedNameStart(context);
            context.getDocument().replaceString(start, context.getTailOffset(), (CharSequence)qName);
            LOG.assertTrue(context.getTailOffset() >= 0);
        }
    };

    public static void processJavaClasses(@NotNull CompletionParameters parameters, @NotNull PrefixMatcher prefixMatcher, boolean filterByScope, @NotNull Consumer<PsiClass> consumer) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/AllClassesGetter", "processJavaClasses"));
        }
        if (prefixMatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixMatcher", "com/intellij/codeInsight/completion/AllClassesGetter", "processJavaClasses"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/codeInsight/completion/AllClassesGetter", "processJavaClasses"));
        }
        PsiElement context = parameters.getPosition();
        Project project2 = context.getProject();
        GlobalSearchScope scope = filterByScope ? context.getContainingFile().getResolveScope() : GlobalSearchScope.allScope((Project)project2);
        AllClassesGetter.processJavaClasses(prefixMatcher, project2, scope, new LimitedAccessibleClassPreprocessor(parameters, filterByScope, consumer));
    }

    public static void processJavaClasses(@NotNull PrefixMatcher prefixMatcher, @NotNull Project project2, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiClass> processor2) {
        if (prefixMatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixMatcher", "com/intellij/codeInsight/completion/AllClassesGetter", "processJavaClasses"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/completion/AllClassesGetter", "processJavaClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInsight/completion/AllClassesGetter", "processJavaClasses"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/completion/AllClassesGetter", "processJavaClasses"));
        }
        THashSet names = new THashSet(10000);
        AllClassesSearchExecutor.processClassNames(project2, scope, (Consumer<String>)((Consumer)arg_0 -> AllClassesGetter.lambda$processJavaClasses$1(prefixMatcher, (Set)names, arg_0)));
        LinkedHashSet<String> sorted = CompletionUtil.sortMatching(prefixMatcher, (Collection<String>)names);
        AllClassesSearchExecutor.processClassesByNames(project2, scope, sorted, processor2);
    }

    public static boolean isAcceptableInContext(@NotNull PsiElement context, @NotNull PsiClass psiClass, boolean filterByScope, boolean pkgContext) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/AllClassesGetter", "isAcceptableInContext"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/completion/AllClassesGetter", "isAcceptableInContext"));
        }
        ProgressManager.checkCanceled();
        if (JavaCompletionUtil.isInExcludedPackage((PsiMember)psiClass, false)) {
            return false;
        }
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        if (!filterByScope && !(psiClass instanceof PsiCompiledElement)) {
            return true;
        }
        return JavaCompletionUtil.isSourceLevelAccessible(context, psiClass, pkgContext);
    }

    public static JavaPsiClassReferenceElement createLookupItem(@NotNull PsiClass psiClass, InsertHandler<JavaPsiClassReferenceElement> insertHandler) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/completion/AllClassesGetter", "createLookupItem"));
        }
        JavaPsiClassReferenceElement item = new JavaPsiClassReferenceElement(psiClass);
        item.setInsertHandler((InsertHandler)insertHandler);
        return item;
    }

    private static /* synthetic */ void lambda$processJavaClasses$1(@NotNull PrefixMatcher prefixMatcher, Set names, String s) {
        if (prefixMatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixMatcher", "com/intellij/codeInsight/completion/AllClassesGetter", "lambda$processJavaClasses$1"));
        }
        if (prefixMatcher.prefixMatches(s)) {
            names.add(s);
        }
    }
}

