/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VcsAwareFormatChangedTextUtil
extends FormatChangedTextUtil {
    VcsAwareFormatChangedTextUtil() {
    }

    @Override
    @NotNull
    public List<TextRange> getChangedTextRanges(@NotNull Project project2, @NotNull PsiFile file2) throws FilesTooBigForDiffException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getChangedTextRanges"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getChangedTextRanges"));
        }
        ChangedRangesInfo helper = this.getChangedRangesInfo(file2);
        List list = helper != null ? helper.allChangedRanges : ContainerUtil.newArrayList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getChangedTextRanges"));
        }
        return list;
    }

    @Override
    @Nullable
    public ChangedRangesInfo getChangedRangesInfo(@NotNull PsiFile file2) throws FilesTooBigForDiffException {
        CharSequence testContent;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getChangedRangesInfo"));
        }
        Project project2 = file2.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file2);
        if (document == null) {
            return null;
        }
        ChangedRangesInfo cachedChangedTextHelper = VcsAwareFormatChangedTextUtil.getCachedChangedLines(project2, document);
        if (cachedChangedTextHelper != null) {
            return cachedChangedTextHelper;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (testContent = (CharSequence)file2.getUserData(TEST_REVISION_CONTENT)) != null) {
            return VcsAwareFormatChangedTextUtil.calculateContextReformatHelper(document, testContent);
        }
        Change change = ChangeListManager.getInstance((Project)project2).getChange(file2.getVirtualFile());
        if (change == null) {
            return null;
        }
        if (change.getType() == Change.Type.NEW) {
            TextRange fileRange = file2.getTextRange();
            return new ChangedRangesInfo((List)ContainerUtil.newArrayList((Object[])new TextRange[]{fileRange}), null);
        }
        String contentFromVcs = VcsAwareFormatChangedTextUtil.getRevisionedContentFrom(change);
        return contentFromVcs != null ? VcsAwareFormatChangedTextUtil.calculateContextReformatHelper(document, contentFromVcs) : null;
    }

    @Nullable
    private static String getRevisionedContentFrom(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getRevisionedContentFrom"));
        }
        ContentRevision revision = change.getBeforeRevision();
        if (revision == null) {
            return null;
        }
        try {
            return revision.getContent();
        }
        catch (VcsException e) {
            LOG.error("Can't get content for: " + change.getVirtualFile(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static ChangedRangesInfo getCachedChangedLines(@NotNull Project project2, @NotNull Document document) {
        List<Range> ranges;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getCachedChangedLines"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getCachedChangedLines"));
        }
        LineStatusTracker tracker = LineStatusTrackerManager.getInstance(project2).getLineStatusTracker(document);
        if (tracker != null && (ranges = tracker.getRanges()) != null) {
            return VcsAwareFormatChangedTextUtil.getChangedTextRanges(document, ranges);
        }
        return null;
    }

    @NotNull
    protected static ChangedRangesInfo calculateContextReformatHelper(@NotNull Document document, @NotNull CharSequence contentFromVcs) throws FilesTooBigForDiffException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "calculateContextReformatHelper"));
        }
        if (contentFromVcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentFromVcs", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "calculateContextReformatHelper"));
        }
        ChangedRangesInfo changedRangesInfo = VcsAwareFormatChangedTextUtil.getChangedTextRanges(document, VcsAwareFormatChangedTextUtil.getRanges(document, contentFromVcs));
        if (changedRangesInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "calculateContextReformatHelper"));
        }
        return changedRangesInfo;
    }

    @NotNull
    private static List<Range> getRanges(@NotNull Document document, @NotNull CharSequence contentFromVcs) throws FilesTooBigForDiffException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getRanges"));
        }
        if (contentFromVcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentFromVcs", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getRanges"));
        }
        Document documentFromVcs = ((EditorFactoryImpl)EditorFactory.getInstance()).createDocument(contentFromVcs, true, false);
        List<Range> list = RangesBuilder.createRanges(document, documentFromVcs);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getRanges"));
        }
        return list;
    }

    @Override
    public int calculateChangedLinesNumber(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "calculateChangedLinesNumber"));
        }
        if (contentFromVcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentFromVcs", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "calculateChangedLinesNumber"));
        }
        try {
            List<Range> changedRanges = VcsAwareFormatChangedTextUtil.getRanges(document, contentFromVcs);
            int linesChanges = 0;
            for (Range range : changedRanges) {
                linesChanges += VcsAwareFormatChangedTextUtil.countLines(range);
            }
            return linesChanges;
        }
        catch (FilesTooBigForDiffException e) {
            LOG.info("File too big, can not calculate changed lines number");
            return -1;
        }
    }

    private static int countLines(Range range) {
        byte rangeType = range.getType();
        if (rangeType == 1) {
            int currentChangedLines = range.getLine2() - range.getLine1();
            int revisionLinesChanged = range.getVcsLine2() - range.getVcsLine1();
            return Math.max(currentChangedLines, revisionLinesChanged);
        }
        if (rangeType == 3) {
            return range.getVcsLine2() - range.getVcsLine1();
        }
        if (rangeType == 2) {
            return range.getLine2() - range.getLine1();
        }
        return 0;
    }

    @NotNull
    private static ChangedRangesInfo getChangedTextRanges(@NotNull Document document, @NotNull List<Range> changedRanges) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getChangedTextRanges"));
        }
        if (changedRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedRanges", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getChangedTextRanges"));
        }
        ArrayList ranges = ContainerUtil.newArrayList();
        ArrayList insertedRanges = ContainerUtil.newArrayList();
        for (Range range : changedRanges) {
            if (range.getType() == 3) continue;
            int changeStartLine = range.getLine1();
            int changeEndLine = range.getLine2();
            int lineStartOffset = document.getLineStartOffset(changeStartLine);
            int lineEndOffset = document.getLineEndOffset(changeEndLine - 1);
            TextRange changedTextRange = new TextRange(lineStartOffset, lineEndOffset);
            ranges.add(changedTextRange);
            if (range.getType() != 2) continue;
            insertedRanges.add(changedTextRange);
        }
        ChangedRangesInfo changedRangesInfo = new ChangedRangesInfo((List)ranges, (List)insertedRanges);
        if (changedRangesInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "getChangedTextRanges"));
        }
        return changedRangesInfo;
    }

    @Override
    public boolean isChangeNotTrackedForFile(@NotNull Project project2, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "isChangeNotTrackedForFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil", "isChangeNotTrackedForFile"));
        }
        boolean isUnderVcs = VcsUtil.isFileUnderVcs((Project)project2, (FilePath)VcsUtil.getFilePath((VirtualFile)file2.getVirtualFile()));
        if (!isUnderVcs) {
            return true;
        }
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(project2);
        List<VirtualFile> unversionedFiles = changeListManager.getUnversionedFiles();
        return unversionedFiles.contains(file2.getVirtualFile());
    }
}

