/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.FileTreeIterator;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.codeInsight.actions.LayoutCodeInfoCollector;
import com.intellij.lang.LanguageFormatting;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SequentialTask;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLayoutCodeProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor");
    protected final Project myProject;
    private final Module myModule;
    private PsiDirectory myDirectory;
    private PsiFile myFile;
    private List<PsiFile> myFiles;
    private boolean myIncludeSubdirs;
    private final String myProgressText;
    private final String myCommandName;
    private Runnable myPostRunnable;
    private boolean myProcessChangedTextOnly;
    protected AbstractLayoutCodeProcessor myPreviousCodeProcessor;
    private List<VirtualFileFilter> myFilters;
    private LayoutCodeInfoCollector myInfoCollector;

    protected AbstractLayoutCodeProcessor(Project project2, String commandName, String progressText, boolean processChangedTextOnly) {
        this(project2, (Module)null, commandName, progressText, processChangedTextOnly);
    }

    protected AbstractLayoutCodeProcessor(@NotNull AbstractLayoutCodeProcessor previous, @NotNull String commandName, @NotNull String progressText) {
        if (previous == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previous", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "<init>"));
        }
        if (commandName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandName", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "<init>"));
        }
        if (progressText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressText", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "<init>"));
        }
        this.myFilters = ContainerUtil.newArrayList();
        this.myProject = previous.myProject;
        this.myModule = previous.myModule;
        this.myDirectory = previous.myDirectory;
        this.myFile = previous.myFile;
        this.myFiles = previous.myFiles;
        this.myIncludeSubdirs = previous.myIncludeSubdirs;
        this.myProcessChangedTextOnly = previous.myProcessChangedTextOnly;
        this.myPostRunnable = null;
        this.myProgressText = progressText;
        this.myCommandName = commandName;
        this.myPreviousCodeProcessor = previous;
        this.myFilters = previous.myFilters;
        this.myInfoCollector = previous.myInfoCollector;
    }

    protected AbstractLayoutCodeProcessor(Project project2, @Nullable Module module2, String commandName, String progressText, boolean processChangedTextOnly) {
        this.myFilters = ContainerUtil.newArrayList();
        this.myProject = project2;
        this.myModule = module2;
        this.myDirectory = null;
        this.myIncludeSubdirs = true;
        this.myCommandName = commandName;
        this.myProgressText = progressText;
        this.myPostRunnable = null;
        this.myProcessChangedTextOnly = processChangedTextOnly;
    }

    protected AbstractLayoutCodeProcessor(Project project2, PsiDirectory directory, boolean includeSubdirs, String progressText, String commandName, boolean processChangedTextOnly) {
        this.myFilters = ContainerUtil.newArrayList();
        this.myProject = project2;
        this.myModule = null;
        this.myDirectory = directory;
        this.myIncludeSubdirs = includeSubdirs;
        this.myProgressText = progressText;
        this.myCommandName = commandName;
        this.myPostRunnable = null;
        this.myProcessChangedTextOnly = processChangedTextOnly;
    }

    protected AbstractLayoutCodeProcessor(Project project2, PsiFile file2, String progressText, String commandName, boolean processChangedTextOnly) {
        this.myFilters = ContainerUtil.newArrayList();
        this.myProject = project2;
        this.myModule = null;
        this.myFile = file2;
        this.myProgressText = progressText;
        this.myCommandName = commandName;
        this.myPostRunnable = null;
        this.myProcessChangedTextOnly = processChangedTextOnly;
    }

    protected AbstractLayoutCodeProcessor(Project project2, PsiFile[] files, String progressText, String commandName, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        this.myFilters = ContainerUtil.newArrayList();
        this.myProject = project2;
        this.myModule = null;
        this.myFiles = AbstractLayoutCodeProcessor.filterFilesTo(files, new ArrayList<PsiFile>());
        this.myProgressText = progressText;
        this.myCommandName = commandName;
        this.myPostRunnable = postRunnable;
        this.myProcessChangedTextOnly = processChangedTextOnly;
    }

    private static List<PsiFile> filterFilesTo(PsiFile[] files, List<PsiFile> list) {
        for (PsiFile file2 : files) {
            if (!AbstractLayoutCodeProcessor.canBeFormatted(file2)) continue;
            list.add(file2);
        }
        return list;
    }

    public void setPostRunnable(Runnable postRunnable) {
        this.myPostRunnable = postRunnable;
    }

    @Nullable
    private FutureTask<Boolean> getPreviousProcessorTask(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "getPreviousProcessorTask"));
        }
        return this.myPreviousCodeProcessor != null ? this.myPreviousCodeProcessor.preprocessFile(file2, processChangedTextOnly) : null;
    }

    public void setCollectInfo(boolean isCollectInfo) {
        this.myInfoCollector = isCollectInfo ? new LayoutCodeInfoCollector() : null;
        AbstractLayoutCodeProcessor current = this;
        while (current.myPreviousCodeProcessor != null) {
            current = current.myPreviousCodeProcessor;
            current.myInfoCollector = this.myInfoCollector;
        }
    }

    public void addFileFilter(@NotNull VirtualFileFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "addFileFilter"));
        }
        this.myFilters.add(filter);
    }

    protected void setProcessChangedTextOnly(boolean value) {
        this.myProcessChangedTextOnly = value;
    }

    @NotNull
    protected abstract FutureTask<Boolean> prepareTask(@NotNull PsiFile var1, boolean var2) throws IncorrectOperationException;

    public FutureTask<Boolean> preprocessFile(@NotNull PsiFile file2, boolean processChangedTextOnly) throws IncorrectOperationException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "preprocessFile"));
        }
        FutureTask<Boolean> previousTask = this.getPreviousProcessorTask(file2, processChangedTextOnly);
        FutureTask<Boolean> currentTask = this.prepareTask(file2, processChangedTextOnly);
        return new FutureTask<Boolean>(() -> {
            if (previousTask != null) {
                previousTask.run();
                if (!((Boolean)previousTask.get()).booleanValue() || previousTask.isCancelled()) {
                    return false;
                }
            }
            ApplicationManager.getApplication().runWriteAction(() -> currentTask.run());
            return (Boolean)currentTask.get() != false && !currentTask.isCancelled();
        });
    }

    public void run() {
        if (this.myFile != null) {
            this.runProcessFile(this.myFile);
            return;
        }
        FileTreeIterator iterator = this.myFiles != null ? new FileTreeIterator(this.myFiles) : (this.myProcessChangedTextOnly ? this.buildChangedFilesIterator() : this.buildFileTreeIterator());
        this.runProcessFiles(iterator);
    }

    private FileTreeIterator buildFileTreeIterator() {
        if (this.myDirectory != null) {
            return new FileTreeIterator(this.myDirectory);
        }
        if (this.myFiles != null) {
            return new FileTreeIterator(this.myFiles);
        }
        if (this.myModule != null) {
            return new FileTreeIterator(this.myModule);
        }
        if (this.myProject != null) {
            return new FileTreeIterator(this.myProject);
        }
        return new FileTreeIterator(Collections.emptyList());
    }

    @NotNull
    private FileTreeIterator buildChangedFilesIterator() {
        List<PsiFile> files = this.getChangedFilesFromContext();
        FileTreeIterator fileTreeIterator = new FileTreeIterator(files);
        if (fileTreeIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "buildChangedFilesIterator"));
        }
        return fileTreeIterator;
    }

    @NotNull
    private List<PsiFile> getChangedFilesFromContext() {
        List<PsiDirectory> dirs = this.getAllSearchableDirsFromContext();
        List<PsiFile> list = FormatChangedTextUtil.getChangedFilesFromDirs(this.myProject, dirs);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "getChangedFilesFromContext"));
        }
        return list;
    }

    private List<PsiDirectory> getAllSearchableDirsFromContext() {
        ArrayList dirs = ContainerUtil.newArrayList();
        if (this.myDirectory != null) {
            dirs.add(this.myDirectory);
        } else if (this.myModule != null) {
            List<PsiDirectory> allModuleDirs = FileTreeIterator.collectModuleDirectories(this.myModule);
            dirs.addAll(allModuleDirs);
        } else if (this.myProject != null) {
            List<PsiDirectory> allProjectDirs = FileTreeIterator.collectProjectDirectories(this.myProject);
            dirs.addAll(allProjectDirs);
        }
        return dirs;
    }

    private void runProcessFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "runProcessFile"));
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file2);
        if (document == null) {
            return;
        }
        if (!FileDocumentManager.getInstance().requestWriting(document, this.myProject)) {
            Messages.showMessageDialog((Project)this.myProject, (String)PsiBundle.message((String)"cannot.modify.a.read.only.file", (Object[])new Object[]{file2.getName()}), (String)CodeInsightBundle.message((String)"error.dialog.readonly.file.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        Ref writeActionRunnable = new Ref();
        Runnable readAction = () -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "lambda$runProcessFile$2"));
            }
            if (!this.checkFileWritable(file2)) {
                return;
            }
            try {
                FutureTask<Boolean> writeTask = this.preprocessFile(file2, this.myProcessChangedTextOnly);
                writeActionRunnable.set(writeTask);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        };
        Runnable writeAction = () -> {
            if (writeActionRunnable.isNull()) {
                return;
            }
            FutureTask task = (FutureTask)writeActionRunnable.get();
            task.run();
            try {
                task.get();
            }
            catch (CancellationException cancellationException) {
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        };
        this.runLayoutCodeProcess(readAction, writeAction, false);
    }

    private boolean checkFileWritable(PsiFile file2) {
        if (!file2.isWritable()) {
            ((MessagesEx.MessageInfo)MessagesEx.fileIsReadOnly(this.myProject, file2.getVirtualFile()).setTitle(CodeInsightBundle.message((String)"error.dialog.readonly.file.title", (Object[])new Object[0]))).showLater();
            return false;
        }
        return true;
    }

    private void runProcessFiles(@NotNull FileTreeIterator fileIterator) {
        if (fileIterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIterator", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "runProcessFiles"));
        }
        boolean isSuccess = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (fileIterator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIterator", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "lambda$runProcessFiles$4"));
            }
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            ReformatFilesTask task = new ReformatFilesTask(fileIterator, indicator);
            while (!task.isDone()) {
                task.iteration();
            }
        }, this.myCommandName, true, this.myProject);
        if (isSuccess && this.myPostRunnable != null) {
            this.myPostRunnable.run();
        }
    }

    private static boolean canBeFormatted(PsiFile file2) {
        if (LanguageFormatting.INSTANCE.forContext((PsiElement)file2) == null) {
            return false;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return true;
        }
        if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile)) {
            return false;
        }
        return !GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)virtualFile, (Project)file2.getProject());
    }

    private void runLayoutCodeProcess(Runnable readAction, Runnable writeAction, boolean globalAction) {
        ProgressWindow progressWindow = new ProgressWindow(true, this.myProject);
        progressWindow.setTitle(this.myCommandName);
        progressWindow.setText(this.myProgressText);
        ModalityState modalityState = ModalityState.current();
        Runnable process2 = () -> ApplicationManager.getApplication().runReadAction(readAction);
        Runnable runnable2 = () -> {
            try {
                ProgressManager.getInstance().runProcess(process2, (ProgressIndicator)progressWindow);
            }
            catch (ProcessCanceledException e) {
                return;
            }
            catch (IndexNotReadyException e) {
                return;
            }
            Runnable writeRunnable = () -> CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                if (globalAction) {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.myProject);
                }
                try {
                    writeAction.run();
                    if (this.myPostRunnable != null) {
                        ApplicationManager.getApplication().invokeLater(this.myPostRunnable);
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
            }, this.myCommandName, null);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                writeRunnable.run();
            } else {
                ApplicationManager.getApplication().invokeLater(writeRunnable, modalityState, this.myProject.getDisposed());
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(runnable2);
        }
    }

    public void runWithoutProgress() throws IncorrectOperationException {
        FutureTask<Boolean> runnable2 = this.preprocessFile(this.myFile, this.myProcessChangedTextOnly);
        runnable2.run();
    }

    private List<AbstractLayoutCodeProcessor> getAllProcessors() {
        AbstractLayoutCodeProcessor current = this;
        ArrayList all = ContainerUtil.newArrayList();
        while (current != null) {
            all.add(current);
            current = current.myPreviousCodeProcessor;
        }
        Collections.reverse(all);
        return all;
    }

    private boolean acceptedByFilters(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "acceptedByFilters"));
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        for (VirtualFileFilter filter : this.myFilters) {
            if (filter.accept(file2.getVirtualFile())) continue;
            return false;
        }
        return true;
    }

    protected static List<TextRange> getSelectedRanges(@NotNull SelectionModel selectionModel) {
        if (selectionModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionModel", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "getSelectedRanges"));
        }
        SmartList ranges = new SmartList();
        if (selectionModel.hasSelection()) {
            TextRange range = TextRange.create((int)selectionModel.getSelectionStart(), (int)selectionModel.getSelectionEnd());
            ranges.add(range);
        }
        return ranges;
    }

    protected void handleFileTooBigException(Logger logger, FilesTooBigForDiffException e, @NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor", "handleFileTooBigException"));
        }
        logger.info("Error while calculating changed ranges for: " + file2.getVirtualFile(), (Throwable)e);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            Notification notification = new Notification(ApplicationBundle.message((String)"reformat.changed.text.file.too.big.notification.groupId", (Object[])new Object[0]), ApplicationBundle.message((String)"reformat.changed.text.file.too.big.notification.title", (Object[])new Object[0]), ApplicationBundle.message((String)"reformat.changed.text.file.too.big.notification.text", (Object[])new Object[]{file2.getName()}), NotificationType.INFORMATION);
            notification.notify(file2.getProject());
        }
    }

    @Nullable
    public LayoutCodeInfoCollector getInfoCollector() {
        return this.myInfoCollector;
    }

    private class ReformatFilesTask
    implements SequentialTask {
        private final List<AbstractLayoutCodeProcessor> myProcessors;
        private final FileTreeIterator myFileTreeIterator;
        private final FileTreeIterator myCountingIterator;
        private final ProgressIndicator myProgressIndicator;
        private int myTotalFiles;
        private int myFilesProcessed;
        private boolean myStopFormatting;
        private boolean myFilesCountingFinished;

        ReformatFilesTask(@NotNull FileTreeIterator fileIterator, ProgressIndicator indicator) {
            if (fileIterator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIterator", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor$ReformatFilesTask", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor$ReformatFilesTask", "<init>"));
            }
            this.myTotalFiles = 0;
            this.myFilesProcessed = 0;
            this.myFileTreeIterator = fileIterator;
            this.myCountingIterator = new FileTreeIterator(fileIterator);
            this.myProcessors = AbstractLayoutCodeProcessor.this.getAllProcessors();
            this.myProgressIndicator = indicator;
        }

        public void prepare() {
        }

        public boolean isDone() {
            return this.myStopFormatting || !this.hasFilesToProcess(this.myFileTreeIterator);
        }

        private void countingIteration() {
            if (this.hasFilesToProcess(this.myCountingIterator)) {
                this.nextFile(this.myCountingIterator);
                ++this.myTotalFiles;
            } else {
                this.myFilesCountingFinished = true;
            }
        }

        public boolean iteration() {
            if (this.myStopFormatting) {
                return true;
            }
            if (!this.myFilesCountingFinished) {
                this.updateIndicatorText(ApplicationBundle.message((String)"bulk.reformat.prepare.progress.text", (Object[])new Object[0]), "");
                this.countingIteration();
                return true;
            }
            this.updateIndicatorFraction(this.myFilesProcessed);
            if (this.hasFilesToProcess(this.myFileTreeIterator)) {
                PsiFile file2 = this.nextFile(this.myFileTreeIterator);
                ++this.myFilesProcessed;
                if (this.shouldProcessFile(file2).booleanValue()) {
                    this.updateIndicatorText(ApplicationBundle.message((String)"bulk.reformat.process.progress.text", (Object[])new Object[0]), this.getPresentablePath(file2));
                    DumbService.getInstance((Project)AbstractLayoutCodeProcessor.this.myProject).withAlternativeResolveEnabled(() -> this.performFileProcessing(file2));
                }
            }
            return true;
        }

        @NotNull
        private PsiFile nextFile(FileTreeIterator it) {
            PsiFile psiFile = (PsiFile)ApplicationManager.getApplication().runReadAction(it::next);
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor$ReformatFilesTask", "nextFile"));
            }
            return psiFile;
        }

        private boolean hasFilesToProcess(FileTreeIterator it) {
            return it.hasNext();
        }

        private Boolean shouldProcessFile(PsiFile file2) {
            Computable computable = () -> file2.isWritable() && AbstractLayoutCodeProcessor.canBeFormatted(file2) && AbstractLayoutCodeProcessor.this.acceptedByFilters(file2);
            return (Boolean)ApplicationManager.getApplication().runReadAction(computable);
        }

        private void performFileProcessing(@NotNull PsiFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor$ReformatFilesTask", "performFileProcessing"));
            }
            this.myProcessors.stream().forEach(processor2 -> {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor$ReformatFilesTask", "lambda$performFileProcessing$4"));
                }
                Ref writeTaskRef = Ref.create();
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (file2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor$ReformatFilesTask", "lambda$null$2"));
                    }
                    writeTaskRef.set(processor2.prepareTask(file2, AbstractLayoutCodeProcessor.this.myProcessChangedTextOnly));
                });
                ProgressIndicatorProvider.checkCanceled();
                FutureTask writeTask = (FutureTask)writeTaskRef.get();
                ApplicationManager.getApplication().invokeAndWait(() -> WriteCommandAction.runWriteCommandAction((Project)AbstractLayoutCodeProcessor.this.myProject, (String)AbstractLayoutCodeProcessor.this.myCommandName, null, (Runnable)writeTask, (PsiFile[])new PsiFile[0]));
                this.checkStop(writeTask, file2);
            });
        }

        private void checkStop(FutureTask<Boolean> task, PsiFile file2) {
            try {
                if (!task.get().booleanValue() || task.isCancelled()) {
                    this.myStopFormatting = true;
                }
            }
            catch (InterruptedException e) {
                LOG.error("Got unexpected exception during formatting " + file2, (Throwable)e);
            }
            catch (ExecutionException e) {
                LOG.error("Got unexpected exception during formatting " + file2, (Throwable)e);
            }
        }

        private void updateIndicatorText(@NotNull String upperLabel, @NotNull String downLabel) {
            if (upperLabel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upperLabel", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor$ReformatFilesTask", "updateIndicatorText"));
            }
            if (downLabel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downLabel", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor$ReformatFilesTask", "updateIndicatorText"));
            }
            this.myProgressIndicator.setText(upperLabel);
            this.myProgressIndicator.setText2(downLabel);
        }

        private String getPresentablePath(@NotNull PsiFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor$ReformatFilesTask", "getPresentablePath"));
            }
            VirtualFile vFile = file2.getVirtualFile();
            return vFile != null ? ProjectUtil.calcRelativeToProjectPath((VirtualFile)vFile, (Project)AbstractLayoutCodeProcessor.this.myProject) : file2.getName();
        }

        private void updateIndicatorFraction(int processed2) {
            this.myProgressIndicator.setFraction((double)processed2 / (double)this.myTotalFiles);
        }

        public void stop() {
            this.myStopFormatting = true;
        }
    }
}

