/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.ImportSourceChooserDialog;
import com.intellij.application.options.SaveSchemeDialog;
import com.intellij.application.options.SkipSelfSearchComponent;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ImportHandler;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.EmptyColorScheme;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImportUtil;
import com.intellij.openapi.options.SchemeImporter;
import com.intellij.openapi.options.SchemeImporterEP;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemesPanel
extends JPanel
implements SkipSelfSearchComponent {
    private final ColorAndFontOptions myOptions;
    private ComboBox<MySchemeItem> mySchemeComboBox;
    private JButton myDeleteButton;
    private JButton myResetButton;
    private JButton myImportButton;
    private JLabel myHintLabel;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    private boolean myListLoaded = false;

    public SchemesPanel(ColorAndFontOptions options) {
        super(new BorderLayout());
        this.myOptions = options;
        JPanel schemesGroup = new JPanel(new BorderLayout());
        JPanel panel2 = new JPanel(new BorderLayout());
        schemesGroup.add((Component)this.createSchemePanel(), "North");
        schemesGroup.add((Component)panel2, "Center");
        this.add((Component)schemesGroup, "Center");
        this.mySchemeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/colors/SchemesPanel$1", "actionPerformed"));
                }
                String selectedName = SchemesPanel.this.getSelectedSchemeName();
                if (selectedName != null) {
                    EditorColorsScheme selected = SchemesPanel.this.myOptions.selectScheme(selectedName);
                    boolean readOnly = ColorAndFontOptions.isReadOnly(selected);
                    SchemesPanel.this.myDeleteButton.setEnabled(!readOnly && ColorAndFontOptions.canBeDeleted(selected));
                    SchemesPanel.this.myHintLabel.setVisible(readOnly);
                    if (SchemesPanel.this.areSchemesLoaded()) {
                        ((ColorAndFontSettingsListener)SchemesPanel.this.myDispatcher.getMulticaster()).schemeChanged(SchemesPanel.this);
                    }
                    AbstractColorsScheme originalScheme = selected instanceof AbstractColorsScheme ? ((AbstractColorsScheme)selected).getOriginal() : null;
                    SchemesPanel.this.myResetButton.setEnabled(!readOnly && selectedName.startsWith("_@user_") && originalScheme instanceof ReadOnlyColorsScheme);
                }
            }
        });
    }

    public boolean areSchemesLoaded() {
        return this.myListLoaded;
    }

    private JPanel createSchemePanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        int gridx = 0;
        panel2.add((Component)new JLabel(ApplicationBundle.message((String)"editbox.scheme.name", (Object[])new Object[0])), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)new JBInsets(0, 0, 5, 5), 0, 0));
        this.mySchemeComboBox = new ComboBox();
        panel2.add((Component)this.mySchemeComboBox, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)new JBInsets(0, 0, 5, 10), 0, 0));
        JButton saveAsButton = new JButton(ApplicationBundle.message((String)"button.save.as", (Object[])new Object[0]));
        saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/colors/SchemesPanel$2", "actionPerformed"));
                }
                SchemesPanel.this.showSaveAsDialog();
            }
        });
        panel2.add((Component)saveAsButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)new JBInsets(0, 0, 5, 5), 0, 0));
        this.myDeleteButton = new JButton(ApplicationBundle.message((String)"button.delete", (Object[])new Object[0]));
        this.myDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/colors/SchemesPanel$3", "actionPerformed"));
                }
                String selectedName = SchemesPanel.this.getSelectedSchemeName();
                if (selectedName != null) {
                    SchemesPanel.this.myOptions.removeScheme(selectedName);
                }
            }
        });
        panel2.add((Component)this.myDeleteButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)new JBInsets(0, 0, 5, 5), 0, 0));
        this.myResetButton = new JButton(ApplicationBundle.message((String)"color.scheme.reset", (Object[])new Object[0]));
        this.myResetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/colors/SchemesPanel$4", "actionPerformed"));
                }
                String selectedName = SchemesPanel.this.getSelectedSchemeName();
                if (selectedName != null && Messages.showOkCancelDialog((String)ApplicationBundle.message((String)"color.scheme.reset.message", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"color.scheme.reset.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                    SchemesPanel.this.myOptions.resetSchemeToOriginal(selectedName);
                }
            }
        });
        panel2.add((Component)this.myResetButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)new JBInsets(0, 0, 5, 5), 0, 0));
        this.myImportButton = new JButton("Import...");
        this.myImportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchemesPanel.this.chooseAndImport();
            }
        });
        this.myImportButton.setVisible(SchemesPanel.isImportAvailable());
        panel2.add((Component)this.myImportButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)new JBInsets(0, 0, 5, 5), 0, 0));
        this.myHintLabel = new JLabel(ApplicationBundle.message((String)"hint.readonly.scheme.cannot.be.modified", (Object[])new Object[0]));
        this.myHintLabel.setEnabled(false);
        panel2.add((Component)this.myHintLabel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)new JBInsets(0, 0, 5, 5), 0, 0));
        for (final ImportHandler importHandler : (ImportHandler[])Extensions.getExtensions(ImportHandler.EP_NAME)) {
            final JButton button = new JButton(importHandler.getTitle());
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/colors/SchemesPanel$6", "actionPerformed"));
                    }
                    importHandler.performImport(button, (Consumer<EditorColorsScheme>)((Consumer)scheme2 -> {
                        if (scheme2 != null) {
                            SchemesPanel.this.myOptions.addImportedScheme((EditorColorsScheme)scheme2);
                        }
                    }));
                }
            });
            panel2.add((Component)button, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)new JBInsets(0, 0, 5, 5), 0, 0));
        }
        panel2.add(Box.createHorizontalGlue(), new GridBagConstraints(gridx + 1, 0, 1, 1, 1.0, 0.0, 17, 2, (Insets)new JBInsets(0, 0, 0, 0), 0, 0));
        return panel2;
    }

    private void showSaveAsDialog() {
        ArrayList names = ContainerUtil.newArrayList((Object[])this.myOptions.getSchemeNames());
        String selectedName = AbstractColorsScheme.getDisplayName(this.myOptions.getSelectedScheme());
        SaveSchemeDialog dialog2 = new SaveSchemeDialog(this, ApplicationBundle.message((String)"title.save.color.scheme.as", (Object[])new Object[0]), names, selectedName);
        if (dialog2.showAndGet()) {
            this.myOptions.saveSchemeAs(dialog2.getSchemeName());
        }
    }

    @Deprecated
    public boolean updateDescription(boolean modified) {
        EditorColorsScheme scheme2 = this.myOptions.getSelectedScheme();
        return !modified || !ColorAndFontOptions.isReadOnly(scheme2);
    }

    public void resetSchemesCombo(Object source) {
        if (this != source) {
            this.setListLoaded(false);
            EditorColorsScheme selectedSchemeBackup = this.myOptions.getSelectedScheme();
            this.mySchemeComboBox.removeAllItems();
            String[] schemeNames = this.myOptions.getSchemeNames();
            MySchemeItem itemToSelect = null;
            for (String schemeName : schemeNames) {
                ColorAndFontOptions.MyColorScheme scheme2 = this.myOptions.getScheme(schemeName);
                MySchemeItem item = new MySchemeItem(scheme2);
                if (scheme2 == selectedSchemeBackup) {
                    itemToSelect = item;
                }
                this.mySchemeComboBox.addItem((Object)item);
            }
            this.mySchemeComboBox.setSelectedItem(itemToSelect);
            this.setListLoaded(true);
            ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).schemeChanged(this);
        }
    }

    @Nullable
    private String getSelectedSchemeName() {
        return this.mySchemeComboBox.getSelectedIndex() != -1 ? ((MySchemeItem)this.mySchemeComboBox.getSelectedItem()).getSchemeName() : null;
    }

    private void setListLoaded(boolean b) {
        this.myListLoaded = b;
    }

    public void addListener(ColorAndFontSettingsListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    private void chooseAndImport() {
        VirtualFile importSource;
        SchemeImporter<EditorColorsScheme> importer;
        String selectedImporterName;
        ImportSourceChooserDialog<EditorColorsScheme> importSourceChooserDialog = new ImportSourceChooserDialog<EditorColorsScheme>(this, EditorColorsScheme.class);
        if (importSourceChooserDialog.showAndGet() && (selectedImporterName = importSourceChooserDialog.getSelectedSourceName()) != null && (importer = SchemeImporterEP.getImporter(selectedImporterName, EditorColorsScheme.class)) != null && (importSource = SchemeImportUtil.selectImportSource(importer.getSourceExtensions(), this, null)) != null) {
            try {
                EditorColorsScheme imported = (EditorColorsScheme)importer.importScheme(DefaultProjectFactory.getInstance().getDefaultProject(), importSource, (Scheme)this.myOptions.getSelectedScheme(), name -> {
                    String newName = this.myOptions.getUniqueName(name);
                    EditorColorsSchemeImpl newScheme = new EditorColorsSchemeImpl(EmptyColorScheme.INSTANCE);
                    newScheme.setName(newName);
                    newScheme.setDefaultMetaInfo(EmptyColorScheme.INSTANCE);
                    return newScheme;
                });
                if (imported != null) {
                    this.myOptions.addImportedScheme(imported);
                }
            }
            catch (SchemeImportException e) {
                SchemeImportUtil.showStatus(this.myImportButton, "Import failed: " + e.getMessage(), MessageType.ERROR);
            }
        }
    }

    private static boolean isImportAvailable() {
        return !SchemeImporterEP.getExtensions(EditorColorsScheme.class).isEmpty();
    }

    private static final class MySchemeItem {
        private EditorColorsScheme myScheme;

        public MySchemeItem(EditorColorsScheme scheme2) {
            this.myScheme = scheme2;
        }

        public String getSchemeName() {
            return this.myScheme.getName();
        }

        public String toString() {
            return AbstractColorsScheme.getDisplayName(this.myScheme);
        }
    }
}

