/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html;

import freemarker.template.Template;
import java.io.IOException;
import jetbrains.coverage.report.impl.FooterInfos;
import jetbrains.coverage.report.impl.html.TemplateFactory;
import jetbrains.coverage.report.impl.html.TemplateProcessor;
import jetbrains.coverage.report.impl.html.TemplateProcessorBase;
import org.jetbrains.annotations.NotNull;

public class TemplateProcessorFactory {
    private final TemplateFactory myFactory;
    private final String myResourceBundleName;
    private final boolean myIncludeModule;
    private final FooterInfos myFooterInfos;

    public TemplateProcessorFactory(@NotNull TemplateFactory factory, @NotNull String resourceBundleName, boolean includeModule, @NotNull FooterInfos footerText) {
        if (factory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/TemplateProcessorFactory.<init> must not be null");
        }
        if (resourceBundleName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/coverage/report/impl/html/TemplateProcessorFactory.<init> must not be null");
        }
        if (footerText == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of jetbrains/coverage/report/impl/html/TemplateProcessorFactory.<init> must not be null");
        }
        this.myFactory = factory;
        this.myResourceBundleName = resourceBundleName;
        this.myIncludeModule = includeModule;
        this.myFooterInfos = footerText;
    }

    @NotNull
    public TemplateProcessor createModulesIndexProcessor() {
        TemplateProcessorBase templateProcessorBase = new TemplateProcessorBase(this.myResourceBundleName, this.myIncludeModule){

            @NotNull
            protected Template createTemplate() throws IOException {
                Template template = TemplateProcessorFactory.this.myFactory.createModulesIndexTemplate();
                if (template == null) {
                    throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/TemplateProcessorFactory$1.createTemplate must not return null");
                }
                return template;
            }

            protected String getFooterText() {
                return TemplateProcessorFactory.this.myFooterInfos.getModulesIndexFooterHTML();
            }
        };
        if (templateProcessorBase == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/TemplateProcessorFactory.createModulesIndexProcessor must not return null");
        }
        return templateProcessorBase;
    }

    @NotNull
    public TemplateProcessor createNamespacesIndexProcessor() {
        TemplateProcessorBase templateProcessorBase = new TemplateProcessorBase(this.myResourceBundleName, this.myIncludeModule){

            @NotNull
            protected Template createTemplate() throws IOException {
                Template template = TemplateProcessorFactory.this.myFactory.createNamespacesPerModuleIndexTemplate();
                if (template == null) {
                    throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/TemplateProcessorFactory$2.createTemplate must not return null");
                }
                return template;
            }

            protected String getFooterText() {
                return TemplateProcessorFactory.this.myFooterInfos.getNamespacesIndexFooterHTML();
            }
        };
        if (templateProcessorBase == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/TemplateProcessorFactory.createNamespacesIndexProcessor must not return null");
        }
        return templateProcessorBase;
    }

    @NotNull
    public TemplateProcessor createClassesIndexProcessor() {
        TemplateProcessorBase templateProcessorBase = new TemplateProcessorBase(this.myResourceBundleName, this.myIncludeModule){

            @NotNull
            protected Template createTemplate() throws IOException {
                Template template = TemplateProcessorFactory.this.myFactory.createNamespaceIndexTemplate();
                if (template == null) {
                    throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/TemplateProcessorFactory$3.createTemplate must not return null");
                }
                return template;
            }

            protected String getFooterText() {
                return TemplateProcessorFactory.this.myFooterInfos.getClassesIndexFooterHTML();
            }
        };
        if (templateProcessorBase == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/TemplateProcessorFactory.createClassesIndexProcessor must not return null");
        }
        return templateProcessorBase;
    }

    @NotNull
    public TemplateProcessor createClassSourceProcessor() {
        TemplateProcessorBase templateProcessorBase = new TemplateProcessorBase(this.myResourceBundleName, this.myIncludeModule){

            @NotNull
            protected Template createTemplate() throws IOException {
                Template template = TemplateProcessorFactory.this.myFactory.createClassCoverageTemplate();
                if (template == null) {
                    throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/TemplateProcessorFactory$4.createTemplate must not return null");
                }
                return template;
            }

            protected String getFooterText() {
                return TemplateProcessorFactory.this.myFooterInfos.getSourceFooterHTML();
            }
        };
        if (templateProcessorBase == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/TemplateProcessorFactory.createClassSourceProcessor must not return null");
        }
        return templateProcessorBase;
    }
}

