/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.reference;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemoveNodeJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.reference.ExpandReferenceJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.reference.FixToggleGroupReferenceJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCloner;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNode;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.JavaLanguage;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReferencesUpdater {
    private final EditorController editorController;
    private final FXOMDocument fxomDocument;
    private final List<Job> executedJobs = new LinkedList<Job>();
    private final Set<String> declaredFxIds = new HashSet<String>();
    private final FXOMCloner cloner;

    public ReferencesUpdater(EditorController editorController) {
        assert (editorController != null);
        assert (editorController.getFxomDocument() != null);
        this.editorController = editorController;
        this.fxomDocument = editorController.getFxomDocument();
        this.cloner = new FXOMCloner(this.fxomDocument);
    }

    public void update() {
        if (this.fxomDocument.getFxomRoot() != null) {
            this.declaredFxIds.clear();
            this.update(this.fxomDocument.getFxomRoot());
        }
    }

    public List<Job> getExecutedJobs() {
        return new LinkedList<Job>(this.executedJobs);
    }

    private void update(FXOMNode node) {
        if (node instanceof FXOMCollection) {
            this.updateCollection((FXOMCollection)node);
        } else if (node instanceof FXOMInstance) {
            this.updateInstance((FXOMInstance)node);
        } else if (node instanceof FXOMIntrinsic) {
            this.updateIntrinsic((FXOMIntrinsic)node);
        } else if (node instanceof FXOMPropertyC) {
            this.updatePropertyC((FXOMPropertyC)node);
        } else if (node instanceof FXOMPropertyT) {
            this.updatePropertyT((FXOMPropertyT)node);
        } else {
            throw new RuntimeException("Bug");
        }
    }

    private void updateCollection(FXOMCollection collection) {
        if (collection.getFxId() != null) {
            this.declaredFxIds.add(collection.getFxId());
        }
        List<FXOMObject> items = collection.getItems();
        int count = items.size();
        for (int i = 0; i < count; ++i) {
            this.update(items.get(i));
        }
    }

    private void updateInstance(FXOMInstance instance) {
        if (instance.getFxId() != null) {
            this.declaredFxIds.add(instance.getFxId());
        }
        Map<PropertyName, FXOMProperty> properties = instance.getProperties();
        LinkedList<PropertyName> names = new LinkedList<PropertyName>(properties.keySet());
        for (PropertyName propertyName : names) {
            this.update(properties.get(propertyName));
        }
    }

    private void updateIntrinsic(FXOMIntrinsic intrinsic) {
        switch (intrinsic.getType()) {
            case FX_REFERENCE: 
            case FX_COPY: {
                this.updateReference(intrinsic, intrinsic.getSource());
                break;
            }
        }
    }

    private void updatePropertyC(FXOMPropertyC property) {
        List<FXOMObject> values = property.getValues();
        int count = values.size();
        for (int i = 0; i < count; ++i) {
            this.update(values.get(i));
        }
    }

    private void updatePropertyT(FXOMPropertyT property) {
        String suffix;
        PrefixedValue pv = new PrefixedValue(property.getValue());
        if (pv.isExpression() && JavaLanguage.isIdentifier(suffix = pv.getSuffix())) {
            this.updateReference(property, suffix);
        }
    }

    private void updateReference(FXOMNode r, String fxId) {
        assert (r instanceof FXOMPropertyT || r instanceof FXOMIntrinsic);
        assert (fxId != null);
        if (!this.declaredFxIds.contains(fxId)) {
            FXOMObject declarer = this.fxomDocument.searchWithFxId(fxId);
            if (FXOMNodes.isToggleGroupReference(r)) {
                FixToggleGroupReferenceJob fixJob = new FixToggleGroupReferenceJob(r, this.editorController);
                ((Job)fixJob).execute();
                this.executedJobs.add(fixJob);
                this.declaredFxIds.add(fxId);
            } else if (FXOMNodes.isWeakReference(r) || declarer == null) {
                RemoveNodeJob removeJob = new RemoveNodeJob(r, this.editorController);
                ((Job)removeJob).execute();
                this.executedJobs.add(removeJob);
            } else {
                ExpandReferenceJob expandJob = new ExpandReferenceJob(r, this.cloner, this.editorController);
                ((Job)expandJob).execute();
                this.executedJobs.add(expandJob);
            }
        }
    }
}

