/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.DeleteObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.ArrayList;
import java.util.List;

public class RemoveColumnContentJob
extends BatchDocumentJob {
    private final FXOMObject targetGridPane;
    private final List<Integer> targetIndexes;

    public RemoveColumnContentJob(EditorController editorController, FXOMObject targetGridPane, List<Integer> targetIndexes) {
        super(editorController);
        assert (targetGridPane != null);
        assert (targetIndexes != null);
        this.targetGridPane = targetGridPane;
        this.targetIndexes = targetIndexes;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        assert (this.targetGridPane instanceof FXOMInstance);
        assert (!this.targetIndexes.isEmpty());
        DesignHierarchyMask targetGridPaneMask = new DesignHierarchyMask(this.targetGridPane);
        for (int targetIndex : this.targetIndexes) {
            List<FXOMObject> children = targetGridPaneMask.getColumnContentAtIndex(targetIndex);
            for (FXOMObject child : children) {
                DeleteObjectJob removeChildJob = new DeleteObjectJob(child, this.getEditorController());
                result.add(removeChildJob);
            }
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return "Remove Column Content";
    }
}

