/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.AddRowConstraintsJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.GridPaneJobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.ReIndexRowContentJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AddRowJob
extends BatchSelectionJob {
    private final Map<FXOMObject, Set<Integer>> targetGridPanes = new HashMap<FXOMObject, Set<Integer>>();
    private final GridPaneJobUtils.Position position;

    public AddRowJob(EditorController editorController, GridPaneJobUtils.Position position) {
        super(editorController);
        assert (position == GridPaneJobUtils.Position.ABOVE || position == GridPaneJobUtils.Position.BELOW);
        this.position = position;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        if (GridPaneJobUtils.canPerformAdd(this.getEditorController())) {
            assert (this.targetGridPanes.isEmpty());
            List<FXOMObject> objectList = GridPaneJobUtils.getTargetGridPanes(this.getEditorController());
            for (FXOMObject object : objectList) {
                Set<Integer> indexList = this.getTargetIndexes(this.getEditorController(), object);
                this.targetGridPanes.put(object, indexList);
            }
            AddRowConstraintsJob addConstraints = new AddRowConstraintsJob(this.getEditorController(), this.position, this.targetGridPanes);
            result.add(addConstraints);
            result.addAll(this.moveRowContent());
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return "Add Row " + this.position.name();
    }

    @Override
    protected AbstractSelectionGroup getNewSelectionGroup() {
        AbstractSelectionGroup asg;
        if (this.targetGridPanes.size() > 1) {
            Set<FXOMObject> objects = this.targetGridPanes.keySet();
            asg = new ObjectSelectionGroup(objects, objects.iterator().next(), null);
        } else {
            assert (this.targetGridPanes.size() == 1);
            FXOMInstance targetGridPane = (FXOMInstance)this.targetGridPanes.keySet().iterator().next();
            Set<Integer> targetIndexes = this.targetGridPanes.get(targetGridPane);
            assert (targetIndexes.size() >= 1);
            Set<Integer> addedIndexes = GridPaneJobUtils.getAddedIndexes(targetIndexes, this.position);
            asg = new GridSelectionGroup((FXOMObject)targetGridPane, GridSelectionGroup.Type.ROW, addedIndexes);
        }
        return asg;
    }

    private List<Job> moveRowContent() {
        ArrayList<Job> result = new ArrayList<Job>();
        for (FXOMObject targetGridPane : this.targetGridPanes.keySet()) {
            Set<Integer> targetIndexes = this.targetGridPanes.get(targetGridPane);
            DesignHierarchyMask mask = new DesignHierarchyMask(targetGridPane);
            int rowsSize = mask.getRowsSize();
            Iterator<Integer> iterator = targetIndexes.iterator();
            int shiftIndex = 0;
            int targetIndex = iterator.next();
            while (targetIndex != -1) {
                int toIndex;
                int fromIndex;
                switch (this.position) {
                    case ABOVE: {
                        fromIndex = targetIndex;
                        if (iterator.hasNext()) {
                            targetIndex = iterator.next();
                            toIndex = targetIndex - 1;
                            break;
                        }
                        targetIndex = -1;
                        toIndex = rowsSize - 1;
                        break;
                    }
                    case BELOW: {
                        fromIndex = targetIndex + 1;
                        if (iterator.hasNext()) {
                            toIndex = targetIndex = iterator.next().intValue();
                            break;
                        }
                        targetIndex = -1;
                        toIndex = rowsSize - 1;
                        break;
                    }
                    default: {
                        assert (false);
                        return result;
                    }
                }
                if (fromIndex < rowsSize) {
                    int offset = 1 + shiftIndex;
                    List<Integer> indexes = GridPaneJobUtils.getIndexes(fromIndex, toIndex);
                    ReIndexRowContentJob reIndexJob = new ReIndexRowContentJob(this.getEditorController(), offset, targetGridPane, indexes);
                    result.add(reIndexJob);
                }
                ++shiftIndex;
            }
        }
        return result;
    }

    private Set<Integer> getTargetIndexes(EditorController editorController, FXOMObject targetGridPane) {
        Selection selection = editorController.getSelection();
        AbstractSelectionGroup asg = selection.getGroup();
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        if (asg instanceof GridSelectionGroup && ((GridSelectionGroup)asg).getType() == GridSelectionGroup.Type.ROW) {
            GridSelectionGroup gsg = (GridSelectionGroup)asg;
            result.addAll(gsg.getIndexes());
        } else {
            switch (this.position) {
                case ABOVE: {
                    result.add(0);
                    break;
                }
                case BELOW: {
                    DesignHierarchyMask mask = new DesignHierarchyMask(targetGridPane);
                    int size = mask.getRowsSize();
                    result.add(size - 1);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        return result;
    }
}

